/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.cts;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.EnableChecked;
import com.vividsolutions.jump.workbench.plugin.Iconified;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SuggestTreeComboBox;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.cts.CRSFactory;
import org.cts.Identifier;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.CoordinateOperationFactory;
import org.cts.registry.EPSGRegistry;
import org.cts.registry.IGNFRegistry;
import org.cts.registry.Registry;
import org.cts.registry.RegistryException;
import org.cts.registry.RegistryManager;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.plugin.cts.CoordinateSystemWrapper;
import org.openjump.core.ui.plugin.cts.RegistryReader;

public class CTSPlugIn
extends ThreadedBasePlugIn
implements Iconified,
EnableChecked {
    private final String REGISTRY = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.registry");
    private final String SOURCE_LABEL = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.srcCRS");
    private final String TARGET_LABEL = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.tgtCRS");
    private final String OP_NOT_FOUND = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.op-not-found");
    private final String HETEROGEN_SRC = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.heterogeneous-sources");
    private final String TRANSFORM = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.transform");
    private final String REPLACE = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.replace");
    private final String SOURCE_DATUM = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.srcDatum");
    private final String TARGET_DATUM = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.tgtDatum");
    private final String SOURCE_SPHEROID = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.srcSpheroid");
    private final String TARGET_SPHEROID = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.tgtSpheroid");
    private final String SOURCE_TOWGS84 = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.srcToWgs84");
    private final String TARGET_TOWGS84 = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.tgtToWgs84");
    private final String TRANSFORMED_LAYERS = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.transformed-layers");
    private final String INVALID_SRC_CRS = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.invalid-src-crs");
    private final String INVALID_TGT_CRS = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.invalid-tgt-crs");
    private final String SOURCE_PROJECTION = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.srcProjection");
    private final String TARGET_PROJECTION = I18N.getInstance().get("org.openjump.core.ui.plugin.cts.CTSPlugIn.tgtProjection");
    private static final String EPSG = "EPSG";
    private static final String IGNF = "IGNF";
    private String registry = "EPSG";
    private String srcCode = "4326";
    private String tgtCode = "4326";
    private final Map<String, String> codes = new LinkedHashMap<String, String>(64);

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("world-grid.png");
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        CoordinateSystem coordSystem;
        String SOURCE = "source";
        String TARGET = "target";
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        if (context.getSelectedLayers().length > 0 && null != (coordSystem = context.getSelectedLayer(0).getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem())) {
            String string = this.srcCode = coordSystem == CoordinateSystem.UNSPECIFIED ? "0" : Integer.toString(coordSystem.getEPSGCode());
            if (this.srcCode.equals("0") && context.getSelectedLayer(0).getStyle(SRIDStyle.class) != null) {
                this.srcCode = Integer.toString(((SRIDStyle)context.getSelectedLayer(0).getStyle(SRIDStyle.class)).getSRID());
            }
        }
        final JComboBox<String> registry_cb = dialog.addComboBox(this.REGISTRY, this.registry, Arrays.asList(EPSG, IGNF), "");
        this.codes.clear();
        this.codes.putAll(this.getAvailableCRS(context, (String)registry_cb.getSelectedItem()));
        final SuggestTreeComboBox srcCodesCB = new SuggestTreeComboBox(this.codes.keySet().toArray(new String[this.codes.size()]), 8);
        srcCodesCB.setSelectedItem(this.srcCode);
        srcCodesCB.setPrototypeDisplayValue("abcdefghijklmnpqrstuvwxyz/0123456789");
        dialog.addRow("source", new JLabel(this.SOURCE_LABEL), srcCodesCB, new EnableCheck[0], "");
        final SuggestTreeComboBox tgtCodesCB = new SuggestTreeComboBox(this.codes.keySet().toArray(new String[this.codes.size()]), 8);
        tgtCodesCB.setSelectedItem(this.tgtCode);
        tgtCodesCB.setPrototypeDisplayValue("abcdefghijklmnpqrstuvwxyz/0123456789");
        dialog.addRow("target", new JLabel(this.TARGET_LABEL), tgtCodesCB, new EnableCheck[0], "");
        registry_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CTSPlugIn.this.codes.clear();
                    CTSPlugIn.this.codes.putAll(CTSPlugIn.this.getAvailableCRS(context, (String)registry_cb.getSelectedItem()));
                    srcCodesCB.changeModel(CTSPlugIn.this.codes.keySet().toArray(new String[CTSPlugIn.this.codes.size()]));
                    tgtCodesCB.changeModel(CTSPlugIn.this.codes.keySet().toArray(new String[CTSPlugIn.this.codes.size()]));
                    srcCodesCB.setSelectedItem(CTSPlugIn.this.codes.keySet().iterator().next());
                    tgtCodesCB.setSelectedItem(CTSPlugIn.this.codes.keySet().iterator().next());
                }
                catch (IOException | CRSException | RegistryException t) {
                    t.printStackTrace();
                }
            }
        });
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            this.registry = dialog.getText(this.REGISTRY);
            this.srcCode = this.codes.get(srcCodesCB.getSelectedItem());
            this.tgtCode = this.codes.get(tgtCodesCB.getSelectedItem());
            return true;
        }
        return false;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws RegistryException, CRSException, CoordinateOperationException {
        this.reportNothingToUndoYet(context);
        if (this.srcCode == null) {
            throw new RegistryException(this.INVALID_SRC_CRS);
        }
        if (this.tgtCode == null) {
            throw new RegistryException(this.INVALID_TGT_CRS);
        }
        if (!this.tgtCode.equals(this.srcCode)) {
            CRSFactory crsFactory = new CRSFactory();
            RegistryManager registryManager = crsFactory.getRegistryManager();
            if (this.registry.equals(EPSG)) {
                registryManager.addRegistry((Registry)new EPSGRegistry());
            } else if (this.registry.equals(IGNF)) {
                registryManager.addRegistry((Registry)new IGNFRegistry());
            }
            CoordinateReferenceSystem srcCRS = registryManager.getRegistry(this.registry).getCoordinateReferenceSystem(new Identifier(this.registry, this.srcCode, null));
            CoordinateReferenceSystem tgtCRS = registryManager.getRegistry(this.registry).getCoordinateReferenceSystem(new Identifier(this.registry, this.tgtCode, null));
            this.commitChanges(monitor, context, srcCRS, tgtCRS);
            this.report(context, srcCRS, tgtCRS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitChanges(final TaskMonitor monitor, final PlugInContext context, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem tgtCRS) throws CoordinateOperationException {
        CoordinateOperation coordinateOperation = this.getOperation(srcCRS, tgtCRS);
        if (coordinateOperation == null) {
            context.getWorkbenchFrame().warnUser(this.OP_NOT_FOUND);
            return;
        }
        Layer[] layers = context.getLayerNamePanel().getSelectedLayers();
        if (layers.length == 0) {
            return;
        }
        CoordinateFilter filter = this.getCoordinateFilter(coordinateOperation);
        boolean epsg = tgtCRS.getAuthorityName().equalsIgnoreCase(EPSG);
        int epsgCode = epsg ? Integer.parseInt(tgtCRS.getAuthorityKey()) : 0;
        CoordinateSystemWrapper newCoordinateSystem = new CoordinateSystemWrapper(tgtCRS);
        final HashMap srcGeometryMap = new HashMap();
        final HashMap tgtGeometryMap = new HashMap();
        final HashMap<String, CoordinateSystem> oldCoordinateSystems = new HashMap<String, CoordinateSystem>();
        final HashMap<String, SRIDStyle> oldSridStyles = new HashMap<String, SRIDStyle>();
        final HashMap<String, CoordinateSystemWrapper> newCoordinateSystems = new HashMap<String, CoordinateSystemWrapper>();
        context.getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
        for (Layer layer : context.getSelectedLayers()) {
            oldCoordinateSystems.put(layer.getName(), layer.getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem());
            ArrayList<Geometry> srcGeometries = new ArrayList<Geometry>();
            ArrayList<Geometry> tgtGeometries = new ArrayList<Geometry>();
            int count = 0;
            monitor.report(this.TRANSFORM + " " + layer.getName());
            for (Feature object : layer.getFeatureCollectionWrapper().getFeatures()) {
                Geometry srcGeom = object.getGeometry();
                srcGeometries.add(srcGeom);
                Geometry tgtGeom = (Geometry)srcGeom.clone();
                tgtGeom.apply(filter);
                tgtGeom.setSRID(epsgCode);
                tgtGeom.geometryChanged();
                tgtGeometries.add(tgtGeom);
                if (++count % 100 != 0) continue;
                monitor.report(count, layer.getFeatureCollectionWrapper().getFeatures().size(), "");
            }
            srcGeometryMap.put(layer.getName(), srcGeometries);
            tgtGeometryMap.put(layer.getName(), tgtGeometries);
            oldSridStyles.put(layer.getName(), (SRIDStyle)layer.getStyle(SRIDStyle.class));
            oldCoordinateSystems.put(layer.getName(), layer.getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem());
            newCoordinateSystems.put(layer.getName(), newCoordinateSystem);
        }
        UndoableCommand cmd = new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                boolean isFiringEvents = context.getLayerManager().isFiringEvents();
                context.getLayerManager().setFiringEvents(false);
                for (Layer layer : context.getSelectedLayers()) {
                    monitor.report(CTSPlugIn.this.REPLACE + " " + layer.getName());
                    List<Feature> features = layer.getFeatureCollectionWrapper().getFeatures();
                    ArrayList geometries = (ArrayList)tgtGeometryMap.get(layer.getName());
                    CoordinateSystem cs = (CoordinateSystem)newCoordinateSystems.get(layer.getName());
                    for (int i = 0; i < features.size(); ++i) {
                        Feature feature = features.get(i);
                        feature.setGeometry((Geometry)geometries.get(i));
                    }
                    Layer.tryToInvalidateEnvelope(layer);
                    layer.removeStyle(layer.getStyle(SRIDStyle.class));
                    SRIDStyle sridStyle = new SRIDStyle();
                    sridStyle.setSRID(cs.getEPSGCode());
                    layer.addStyle(sridStyle);
                    layer.getFeatureCollectionWrapper().getFeatureSchema().setCoordinateSystem(cs);
                    layer.setFeatureCollectionModified(true);
                }
                context.getLayerManager().setFiringEvents(isFiringEvents);
                try {
                    context.getLayerViewPanel().getViewport().zoomToFullExtent();
                }
                catch (NoninvertibleTransformException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void unexecute() {
                boolean isFiringEvents = context.getLayerManager().isFiringEvents();
                context.getLayerManager().setFiringEvents(false);
                for (Layer layer : context.getSelectedLayers()) {
                    List<Feature> features = layer.getFeatureCollectionWrapper().getFeatures();
                    ArrayList geometries = (ArrayList)srcGeometryMap.get(layer.getName());
                    CoordinateSystem cs = (CoordinateSystem)oldCoordinateSystems.get(layer.getName());
                    for (int i = 0; i < features.size(); ++i) {
                        Feature feature = features.get(i);
                        feature.setGeometry((Geometry)geometries.get(i));
                    }
                    Layer.tryToInvalidateEnvelope(layer);
                    layer.removeStyle(layer.getStyle(SRIDStyle.class));
                    if (oldSridStyles.get(layer.getName()) != null) {
                        layer.addStyle((Style)oldSridStyles.get(layer.getName()));
                    }
                    layer.getFeatureCollectionWrapper().getFeatureSchema().setCoordinateSystem(cs);
                    layer.setFeatureCollectionModified(true);
                }
                context.getLayerManager().setFiringEvents(isFiringEvents);
                try {
                    context.getLayerViewPanel().getViewport().zoomToFullExtent();
                }
                catch (NoninvertibleTransformException e) {
                    e.printStackTrace();
                }
            }
        };
        boolean exceptionOccurred = true;
        try {
            cmd.execute();
            exceptionOccurred = false;
        }
        finally {
            if (exceptionOccurred) {
                context.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
            }
        }
        context.getLayerManager().getUndoableEditReceiver().receive(cmd.toUndoableEdit());
    }

    private void report(PlugInContext context, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem tgtCRS) throws CoordinateOperationException {
        HTMLFrame html = context.getOutputFrame();
        html.createNewDocument();
        html.setTitle(this.getName());
        html.append("<h2>" + this.TRANSFORMED_LAYERS + "</h2>");
        html.append(Arrays.toString(context.getSelectedLayers()));
        html.append("<h2>" + this.SOURCE_LABEL + "</h2>");
        html.addField(this.SOURCE_LABEL, srcCRS.toString());
        html.addField(this.SOURCE_DATUM, srcCRS.getDatum().toString());
        html.addField(this.SOURCE_TOWGS84, srcCRS.getDatum().getToWGS84().toString());
        html.addField(this.SOURCE_SPHEROID, srcCRS.getDatum().getEllipsoid().toString());
        html.addField(this.SOURCE_PROJECTION, srcCRS.getProjection() == null ? "null" : srcCRS.getProjection().toWKT(srcCRS.getCoordinateSystem().getUnit(0)));
        html.append("<h2>" + this.TARGET_LABEL + "</h2>");
        html.addField(this.TARGET_LABEL, tgtCRS.toString());
        html.addField(this.TARGET_DATUM, tgtCRS.getDatum().toString());
        html.addField(this.TARGET_TOWGS84, tgtCRS.getDatum().getToWGS84().toString());
        html.addField(this.TARGET_SPHEROID, srcCRS.getDatum().getEllipsoid().toString());
        html.addField(this.TARGET_PROJECTION, tgtCRS.getProjection() == null ? "null" : tgtCRS.getProjection().toWKT(tgtCRS.getCoordinateSystem().getUnit(0)));
        html.append("<h2>" + this.getName() + "</h2>");
        CoordinateOperation op = this.getOperation(srcCRS, tgtCRS);
        if (op != null) {
            html.addField("", op.toString().replaceAll("\n", "<br>"));
        }
    }

    private CoordinateOperation getOperation(CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem tgtCRS) throws CoordinateOperationException {
        Set ops = CoordinateOperationFactory.createCoordinateOperations((GeodeticCRS)((GeodeticCRS)srcCRS), (GeodeticCRS)((GeodeticCRS)tgtCRS));
        return ops.size() == 0 ? null : CoordinateOperationFactory.getMostPrecise((Collection)ops);
    }

    private CoordinateFilter getCoordinateFilter(final CoordinateOperation op) {
        return new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                try {
                    double[] xyz = op.transform(new double[]{coordinate.x, coordinate.y, coordinate.z});
                    coordinate.setOrdinate(0, xyz[0]);
                    coordinate.setOrdinate(1, xyz[1]);
                    if (xyz.length > 2) {
                        coordinate.setOrdinate(2, xyz[2]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private Map<String, String> getAvailableCRS(PlugInContext context, String registry) throws IOException, RegistryException, CRSException {
        return RegistryReader.read(registry);
    }

    EnableCheck createEnableCheck(final WorkbenchContext context) {
        EnableCheckFactory f = EnableCheckFactory.getInstance(context);
        return new MultiEnableCheck().add(f.createTaskWindowMustBeActiveCheck()).add(f.createAtLeastNLayersMustBeSelectedCheck(1)).add(f.createSelectedLayersMustBeEditableCheck()).add(f.createSelectedLayerablesMustBeVectorLayers()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Layerable[] layerables = context.getLayerNamePanel().selectedNodes(Layerable.class).toArray(new Layerable[0]);
                if (layerables.length > 0) {
                    Layer layer = (Layer)layerables[0];
                    CoordinateSystem cs = layer.getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem();
                    SRIDStyle srid = (SRIDStyle)layer.getStyle(SRIDStyle.class);
                    for (int i = 1; i < layerables.length; ++i) {
                        layer = (Layer)layerables[i];
                        CoordinateSystem csi = layer.getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem();
                        SRIDStyle sridi = (SRIDStyle)layer.getStyle(SRIDStyle.class);
                        if (cs == csi && srid == sridi) continue;
                        if (cs == null && csi != null) {
                            return CTSPlugIn.this.HETEROGEN_SRC;
                        }
                        if (cs != null && csi == null) {
                            return CTSPlugIn.this.HETEROGEN_SRC;
                        }
                        if (cs == CoordinateSystem.UNSPECIFIED && csi != CoordinateSystem.UNSPECIFIED) {
                            return CTSPlugIn.this.HETEROGEN_SRC;
                        }
                        if (cs != CoordinateSystem.UNSPECIFIED && csi == CoordinateSystem.UNSPECIFIED) {
                            return CTSPlugIn.this.HETEROGEN_SRC;
                        }
                        if (cs != null && cs != CoordinateSystem.UNSPECIFIED && csi != CoordinateSystem.UNSPECIFIED && cs.getEPSGCode() != csi.getEPSGCode()) {
                            return CTSPlugIn.this.HETEROGEN_SRC;
                        }
                        if (srid == null || sridi == null || srid.getSRID() == sridi.getSRID()) continue;
                        return CTSPlugIn.this.HETEROGEN_SRC;
                    }
                    return null;
                }
                return "At least 1 layer must be selected";
            }
        });
    }
}

