/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.io.file;

import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.Layer;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.ui.io.file.AbstractFileLayerSaver;
import org.openjump.util.UriUtil;

public class DataSourceFileLayerSaver
extends AbstractFileLayerSaver {
    private Class dataSourceClass;
    private Layer layer;

    public DataSourceFileLayerSaver(Layer layer, Class dataSourceClass, String description, List<String> extensions) {
        super(description, extensions);
        this.dataSourceClass = dataSourceClass;
        this.layer = layer;
    }

    public DataSourceFileLayerSaver(Layer layer, FileDataSourceQueryChooser fdsqc) {
        this(layer, fdsqc.getDataSourceClass(), fdsqc.getDescription(), Arrays.asList(fdsqc.getExtensions()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(TaskMonitor monitor, URI uri, Map<String, Object> options) throws Exception {
        DataSource dataSource = (DataSource)LangUtil.newInstance(this.dataSourceClass);
        FeatureCollectionWrapper fc = this.layer.getFeatureCollectionWrapper();
        monitor.allowCancellationRequests();
        monitor.report("saving " + UriUtil.getFileName(uri));
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        options.put("Uri", uri);
        options.put("File", UriUtil.getFilePath(uri));
        dataSource.setProperties(options);
        SRSInfo srsInfo = ProjUtils.getSRSInfoFromLayerSource(this.layer);
        if (srsInfo != null) {
            dataSource.getProperties().put("SrsRegistry", srsInfo.getRegistry().name());
            dataSource.getProperties().put("SrsCode", srsInfo.getCode());
        }
        try (Connection connection = dataSource.getConnection();){
            connection.executeUpdate("", fc, monitor);
        }
        DataSourceQuery dataSourceQuery = new DataSourceQuery(dataSource, "", UriUtil.getFileNameWithoutExtension(uri));
        this.layer.setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
        return true;
    }
}

