/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.ColorUtils;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.ui.ColorEditor;
import org.openjump.core.rasterimage.styler.ui.ColorRenderer;

public class ColorsTablePanel
extends JPanel {
    public static final int COLUMN_VALUE = 0;
    public static final int COLUMN_COLOR = 1;
    private JTable table;
    private String[] columnNames;
    private Double noDataValue;
    private boolean integerValues;

    private ColorsTablePanel() {
        super(new GridLayout(1, 0));
    }

    public ColorsTablePanel(Component parent, TableType tableType, ColorMapEntry[] colorMapEntries, Double noDataValue, boolean integerValues) {
        super(new GridLayout(1, 0));
        if (tableType == TableType.INTERVALS) {
            this.columnNames = new String[]{I18N.get("org.openjump.core.rasterimage.styler.ui.ColorsTablePanel.MinValue"), I18N.get("org.openjump.core.rasterimage.styler.ui.ColorsTablePanel.Color")};
        } else if (tableType == TableType.VALUES) {
            this.columnNames = new String[]{I18N.get("org.openjump.core.rasterimage.styler.ui.ColorsTablePanel.Value"), I18N.get("org.openjump.core.rasterimage.styler.ui.ColorsTablePanel.Color")};
        }
        this.noDataValue = noDataValue;
        this.integerValues = integerValues;
        this.table = new JTable();
        this.table.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultEditor(Color.class, new ColorEditor(parent));
        this.updateTable(colorMapEntries);
        this.add(scrollPane);
    }

    public final void updateTable(ColorMapEntry[] colorMapEntries) {
        int noDataEntry = -1;
        if (this.noDataValue != null) {
            for (int c = 0; c < colorMapEntries.length; ++c) {
                double value = colorMapEntries[c].getUpperValue();
                if (value != this.noDataValue && (!Double.isInfinite(value) || !Double.isInfinite(this.noDataValue)) && (!Double.isNaN(value) || !Double.isNaN(this.noDataValue))) continue;
                noDataEntry = c;
                break;
            }
        }
        int numRows = colorMapEntries.length;
        if (noDataEntry > -1) {
            --numRows;
        }
        Object[][] data = new Object[numRows][this.columnNames.length];
        int r = 0;
        for (int cme = 0; cme < colorMapEntries.length; ++cme) {
            if (cme == noDataEntry) continue;
            for (int c = 0; c < this.columnNames.length; ++c) {
                if (c == 0) {
                    data[r][c] = colorMapEntries[cme].getUpperValue();
                    if (!this.integerValues) continue;
                    data[r][c] = (int)colorMapEntries[cme].getUpperValue();
                    continue;
                }
                if (c != 1) continue;
                data[r][c] = colorMapEntries[cme].getColor();
            }
            ++r;
        }
        this.table.setModel(new DefaultTableModel(data, this.columnNames){

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }
        });
        ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        DefaultTableCellRenderer centralAlignment = new DefaultTableCellRenderer();
        centralAlignment.setHorizontalAlignment(0);
        this.table.getColumnModel().getColumn(0).setCellRenderer(centralAlignment);
    }

    public ColorMapEntry[] getColorMapEntries() throws Exception {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        try {
            ColorMapEntry[] colorMapEntries = new ColorMapEntry[this.table.getRowCount()];
            for (int r = 0; r < colorMapEntries.length; ++r) {
                colorMapEntries[r] = new ColorMapEntry(Double.parseDouble(this.table.getValueAt(r, 0).toString()), (Color)this.table.getValueAt(r, 1));
            }
            return colorMapEntries;
        }
        catch (Exception ex) {
            throw new Exception(I18N.get("org.openjump.core.rasterimage.styler.ui.ColorsTablePanel.ErrorInTable") + ex);
        }
    }

    public void addRows() {
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length > 0) {
            Color color = (Color)this.table.getValueAt(selRows[0], 1);
            ((DefaultTableModel)this.table.getModel()).insertRow(selRows[0], new Object[]{null, color});
        } else {
            Color color = (Color)this.table.getValueAt(this.table.getRowCount() - 1, 1);
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{null, color});
            int lastRow = this.table.getRowCount() - 1;
            this.table.getSelectionModel().setSelectionInterval(lastRow, lastRow);
            this.table.scrollRectToVisible(this.table.getCellRect(lastRow, 1, true));
        }
    }

    public void removeRow() {
        int[] selRows = this.table.getSelectedRows();
        for (int i = selRows.length - 1; i >= 0; --i) {
            ((DefaultTableModel)this.table.getModel()).removeRow(selRows[i]);
        }
    }

    public int getSelectedRowsCount() {
        return this.table.getSelectedRowCount();
    }

    public void rampColors() throws Exception {
        int[] selRows = this.table.getSelectedRows();
        if (selRows == null || selRows.length <= 1) {
            return;
        }
        int startRow = selRows[0];
        int endRow = selRows[1];
        if (startRow >= endRow) {
            return;
        }
        if (endRow == startRow + 1) {
            return;
        }
        Color startColor = (Color)this.table.getValueAt(startRow, 1);
        Color endColor = (Color)this.table.getValueAt(endRow, 1);
        ColorUtils colorUtils = new ColorUtils();
        for (int r = startRow + 1; r < endRow; ++r) {
            double relDistance = (double)(r - startRow) / (double)(endRow - startRow);
            Color newColor = colorUtils.interpolateColor(startColor, endColor, relDistance);
            this.table.setValueAt(newColor, r, 1);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public static enum TableType {
        INTERVALS,
        VALUES;

    }
}

