/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.sextante.rasterWrappers;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.sextante.ISextanteLayer;
import org.openjump.core.rasterimage.sextante.ISextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridCell;

public class GridExtent {
    double m_dXMin;
    double m_dYMin;
    double m_dXMax;
    double m_dYMax;
    double m_dCellSizeX = 1.0;
    double m_dCellSizeY = 1.0;
    int m_iNX;
    int m_iNY;
    Envelope m_Envelope;
    WritableRaster m_Raster;

    public GridExtent() {
    }

    public GridExtent(ISextanteLayer layer) {
        this.m_dXMin = layer.getFullExtent().getMinX();
        this.m_dXMax = layer.getFullExtent().getMaxX();
        this.m_dYMin = layer.getFullExtent().getMinY();
        this.m_dYMax = layer.getFullExtent().getMaxY();
        if (layer instanceof ISextanteRasterLayer) {
            ISextanteRasterLayer rasterLayer = (ISextanteRasterLayer)layer;
            this.m_dCellSizeX = rasterLayer.getLayerGridExtent().getCellSize().x;
            this.m_dCellSizeY = rasterLayer.getLayerGridExtent().getCellSize().y;
        }
        this.recalculateNXAndNY();
    }

    public void setXRange(double dXMin, double dXMax) {
        this.m_dXMin = Math.min(dXMin, dXMax);
        this.m_dXMax = Math.max(dXMin, dXMax);
        this.recalculateNXAndNY();
    }

    public void setYRange(double dYMin, double dYMax) {
        this.m_dYMin = Math.min(dYMin, dYMax);
        this.m_dYMax = Math.max(dYMin, dYMax);
        this.recalculateNXAndNY();
    }

    public Point2D.Double getCellSize() {
        return new Point2D.Double(this.m_dCellSizeX, this.m_dCellSizeY);
    }

    public void setCellSize(double cellSizeX, double cellSizeY) {
        this.m_dCellSizeX = cellSizeX;
        this.m_dCellSizeY = cellSizeY;
        this.recalculateNXAndNY();
    }

    public void setValuesAndRaster(double cellSizeX, double cellSizeY, Envelope envelope, double nodata) {
        this.m_dCellSizeX = cellSizeX;
        this.m_dCellSizeY = cellSizeY;
        this.m_dXMin = Math.min(envelope.getMinX(), envelope.getMaxX());
        this.m_dXMax = Math.max(envelope.getMinX(), envelope.getMaxX());
        this.m_dYMin = Math.min(envelope.getMinY(), envelope.getMaxY());
        this.m_dYMax = Math.max(envelope.getMinY(), envelope.getMaxY());
        this.recalculateNXAndNY();
        this.m_iNX = this.getNX();
        this.m_iNY = this.getNY();
        this.m_Raster = RasterFactory.createBandedRaster((int)4, (int)this.m_iNX, (int)this.m_iNY, (int)1, null);
        for (int i = 0; i < this.m_iNX; ++i) {
            for (int j = 0; j < this.m_iNY; ++j) {
                this.m_Raster.setSample(i, j, 0, nodata);
            }
        }
    }

    public WritableRaster getRaster() {
        return this.m_Raster;
    }

    public Envelope getEnvelope() {
        return new Envelope(this.m_dXMin, this.m_dXMax, this.m_dYMin, this.m_dYMax);
    }

    public int getNX() {
        return this.m_iNX;
    }

    public int getNY() {
        return this.m_iNY;
    }

    private void recalculateNXAndNY() {
        this.m_iNY = (int)Math.round((this.m_dYMax - this.m_dYMin) / this.m_dCellSizeY);
        this.m_iNX = (int)Math.round((this.m_dXMax - this.m_dXMin) / this.m_dCellSizeX);
        this.m_dXMax = this.m_dXMin + this.m_dCellSizeX * (double)this.m_iNX;
        this.m_dYMax = this.m_dYMin + this.m_dCellSizeY * (double)this.m_iNY;
        this.m_Envelope = new Envelope(this.m_dXMin, this.m_dXMax, this.m_dYMin, this.m_dYMax);
    }

    public double getXMin() {
        return this.m_dXMin;
    }

    public double getXMax() {
        return this.m_dXMax;
    }

    public double getYMin() {
        return this.m_dYMin;
    }

    public double getYMax() {
        return this.m_dYMax;
    }

    public double getWidth() {
        return this.m_dXMax - this.m_dXMin;
    }

    public double getHeight() {
        return this.m_dYMax - this.m_dYMin;
    }

    public boolean contains(double x, double y) {
        return x >= this.m_dXMin && x <= this.m_dXMax && y >= this.m_dYMin && y <= this.m_dYMax;
    }

    public boolean fitsIn(GridExtent extent) {
        double MIN_DIF = 1.0E-5;
        if (extent.getCellSize().x != this.getCellSize().x) {
            return false;
        }
        if (extent.getCellSize().y != this.getCellSize().y) {
            return false;
        }
        double dOffset = Math.abs(extent.getXMin() - this.getXMin());
        double dOffsetCols = dOffset / this.getCellSize().x;
        boolean bFitsX = dOffsetCols - Math.floor(dOffsetCols + 0.5) < 1.0E-5;
        dOffset = Math.abs(extent.getYMax() - this.getYMax());
        double dOffsetRows = dOffset / this.getCellSize().y;
        boolean bFitsY = Math.abs(dOffsetRows - Math.floor(dOffsetRows + 0.5)) < 1.0E-5;
        return bFitsX && bFitsY;
    }

    public boolean equals(GridExtent extent) {
        return this.m_dXMin == extent.getXMin() && this.m_dXMax == extent.getXMax() && this.m_dYMin == extent.getYMin() && this.m_dYMax == extent.getYMax() && this.m_dCellSizeX == extent.getCellSize().x && this.m_dCellSizeY == extent.getCellSize().y;
    }

    public void addExtent(GridExtent extent) {
        this.m_dXMin = Math.min(extent.getXMin(), this.m_dXMin);
        this.m_dXMax = Math.max(extent.getXMax(), this.m_dXMax);
        this.m_dYMin = Math.min(extent.getYMin(), this.m_dYMin);
        this.m_dYMax = Math.max(extent.getYMax(), this.m_dYMax);
        this.m_dCellSizeX = Math.min(extent.getCellSize().x, this.m_dCellSizeX);
        this.m_dCellSizeY = Math.min(extent.getCellSize().y, this.m_dCellSizeY);
        this.recalculateNXAndNY();
    }

    public GridCell getGridCoordsFromWorldCoords(Point2D pt) {
        int x = (int)Math.floor((pt.getX() - this.m_dXMin) / this.m_dCellSizeX);
        int y = (int)Math.floor((this.m_dYMax - pt.getY()) / this.m_dCellSizeY);
        GridCell cell = new GridCell(x, y, 0.0);
        return cell;
    }

    public GridCell getGridCoordsFromWorldCoords(double x, double y) {
        return this.getGridCoordsFromWorldCoords(new Point2D.Double(x, y));
    }

    public Point2D getWorldCoordsFromGridCoords(GridCell cell) {
        double x = this.m_dXMin + ((double)cell.getX() + 0.5) * this.m_dCellSizeX;
        double y = this.m_dYMax - ((double)cell.getY() + 0.5) * this.m_dCellSizeY;
        Point2D.Double pt = new Point2D.Double(x, y);
        return pt;
    }

    public Point2D getWorldCoordsFromGridCoords(int x, int y) {
        return this.getWorldCoordsFromGridCoords(new GridCell(x, y, 0.0));
    }

    public Point getGridCoordsFromWorldCoords(Coordinate coordinate) {
        int x = (int)Math.floor((coordinate.x - this.m_dXMin) / this.m_dCellSizeX);
        int y = (int)Math.floor((coordinate.y - this.m_dYMin) / this.m_dCellSizeY);
        return new Point(x, y);
    }

    public String toString() {
        String s = "" + this.m_dXMin + ", " + this.m_dYMin + ", " + this.m_dXMax + ", " + this.m_dYMax + ", " + this.m_dCellSizeX + ", " + this.m_dCellSizeY;
        return s;
    }

    public void enlargeOneCell() {
        this.m_dYMin -= this.m_dCellSizeY;
        this.m_dXMin -= this.m_dCellSizeX;
        this.m_dXMax += this.m_dCellSizeX;
        this.m_dYMax += this.m_dCellSizeY;
        this.recalculateNXAndNY();
    }

    public Rectangle2D getAsRectangle2D() {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        ((Rectangle2D)rect).setRect(this.m_dXMin, this.m_dYMin, this.m_dXMax - this.m_dXMin, this.m_dYMax - this.m_dYMin);
        return rect;
    }

    public boolean containsCell(int x, int y) {
        return x >= 0 && x < this.m_iNX && y >= 0 && y < this.m_iNY;
    }
}

