/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.algorithms;

import com.sun.media.jai.codecimpl.util.RasterFactory;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.Resolution;

public class GenericRasterAlgorithm {
    private static final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private static final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");
    public static WorkbenchFrame frame = JUMPWorkbench.getInstance().getFrame();

    public void save_ChangeNoData(File outputFile, RasterImageLayer rasterImageLayer, int band, double oldnodata, double newnodata) throws IOException {
        RasterImageIO rasterImageIO;
        Raster ras = rasterImageLayer.getRasterData(null);
        Envelope env = rasterImageLayer.getWholeImageEnvelope();
        double cellSizeX = env.getWidth() / (double)ras.getWidth();
        double cellSizeY = env.getHeight() / (double)ras.getHeight();
        int width = ras.getWidth();
        int height = ras.getHeight();
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double value = ras.getSampleDouble(x, y, band);
                if (value == oldnodata) {
                    raster.setSample(x, y, band, newnodata);
                    continue;
                }
                raster.setSample(x, y, band, value);
            }
        }
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(outputFile, raster, env, new RasterImageIO.CellSizeXY(rasterImageIO2, cellSizeX, cellSizeY), newnodata);
    }

    public void save_ResetNoDataTag(File outputFile, RasterImageLayer rasterImageLayer, int band, double nodata) throws IOException {
        RasterImageIO rasterImageIO;
        Raster ras = rasterImageLayer.getRasterData(null);
        Envelope env = rasterImageLayer.getWholeImageEnvelope();
        double cellSizeX = env.getWidth() / (double)ras.getWidth();
        double cellSizeY = env.getHeight() / (double)ras.getHeight();
        int width = ras.getWidth();
        int height = ras.getHeight();
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double value = ras.getSampleDouble(x, y, band);
                raster.setSample(x, y, band, value);
            }
        }
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(outputFile, raster, env, new RasterImageIO.CellSizeXY(rasterImageIO2, cellSizeX, cellSizeY), nodata);
    }

    public void save_LimitValidData(File outputFile, RasterImageLayer rasterImageLayer, int band, double mindata, double maxdata) throws IOException {
        RasterImageIO rasterImageIO;
        Raster ras = rasterImageLayer.getRasterData(null);
        double nodata = rasterImageLayer.getNoDataValue();
        Envelope env = rasterImageLayer.getWholeImageEnvelope();
        double cellSizeX = env.getWidth() / (double)ras.getWidth();
        double cellSizeY = env.getHeight() / (double)ras.getHeight();
        int width = ras.getWidth();
        int height = ras.getHeight();
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double value = ras.getSampleDouble(x, y, band);
                if (value >= mindata && value <= maxdata) {
                    raster.setSample(x, y, band, nodata);
                    continue;
                }
                raster.setSample(x, y, band, value);
            }
        }
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(outputFile, raster, env, new RasterImageIO.CellSizeXY(rasterImageIO2, cellSizeX, cellSizeY), nodata);
    }

    public void save_ExtractValidData(File outputFile, RasterImageLayer rasterImageLayer, int band, double mindata, double maxdata) throws IOException {
        RasterImageIO rasterImageIO;
        Raster ras = rasterImageLayer.getRasterData(null);
        double nodata = rasterImageLayer.getNoDataValue();
        Envelope env = rasterImageLayer.getWholeImageEnvelope();
        double cellSizeX = env.getWidth() / (double)ras.getWidth();
        double cellSizeY = env.getHeight() / (double)ras.getHeight();
        int width = ras.getWidth();
        int height = ras.getHeight();
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double value = ras.getSampleDouble(x, y, band);
                if (value >= mindata && value <= maxdata) {
                    raster.setSample(x, y, band, value);
                    continue;
                }
                raster.setSample(x, y, band, nodata);
            }
        }
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(outputFile, raster, env, new RasterImageIO.CellSizeXY(rasterImageIO2, cellSizeX, cellSizeY), nodata);
    }

    public void save_ChangeDecimalValues(File outputFile, RasterImageLayer rLayer, int band, int n) throws IOException {
        RasterImageIO rasterImageIO;
        Raster ras = rLayer.getRasterData(null);
        double nodata = rLayer.getNoDataValue();
        Envelope env = rLayer.getWholeImageEnvelope();
        double cellSizeX = env.getWidth() / (double)ras.getWidth();
        double cellSizeY = env.getHeight() / (double)ras.getHeight();
        int width = ras.getWidth();
        int height = ras.getHeight();
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)1, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double value = ras.getSampleDouble(x, y, band);
                raster.setSample(x, y, band, MathUtil.round(value, n));
            }
        }
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(outputFile, raster, env, new RasterImageIO.CellSizeXY(rasterImageIO2, cellSizeX, cellSizeY), nodata);
    }

    protected void saved(File file) {
        frame.setStatusMessage(sSaved + " :" + file.getAbsolutePath());
    }

    protected void notsaved() {
        frame.warnUser(SCouldNotSave);
    }

    public void save_CropToEnvelope(File outputFile, RasterImageLayer rasterLayer, Envelope envelope) throws IOException {
        RasterImageIO rasterImageIO;
        Rectangle subset = rasterLayer.getRectangleFromEnvelope(envelope);
        Raster raster = rasterLayer.getRasterData(subset);
        if (rasterLayer.getImage().getColorModel() instanceof IndexColorModel && subset != null) {
            IndexColorModel indexColorModel = (IndexColorModel)rasterLayer.getImage().getColorModel();
            DataBuffer dataBufferIn = raster.getDataBuffer();
            DataBufferByte dataBufferOut = new DataBufferByte(subset.width * subset.height * 3, 3);
            int index = 0;
            int nCells = subset.height * subset.width;
            for (int r = 0; r < subset.height; ++r) {
                for (int c = 0; c < subset.width; ++c) {
                    int value = dataBufferIn.getElem(index);
                    dataBufferOut.setElem(0, index, indexColorModel.getRed(value));
                    dataBufferOut.setElem(1, index + nCells, indexColorModel.getGreen(value));
                    dataBufferOut.setElem(2, index + nCells * 2, indexColorModel.getBlue(value));
                    ++index;
                }
            }
            int[] bankIndices = new int[]{0, 1, 2};
            int[] bandOffsets = new int[]{0, raster.getWidth() * raster.getHeight(), 2 * raster.getWidth() * raster.getHeight()};
            raster = RasterFactory.createBandedRaster((DataBuffer)dataBufferOut, (int)raster.getWidth(), (int)raster.getHeight(), (int)raster.getWidth(), (int[])bankIndices, (int[])bandOffsets, (java.awt.Point)new java.awt.Point(0, 0));
        }
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(outputFile, raster, envelope, new RasterImageIO.CellSizeXY(rasterImageIO2, rasterLayer.getMetadata().getOriginalCellSize(), rasterLayer.getMetadata().getOriginalCellSize()), rasterLayer.getMetadata().getNoDataValue());
    }

    public void save_CropToGeometry(File outputFile, RasterImageLayer rasterLayer, Geometry geometry) throws IOException {
        RasterImageIO rasterImageIO;
        Envelope env = geometry.getEnvelopeInternal();
        Rectangle subset = rasterLayer.getRectangleFromEnvelope(env);
        Raster raster = rasterLayer.getRasterData(subset);
        int width = raster.getWidth();
        int height = raster.getHeight();
        int band = rasterLayer.getNumBands();
        WritableRaster raster2 = RasterFactory.createBandedRaster((int)4, (int)width, (int)height, (int)band, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                GeometryFactory gf = new GeometryFactory();
                Point point = gf.createPoint(new Coordinate((double)x, (double)y));
                for (int b = 0; b < band; ++b) {
                    double value = point.intersects(geometry) ? raster.getSampleDouble(x, y, b) : rasterLayer.getNoDataValue();
                    raster2.setSample(x, y, b, value);
                }
            }
        }
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(outputFile, raster2, env, new RasterImageIO.CellSizeXY(rasterImageIO2, rasterLayer.getMetadata().getOriginalCellSize(), rasterLayer.getMetadata().getOriginalCellSize()), rasterLayer.getMetadata().getNoDataValue());
    }

    public void save_WarpToEnvelope(File file, RasterImageLayer rLayer, Envelope env) throws Exception {
        float xScale = (float)(env.getWidth() / rLayer.getWholeImageEnvelope().getWidth());
        float yScale = (float)(env.getHeight() / rLayer.getWholeImageEnvelope().getHeight());
        RasterImageIO rasterImageIO = new RasterImageIO();
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(rLayer.getImageFileName(), rLayer.getMetadata().getStats(), null, null);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(imageAndMetadata.getImage());
        pb.add(xScale);
        pb.add(yScale);
        RenderedOp outputOp = JAI.create((String)"Scale", (ParameterBlock)pb, null);
        WritableRaster writableRaster = outputOp.copyData();
        RasterImageIO rasterImageIO2 = rasterImageIO;
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(file, writableRaster, env, new RasterImageIO.CellSizeXY(rasterImageIO2, rLayer.getMetadata().getOriginalCellSize(), rLayer.getMetadata().getOriginalCellSize()), rLayer.getMetadata().getNoDataValue());
    }

    public void load(File inputFile, String category) throws Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        java.awt.Point point = RasterImageIO.getImageDimensions(inputFile.getAbsolutePath());
        Envelope env = RasterImageIO.getGeoReferencing(inputFile.getAbsolutePath(), true, point);
        Viewport viewport = frame.getContext().getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(inputFile.getAbsolutePath(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        RasterImageLayer ril = new RasterImageLayer(inputFile.getName(), frame.getContext().getLayerManager(), inputFile.getAbsolutePath(), imageAndMetadata.getImage(), env);
        try {
            category = ((Category)frame.getContext().getLayerableNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException e) {
            Logger.warn("GenericRasterAlgorithm.load(\"" + inputFile + "\",\"" + category + "\") : error trying to get the name of the currently selected category", e);
        }
        frame.getContext().getLayerManager().addLayerable(category, ril);
    }
}

