/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.Overview;
import org.openjump.core.rasterimage.Overviews;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.rasterimage.TiffUtilsV2;

public class OverviewsUtils {
    private static final float[] lowPassFilter = new float[]{0.5f, 0.33333334f, 0.0f, -0.083333336f};

    public static Overviews getOverviews(File tiffFile, Envelope envelope) throws IOException {
        Overviews overviews = new Overviews();
        overviews = OverviewsUtils.addOverviews(tiffFile, envelope, Overviews.OverviewLocation.INTERNAL, overviews);
        File ovrFile = new File(tiffFile.getParent(), tiffFile.getName() + ".ovr");
        if (ovrFile.exists()) {
            overviews = OverviewsUtils.addOverviews(ovrFile, envelope, Overviews.OverviewLocation.EXTERNAL, overviews);
        }
        return overviews;
    }

    private static Overviews addOverviews(File tiffFile, Envelope envelope, Overviews.OverviewLocation overviewLocation, Overviews overviews) throws IOException {
        ImageInputStream is = ImageIO.createImageInputStream(tiffFile);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(is);
        if (iterator != null && iterator.hasNext()) {
            ImageReader reader = iterator.next();
            reader.setInput(is);
            for (int i = 0; i < reader.getNumImages(true); ++i) {
                Resolution resolution = OverviewsUtils.calcResolution(envelope, new Point(reader.getWidth(i), reader.getHeight(i)));
                overviews.addOverview(new Overview(overviewLocation, resolution));
            }
        }
        return overviews;
    }

    private static Resolution calcResolution(Envelope envelope, Point imageDims) {
        double xRes = envelope.getWidth() / (double)imageDims.x;
        double yRes = envelope.getHeight() / (double)imageDims.y;
        return new Resolution(xRes, yRes);
    }

    public static void createOverviews(File tiffFile, int overviewsCount) throws IOException {
        RenderedOp originalImage = TiffUtilsV2.getRenderedOp(tiffFile);
        FileOutputStream out = new FileOutputStream(new File(tiffFile.getParent(), tiffFile.getName() + ".ovr"));
        ParameterBlock paramBlock = new ParameterBlock();
        paramBlock.addSource(originalImage.createInstance());
        PlanarImage[] images = new PlanarImage[overviewsCount];
        for (int o = 0; o < overviewsCount; ++o) {
            int downsampleStep = (int)Math.pow(2.0, o + 1);
            Double xScale = 1.0 / (double)downsampleStep;
            Double yScale = 1.0 / (double)downsampleStep;
            RenderedOp newImage = OverviewsUtils.scaleAverage(paramBlock, xScale, yScale);
            images[o] = newImage.createInstance();
        }
        OverviewsUtils.saveTiffJAI(out, images);
    }

    public static RenderedOp scaleAverage(ParameterBlock paramBlock, double xScale, double yScale) {
        paramBlock.removeParameters();
        paramBlock.add(xScale);
        paramBlock.add(yScale);
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return JAI.create((String)"SubsampleAverage", (ParameterBlock)paramBlock, (RenderingHints)qualityHints);
    }

    private static RenderedOp bicubic(ParameterBlock pb, int xScale, int yScale) {
        pb.add(xScale);
        pb.add(yScale);
        pb.add(new float[]{1.0f});
        pb.add(new InterpolationBicubic(2));
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
    }

    private static RenderedOp bilinear(ParameterBlock pb, double xScale, double yScale) {
        pb.add(xScale);
        pb.add(yScale);
        pb.add(new float[]{1.0f});
        pb.add(new InterpolationBilinear());
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
    }

    private static RenderedOp subsample(PlanarImage src, int xScale, int yScale) {
        ParameterBlockJAI pb = new ParameterBlockJAI("filteredsubsample");
        pb.addSource((Object)src);
        pb.add(xScale);
        pb.add(yScale);
        pb.add((Object)new float[]{1.0f});
        pb.add((Object)Interpolation.getInstance((int)0));
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb, (RenderingHints)new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
    }

    private static RenderedOp filteredSubsample(ParameterBlock pb, double xScale, double yScale) {
        pb.add(xScale);
        pb.add(yScale);
        pb.add(lowPassFilter);
        pb.add(Interpolation.getInstance((int)0));
        return JAI.create((String)"filteredsubsample", (ParameterBlock)pb);
    }

    private static void saveTiffJAI(OutputStream out, PlanarImage[] images) throws IOException {
        TIFFEncodeParam param = new TIFFEncodeParam();
        param.setTileSize(512, 512);
        param.setWriteTiled(true);
        param.setCompression(32946);
        ImageEncoder encoder = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)out, (ImageEncodeParam)param);
        ArrayList<PlanarImage> list = new ArrayList<PlanarImage>();
        for (int i = 1; i < images.length; ++i) {
            list.add(images[i]);
        }
        param.setExtraImages(list.iterator());
        encoder.encode((RenderedImage)images[0]);
        out.close();
    }

    public static enum ScaleAlgorithm {
        AVERAGE,
        SUBSAMPLE,
        BILINEAR,
        NEAREST_NEIGHBOUR,
        BICUBIC;

    }

    public static enum CompressionType {
        LZW,
        JPEG;

    }
}

