/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.apitools;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.TIFFCodec;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.FMEGMLReader;
import com.vividsolutions.jump.io.JMLReader;
import com.vividsolutions.jump.io.JMLWriter;
import com.vividsolutions.jump.io.ShapefileReader;
import com.vividsolutions.jump.io.ShapefileWriter;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoImageFactoryFileLayerLoader;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import de.latlon.deejump.plugin.style.LayerStyle2SLDPlugIn;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geotools.dbffile.DbfFieldDef;
import org.geotools.dbffile.DbfFile;
import org.geotools.dbffile.DbfFileWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;
import org.openjump.core.ui.plugin.style.ImportSLDPlugIn;
import org.openjump.core.ui.util.ScreenScale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IOTools {
    static LayerManager manager = JUMPWorkbench.getInstance().getFrame().getContext().getLayerManager();

    private static String getExtension(String filename) {
        int len = filename.length();
        return filename.substring(len - 3, len);
    }

    public static FeatureCollection load(String filename) throws Exception {
        String extension = IOTools.getExtension(filename);
        if (extension.equalsIgnoreCase("SHP")) {
            return IOTools.loadShapefile(filename);
        }
        if (extension.equalsIgnoreCase("JML")) {
            return IOTools.loadJMLFile(filename);
        }
        if (extension.equalsIgnoreCase("WKT")) {
            return IOTools.loadWKT(filename);
        }
        throw new Exception("Unknown file type: " + extension);
    }

    public static FeatureCollection load(String filename, String zipFileName) throws Exception {
        String extension = IOTools.getExtension(filename);
        if (extension.equalsIgnoreCase("SHP")) {
            return IOTools.loadShapefile(filename, zipFileName);
        }
        throw new Exception("Unknown file type: " + extension);
    }

    public static FeatureCollection loadJMLFile(String filename) throws Exception {
        JMLReader rdr = new JMLReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        return rdr.read(dp);
    }

    public static FeatureCollection loadShapefile(String filename) throws Exception {
        ShapefileReader rdr = new ShapefileReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        return rdr.read(dp);
    }

    public static FeatureCollection loadShapefile(String filename, String zipFileName) throws Exception {
        ShapefileReader rdr = new ShapefileReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        if (zipFileName != null) {
            dp.set("CompressedFile", zipFileName);
        }
        return rdr.read(dp);
    }

    public static FeatureCollection loadFMEGML(String filename) throws Exception {
        FMEGMLReader rdr = new FMEGMLReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        return rdr.read(dp);
    }

    public static FeatureCollection loadWKT(String filename) throws Exception {
        WKTReader rdr = new WKTReader();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        FeatureCollection fc = rdr.read(dp);
        return fc;
    }

    public static void save(FeatureCollection fc, String filename) throws Exception {
        String extension = IOTools.getExtension(filename);
        if (extension.equalsIgnoreCase("SHP")) {
            IOTools.saveShapefile(fc, filename);
            return;
        }
        if (extension.equalsIgnoreCase("JML")) {
            IOTools.saveJMLFile(fc, filename);
            return;
        }
        throw new Exception("Unknown file type: " + extension);
    }

    public static void saveShapefile(FeatureCollection fc, String filename) throws Exception {
        ShapefileWriter writer = new ShapefileWriter();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        writer.write(fc, dp);
    }

    public static void saveJMLFile(FeatureCollection fc, String filename) throws Exception {
        JMLWriter writer = new JMLWriter();
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        writer.write(fc, dp);
    }

    public static void saveDbfFile(FeatureCollection fc, String filename) throws Exception {
        FeatureSchema fs = fc.getFeatureSchema();
        DbfFieldDef[] fields = new DbfFieldDef[fs.getAttributeCount()];
        int f = 0;
        for (int t = 0; t < fs.getAttributeCount(); ++t) {
            int maxlength;
            AttributeType columnType = fs.getAttributeType(t);
            String columnName = fs.getAttributeName(t);
            if (columnType == AttributeType.INTEGER) {
                fields[f] = new DbfFieldDef(columnName, 'N', 16, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DOUBLE) {
                fields[f] = new DbfFieldDef(columnName, 'N', 33, 16);
                ++f;
                continue;
            }
            if (columnType == AttributeType.STRING) {
                maxlength = IOTools.findMaxStringLength(fc, t);
                fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DATE) {
                fields[f] = new DbfFieldDef(columnName, 'D', 8, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.BOOLEAN) {
                fields[f] = new DbfFieldDef(columnName, 'L', 1, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.NUMERIC) {
                maxlength = IOTools.findMaxStringLength(fc, t);
                fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.TIMESTAMP) {
                fields[f] = new DbfFieldDef(columnName, '@', 8, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.LONG) {
                maxlength = IOTools.findMaxStringLength(fc, t);
                fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.FLOAT) {
                fields[f] = new DbfFieldDef(columnName, 'I', 4, 0);
                ++f;
                continue;
            }
            maxlength = IOTools.findMaxStringLength(fc, t);
            fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
            ++f;
        }
        DbfFileWriter dbf = new DbfFileWriter(filename);
        dbf.writeHeader(fields, fc.size());
        int num = fc.size();
        List<Feature> features = fc.getFeatures();
        for (int t = 0; t < num; ++t) {
            Feature feature = features.get(t);
            Vector<Object> DBFrow = new Vector<Object>();
            for (int u = 0; u < fs.getAttributeCount(); ++u) {
                Object a;
                AttributeType columnType = fs.getAttributeType(u);
                if (columnType == AttributeType.INTEGER) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Integer(0));
                        continue;
                    }
                    DBFrow.add(a);
                    continue;
                }
                if (columnType == AttributeType.DOUBLE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Double(0.0));
                        continue;
                    }
                    DBFrow.add(a);
                    continue;
                }
                if (columnType == AttributeType.FLOAT) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Float(0.0));
                        continue;
                    }
                    DBFrow.add(a);
                    continue;
                }
                if (columnType == AttributeType.BOOLEAN) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Boolean(false));
                        continue;
                    }
                    DBFrow.add(a);
                    continue;
                }
                if (columnType == AttributeType.TIMESTAMP) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new String(""));
                        continue;
                    }
                    DBFrow.add(a);
                    continue;
                }
                if (columnType == AttributeType.DATE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add("");
                        continue;
                    }
                    DBFrow.add(DbfFile.DATE_PARSER.format((Date)a));
                    continue;
                }
                if (columnType != AttributeType.STRING && columnType != AttributeType.NUMERIC && columnType != AttributeType.LONG) continue;
                a = feature.getAttribute(u);
                if (a == null) {
                    DBFrow.add(new String(""));
                    continue;
                }
                if (a instanceof String) {
                    DBFrow.add(a);
                    continue;
                }
                DBFrow.add(a.toString());
            }
            dbf.writeRecord(DBFrow);
        }
        dbf.close();
    }

    public static void saveCSV(JTable table, String filename) throws Exception {
        IOTools.saveCSV(table, filename, ",");
    }

    public static void saveCSV(JTable table, String filename, String cellseparator) throws Exception {
        try {
            File file = new File(filename);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsoluteFile()), StandardCharsets.UTF_8));
            for (int j = 0; j < table.getColumnCount(); ++j) {
                bw.write(table.getModel().getColumnName(j) + cellseparator);
            }
            bw.newLine();
            for (int i = 0; i < table.getRowCount(); ++i) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    bw.write(table.getModel().getValueAt(i, j) + cellseparator);
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveShapefile(Layer layer, String filename) throws Exception {
        DataSourceQuery dsq = layer.getDataSourceQuery();
        DriverProperties dp = new DriverProperties();
        Object charsetName = dsq.getDataSource().getProperties().get("charset");
        if (charsetName != null) {
            dp.set("charset", charsetName.toString());
        }
        new ShapefileWriter().write(layer.getFeatureCollectionWrapper(), dp);
        dp.set("File", filename);
        new ShapefileWriter().write(layer.getFeatureCollectionWrapper(), dp);
    }

    public static void saveJMLFile(Layer layer, String filename) throws Exception {
        DataSourceQuery dsq = layer.getDataSourceQuery();
        DriverProperties dp = new DriverProperties();
        Object charsetName = dsq.getDataSource().getProperties().get("charset");
        if (charsetName != null) {
            dp.set("charset", charsetName.toString());
        }
        new JMLWriter().write((FeatureCollection)layer.getFeatureCollectionWrapper(), dp);
        dp.set("File", filename);
        new JMLWriter().write((FeatureCollection)layer.getFeatureCollectionWrapper(), dp);
    }

    static int findMaxStringLength(FeatureCollection fc, int attributeNumber) {
        int maxlen = 0;
        for (Feature f : fc) {
            int l = f.getString(attributeNumber).length();
            if (l <= maxlen) continue;
            maxlen = l;
        }
        return maxlen;
    }

    public static void saveStyleToFile(Layer layer, String path) throws Exception {
        double internalScale = 1.0 / JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getViewport().getScale();
        double realScale = ScreenScale.getHorizontalMapScale(JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getViewport());
        double scaleFactor = internalScale / realScale;
        String outSLD = manager.uniqueLayerName(layer.getName() + ".sld");
        File sld_outFile = new File(path.concat(File.separator).concat(outSLD));
        File inputXML = File.createTempFile("temptask", ".xml");
        inputXML.deleteOnExit();
        String name = layer.getName();
        if (layer.getFeatureCollectionWrapper().getFeatures().size() == 0) {
            throw new Exception(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewPlugIn.Selected-layer-is-empty"));
        }
        BasicFeature bf = (BasicFeature)layer.getFeatureCollectionWrapper().getFeatures().get(0);
        Geometry geo = bf.getGeometry();
        String geoType = geo.getGeometryType();
        Java2XML java2Xml = new Java2XML();
        java2Xml.write((Object)layer, "layer", inputXML);
        FileInputStream input = new FileInputStream(inputXML);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(sld_outFile), Charset.defaultCharset());
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("wmsLayerName", name);
        map.put("featureTypeStyle", name);
        map.put("styleName", name);
        map.put("styleTitle", name);
        map.put("geoType", geoType);
        map.put("geomProperty", I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.geomProperty"));
        map.put("Namespace", "http://www.deegree.org/app");
        Double d = layer.getMinScale();
        d = d != null ? d : new Double(0.0);
        map.put("minScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        double largeNumber = 9.9999999999E10;
        d = layer.getMaxScale();
        d = d != null ? d : new Double(9.9999999999E10);
        map.put("maxScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        fw.write(LayerStyle2SLDPlugIn.transformContext(input, map));
        fw.close();
    }

    public static void print(FeatureCollection fc) {
        List<Feature> featList = fc.getFeatures();
        for (Feature f : featList) {
            System.out.println(f.getGeometry());
        }
    }

    public static void saveSimbology_Jump(File file, Layer layer) throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            new Java2XML().write((Object)layer, "layer", stringWriter);
        }
        finally {
            stringWriter.flush();
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(stringWriter.toString()));
        Document document = documentBuilder.parse(is);
        IOTools.removeElements(document);
        document.normalize();
        DOMSource source = new DOMSource(document);
        FileWriter writer = new FileWriter(new File(file.getAbsolutePath()));
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(source, result);
        Pattern ext = Pattern.compile("(?<=.)\\.[^.]+$");
        String folder = ext.matcher(file.getAbsolutePath()).replaceAll("");
        List<String> listPictures = IOTools.getListOfElements(document);
        if (!listPictures.isEmpty()) {
            new File(folder).mkdir();
            for (String str : listPictures) {
                File inputFile = new File(IOTools.convertPathToSystemIndependentPath(str));
                IOTools.copyFileToFolder(inputFile, new File(folder).getAbsolutePath());
            }
            try {
                OutputStreamWriter wrt = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(folder).getAbsolutePath().concat(File.separator).concat("picture.txt")), StandardCharsets.UTF_8);
                String listString = "";
                for (String s : listPictures) {
                    listString = listString + s + System.getProperty("line.separator");
                }
                wrt.write(listString);
                wrt.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileToFolder(File inputFile, String outputDir) throws IOException {
        File directoryFile = new File(outputDir);
        if (directoryFile.canRead()) {
            File outFile = new File(outputDir.concat(File.separator).concat(inputFile.getName()));
            AbstractInterruptibleChannel inputChannel = null;
            AbstractInterruptibleChannel outputChannel = null;
            try {
                inputChannel = new FileInputStream(inputFile).getChannel();
                outputChannel = new FileOutputStream(outFile).getChannel();
                ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
            }
            finally {
                inputChannel.close();
                outputChannel.close();
            }
        }
    }

    public static String convertPathToSystemIndependentPath(String oldPath) {
        String path = Paths.get(oldPath, new String[0]).toUri().getPath();
        return path;
    }

    private static void removeElements(Node parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element eElement;
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("description") || child.getNodeName().equals("data-source-query") || child.getNodeName().equals("feature-schema-operation")) {
                parent.removeChild(child);
                while (child.hasChildNodes()) {
                    child.removeChild(child.getFirstChild());
                }
            } else {
                IOTools.removeElements(child);
            }
            if (!(eElement = (Element)child).getAttribute("class").contains("org.openjump.core.ccordsys.srid.SRIDStyle")) continue;
            parent.removeChild(child);
            while (child.hasChildNodes()) {
                child.removeChild(child.getFirstChild());
            }
        }
    }

    private static List<String> getListOfElements(Node parent) {
        NodeList children = ((Document)parent).getDocumentElement().getElementsByTagName("style");
        LinkedHashSet<String> uniqueStrings = new LinkedHashSet<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Element eElement;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (eElement = (Element)child).getAttribute("imageURL").isEmpty()) continue;
            String url = eElement.getAttribute("imageURL");
            uniqueStrings.add(url);
        }
        NodeList children1 = ((Document)parent).getDocumentElement().getElementsByTagName("vertex-style");
        for (int i = 0; i < children1.getLength(); ++i) {
            Element eElement;
            Node child = children1.item(i);
            if (child.getNodeType() != 1 || (eElement = (Element)child).getAttribute("imageURL").isEmpty()) continue;
            String url = eElement.getAttribute("imageURL");
            uniqueStrings.add(url);
        }
        ArrayList<String> asList = new ArrayList<String>(uniqueStrings);
        return asList;
    }

    private static boolean imageURLExist(File file) throws ParserConfigurationException, SAXException, IOException {
        String url;
        Element eElement;
        Node child;
        int i;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        LinkedHashSet<String> uniqueStrings = new LinkedHashSet<String>();
        NodeList children = doc.getDocumentElement().getElementsByTagName("style");
        NodeList children1 = doc.getDocumentElement().getElementsByTagName("vertex-style");
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (child.getNodeType() != 1 || (eElement = (Element)child).getAttribute("imageURL").isEmpty()) continue;
            url = eElement.getAttribute("imageURL");
            uniqueStrings.add(url);
        }
        for (i = 0; i < children1.getLength(); ++i) {
            child = children1.item(i);
            if (child.getNodeType() != 1 || (eElement = (Element)child).getAttribute("imageURL").isEmpty()) continue;
            url = eElement.getAttribute("imageURL");
            uniqueStrings.add(url);
        }
        return !uniqueStrings.isEmpty();
    }

    public static File recompileXMLFile(File file, String directory) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        NodeList children = doc.getDocumentElement().getElementsByTagName("style");
        for (int i = 0; i < children.getLength(); ++i) {
            Element eElement;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (eElement = (Element)child).getAttribute("imageURL").isEmpty()) continue;
            String url = IOTools.convertPathToSystemIndependentPath(eElement.getAttribute("imageURL"));
            String name = new File(url).getName();
            String newNamePath = directory.concat(File.separator).concat(name);
            eElement.setAttribute("imageURL", newNamePath);
        }
        NodeList children1 = doc.getDocumentElement().getElementsByTagName("vertex-style");
        for (int i = 0; i < children1.getLength(); ++i) {
            Element eElement;
            Node child = children1.item(i);
            if (child.getNodeType() != 1 || (eElement = (Element)child).getAttribute("imageURL").isEmpty()) continue;
            String url = IOTools.convertPathToSystemIndependentPath(eElement.getAttribute("imageURL"));
            String name = new File(url).getName();
            String newNamePath = directory.concat(File.separator).concat(name);
            eElement.setAttribute("imageURL", newNamePath);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource input = new DOMSource(doc);
        File outFile = new File(file.getAbsolutePath());
        StreamResult output = new StreamResult(outFile);
        transformer.transform(input, output);
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSimbology_Jump(File file, Layer layer) throws Exception {
        WorkbenchFrame workbenchFrame = JUMPWorkbench.getInstance().getFrame();
        File recompiled = null;
        if (!IOTools.imageURLExist(file)) {
            recompiled = file;
        } else {
            Pattern ext = Pattern.compile("(?<=.)\\.[^.]+$");
            String folder = ext.matcher(file.getAbsolutePath()).replaceAll("");
            File fold = new File(folder);
            if (fold.exists() && fold.isDirectory()) {
                recompiled = IOTools.recompileXMLFile(file, fold.getAbsolutePath());
            } else {
                JFCWithEnterAction chooser = new JFCWithEnterAction();
                chooser.setCurrentDirectory(new File("."));
                chooser.setDialogTitle(I18N.getInstance().get("org.openjump.core.ui.plugin.style.StylePlugIns.IO.select-folder"));
                chooser.setFileSelectionMode(1);
                chooser.setAcceptAllFileFilterUsed(false);
                if (chooser.showOpenDialog(JUMPWorkbench.getInstance().getFrame()) == 0) {
                    recompiled = IOTools.recompileXMLFile(file, chooser.getSelectedFile().getAbsolutePath());
                } else {
                    recompiled = file;
                    workbenchFrame.getContext().getLayerViewPanel().getContext().warnUser(I18N.getInstance().get("org.openjump.core.ui.plugin.style.StylePlugIns.IO.styles-could-not-be-loaded"));
                }
            }
        }
        try (FileReader reader = new FileReader(recompiled);){
            Layer sourceLayer = (Layer)new XML2Java(workbenchFrame.getContext().getWorkbench().getPlugInManager().getClassLoader()).read(reader, Layer.class);
            List<Style> styleColection = sourceLayer.getStyles();
            ArrayList<Style> names = new ArrayList<Style>();
            for (Style style2 : styleColection) {
                names.add(style2);
                if (!(style2 instanceof SRIDStyle)) continue;
                names.remove(style2);
            }
            try {
                layer.setStyles(names);
            }
            catch (Exception e) {
                Logger.error(e);
                String errorMessage = I18N.getInstance().get("org.openjump.core.ui.plugin.style.StylePlugIns.IO.error");
                JOptionPane.showMessageDialog(workbenchFrame.getActiveInternalFrame(), errorMessage, "Error", 0);
            }
        }
    }

    public static void loadSimbology_SLD(File file, PlugInContext context) throws SAXException, IOException, ParserConfigurationException {
        Blackboard bb = PersistentBlackboardPlugIn.get(JUMPWorkbench.getInstance().getFrame().getContext());
        bb.put("ImportSLDPlugin.filename", file.getAbsoluteFile().toString());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(file);
        try {
            ImportSLDPlugIn.importSLD(doc, context);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public static void saveSimbology_SLD(File file, Layer layer) throws Exception {
        double internalScale = 1.0 / JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getViewport().getScale();
        double realScale = ScreenScale.getHorizontalMapScale(JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getViewport());
        double scaleFactor = internalScale / realScale;
        File inputXML = File.createTempFile("temptask", ".xml");
        inputXML.deleteOnExit();
        String name = layer.getName();
        if (layer.getFeatureCollectionWrapper().getFeatures().size() == 0) {
            throw new Exception(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewPlugIn.Selected-layer-is-empty"));
        }
        BasicFeature bf = (BasicFeature)layer.getFeatureCollectionWrapper().getFeatures().get(0);
        Geometry geo = bf.getGeometry();
        String geoType = geo.getGeometryType();
        Java2XML java2Xml = new Java2XML();
        java2Xml.write((Object)layer, "layer", inputXML);
        FileInputStream input = new FileInputStream(inputXML);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.defaultCharset());
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("wmsLayerName", name);
        map.put("featureTypeStyle", name);
        map.put("styleName", name);
        map.put("styleTitle", name);
        map.put("geoType", geoType);
        map.put("geomProperty", I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.geomProperty"));
        map.put("Namespace", "http://www.deegree.org/app");
        Double d = layer.getMinScale();
        d = d != null ? d : new Double(0.0);
        map.put("minScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        double largeNumber = 9.9999999999E10;
        d = layer.getMaxScale();
        d = d != null ? d : new Double(9.9999999999E10);
        map.put("maxScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        fw.write(LayerStyle2SLDPlugIn.transformContext(input, map));
        fw.close();
    }

    public static void saveSimbology_SLD2(File file, Layer layer) throws Exception {
        String name = layer.getName();
        BasicFeature bf = (BasicFeature)layer.getFeatureCollectionWrapper().getFeatures().get(0);
        Geometry geo = bf.getGeometry();
        String geoType = geo.getGeometryType();
        MultiInputDialog dialog = new MultiInputDialog(JUMPWorkbench.getInstance().getFrame(), I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.SLD-Parameters"), true);
        String geomProperty = "GEOM";
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getAttributeType(i) != AttributeType.GEOMETRY) continue;
            geomProperty = schema.getAttributeName(i);
        }
        dialog.addSeparator();
        dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.geomProperty"), geomProperty, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Input-the-name-of-the-geometry-property"));
        dialog.addSeparator();
        dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.WMS-Layer-name"), name, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.WMS-Layer-name"));
        dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-name"), name, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-name"));
        dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-title"), name, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-title"));
        dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Feature-Type-Style"), name, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Feature-Type-Style"));
        dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Namespace"), "http://www.deegree.org/app", 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Namespace"));
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return;
        }
        String wmsLayerName = dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.WMS-Layer-name"));
        String styleName = dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-name"));
        String styleTitle = dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-title"));
        String featureTypeStyle = dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Feature-Type-Style"));
        geomProperty = dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.geomProperty"));
        String namespace = dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Namespace"));
        double internalScale = 1.0 / JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getViewport().getScale();
        double realScale = ScreenScale.getHorizontalMapScale(JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getViewport());
        double scaleFactor = internalScale / realScale;
        File inputXML = File.createTempFile("temptask", ".xml");
        inputXML.deleteOnExit();
        if (layer.getFeatureCollectionWrapper().getFeatures().size() == 0) {
            throw new Exception(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewPlugIn.Selected-layer-is-empty"));
        }
        Java2XML java2Xml = new Java2XML();
        java2Xml.write((Object)layer, "layer", inputXML);
        FileInputStream input = new FileInputStream(inputXML);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("wmsLayerName", wmsLayerName);
        map.put("featureTypeStyle", featureTypeStyle);
        map.put("styleName", styleName);
        map.put("styleTitle", styleTitle);
        map.put("geoType", geoType);
        map.put("geomProperty", geomProperty);
        map.put("Namespace", namespace);
        Double d = layer.getMinScale();
        d = d != null ? d : new Double(0.0);
        map.put("minScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        double largeNumber = 9.9999999999E10;
        d = layer.getMaxScale();
        d = d != null ? d : new Double(9.9999999999E10);
        map.put("maxScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        fw.write(LayerStyle2SLDPlugIn.transformContext(input, map));
        fw.close();
    }

    public static void loadImageAsLayer(File file, WorkbenchContext wcontext, String extension) throws Exception {
        Registry registry = wcontext.getRegistry();
        List loaders = registry.getEntries(FileLayerLoader.KEY);
        FileLayerLoader loader = null;
        for (FileLayerLoader fileLayerLoader : loaders) {
            if (!(fileLayerLoader instanceof GeoImageFactoryFileLayerLoader)) continue;
            loader = fileLayerLoader;
        }
        URI uri = file.toURI();
        HashMap<String, Object> dp = new HashMap<String, Object>();
        dp.put("Uri", uri.toString());
        dp.put(ImageryLayerDataset.ATTR_TYPE, extension);
        loader.open(null, uri, dp);
    }

    public static void saveGeoTIFF(BufferedImage image, Envelope envelope, File file) throws IOException {
        double nodata = -99999.0;
        double cellSizeX = envelope.getWidth() / (double)image.getWidth();
        double cellSizeY = envelope.getHeight() / (double)image.getHeight();
        IOTools.saveGeoTIFF(image, envelope, cellSizeX, cellSizeY, 32773, -99999.0, file);
    }

    public static void saveGeoTIFF(BufferedImage image, Envelope envelope, double cellsizex, double cellsizey, int compression, double nodata, File file) {
        try {
            FileOutputStream tifOut = new FileOutputStream(file);
            TIFFEncodeParam param = new TIFFEncodeParam();
            param.setCompression(compression);
            TIFFField[] tiffFields = new TIFFField[3];
            tiffFields[0] = new TIFFField(33550, 12, 2, (Object)new double[]{cellsizex, cellsizey});
            String noDataS = Double.toString(nodata);
            byte[] bytes = noDataS.getBytes();
            tiffFields[1] = new TIFFField(42113, 1, noDataS.length(), (Object)bytes);
            tiffFields[2] = new TIFFField(33922, 12, 6, (Object)new double[]{0.0, 0.0, 0.0, envelope.getMinX(), envelope.getMaxY(), 0.0});
            param.setExtraFields(tiffFields);
            TIFFImageEncoder encoder = (TIFFImageEncoder)TIFFCodec.createImageEncoder((String)"tiff", (OutputStream)tifOut, (ImageEncodeParam)param);
            encoder.encode((RenderedImage)image);
            tifOut.flush();
            FileUtil.close(tifOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static FeatureCollection loaddBaseFile(String sFilename) {
        try {
            DbfFile mydbf = new DbfFile(sFilename);
            FeatureSchema fs = new FeatureSchema();
            fs.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
            FeatureDataset featureCollection = null;
            int numfields = mydbf.getNumFields();
            for (int j = 0; j < numfields; ++j) {
                AttributeType type = AttributeType.toAttributeType(mydbf.getFieldType(j));
                fs.addAttribute(mydbf.getFieldName(j), type);
            }
            featureCollection = new FeatureDataset(fs);
            for (int x = 0; x < mydbf.getLastRec(); ++x) {
                BasicFeature feature = new BasicFeature(fs);
                byte[] s = mydbf.GetDbfRec(x);
                for (int y = 0; y < numfields; ++y) {
                    feature.setAttribute(y + 1, mydbf.ParseRecordColumn(s, y));
                }
                featureCollection.add(feature);
            }
            mydbf.close();
            return featureCollection;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void savedBaseFile(FeatureCollection featureCollection, String fname, Charset charset) throws Exception {
        int t;
        HashMap<String, DbfFieldDef> fieldMap = null;
        if (new File(fname).exists()) {
            DbfFile dbfFile = new DbfFile(fname);
            int numFields = dbfFile.getNumFields();
            fieldMap = new HashMap<String, DbfFieldDef>(numFields);
            for (int i = 0; i < numFields; ++i) {
                String fieldName = dbfFile.getFieldName(i);
                fieldMap.put(fieldName, dbfFile.fielddef[i]);
            }
            dbfFile.close();
        }
        FeatureSchema fs = featureCollection.getFeatureSchema();
        DbfFieldDef[] fields = new DbfFieldDef[fs.getAttributeCount() - 1];
        int f = 0;
        for (t = 0; t < fs.getAttributeCount(); ++t) {
            AttributeType columnType = fs.getAttributeType(t);
            String columnName = fs.getAttributeName(t);
            if (columnType == AttributeType.INTEGER) {
                fields[f] = new DbfFieldDef(columnName, 'N', 11, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DOUBLE) {
                fields[f] = new DbfFieldDef(columnName, 'N', 33, 16);
                ++f;
                continue;
            }
            if (columnType == AttributeType.STRING) {
                int maxlength = IOTools.findMaxStringLength(featureCollection, t);
                if (maxlength > 255) {
                    throw new Exception("ShapefileWriter does not support strings longer than 255 characters");
                }
                fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DATE) {
                fields[f] = new DbfFieldDef(columnName, 'D', 8, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.LONG) {
                fields[f] = new DbfFieldDef(columnName, 'N', 11, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.BOOLEAN) {
                fields[f] = new DbfFieldDef(columnName, 'L', 1, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.GEOMETRY) continue;
            throw new Exception("Shapewriter: unsupported AttributeType found in featurecollection.");
        }
        DbfFileWriter dbf = new DbfFileWriter(fname);
        dbf.setCharset(charset);
        dbf.writeHeader(fields, featureCollection.size());
        int num = featureCollection.size();
        List<Feature> features = featureCollection.getFeatures();
        for (t = 0; t < num; ++t) {
            Feature feature = features.get(t);
            Vector<Object> DBFrow = new Vector<Object>();
            for (int u = 0; u < fs.getAttributeCount(); ++u) {
                Object a;
                AttributeType columnType = fs.getAttributeType(u);
                if (columnType == AttributeType.INTEGER) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Integer(0));
                        continue;
                    }
                    DBFrow.add(a);
                    continue;
                }
                if (columnType == AttributeType.DOUBLE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Double(0.0));
                        continue;
                    }
                    DBFrow.add(a);
                    continue;
                }
                if (columnType == AttributeType.DATE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add("");
                        continue;
                    }
                    DBFrow.add(DbfFile.DATE_PARSER.format((Date)a));
                    continue;
                }
                if (columnType == AttributeType.STRING) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new String(""));
                        continue;
                    }
                    if (a instanceof String) {
                        DBFrow.add(a);
                        continue;
                    }
                    DBFrow.add(a.toString());
                    continue;
                }
                if (columnType == AttributeType.LONG) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Long(0L));
                        continue;
                    }
                    DBFrow.add(a);
                    continue;
                }
                if (columnType != AttributeType.BOOLEAN) continue;
                a = feature.getAttribute(u);
                if (a == null) {
                    DBFrow.add(new Boolean(false));
                    continue;
                }
                DBFrow.add(a);
            }
            dbf.writeRecord(DBFrow);
        }
        dbf.close();
    }
}

