/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import de.latlon.deejump.plugin.style.DeeRenderingStylePanel;
import de.latlon.deejump.plugin.style.VertexStylesFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class VertexStyleChooser
extends JPanel {
    private static final long serialVersionUID = 7256506666365045855L;
    static final List<String> STYLE_NAMES;
    private JComboBox pointTypeComboBox;
    private JButton bitmapChangeButton;
    private String currentFilename;
    public JSlider sizeSlider;
    private boolean activateOwnSlider = false;
    private Blackboard blackboard;
    private BasicStylePanel stylePanel;

    public VertexStyleChooser(boolean activateOwnSlider) {
        this.initGUI();
        this.activateOwnSlider = activateOwnSlider;
    }

    protected void setBlackboard(Blackboard persistentBlackboard) {
        this.blackboard = persistentBlackboard;
    }

    protected void setStylePanel(DeeRenderingStylePanel stylePanel) {
        this.stylePanel = stylePanel;
    }

    private void initGUI() {
        this.pointTypeComboBox = new JComboBox();
        this.pointTypeComboBox.setEditable(false);
        this.pointTypeComboBox.addItem(I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.square"));
        this.pointTypeComboBox.addItem(I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.circle"));
        this.pointTypeComboBox.addItem(I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.triangle"));
        this.pointTypeComboBox.addItem(I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.cross"));
        this.pointTypeComboBox.addItem(I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.star"));
        this.pointTypeComboBox.addItem(I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.bitmap"));
        this.pointTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                String selectedItem = STYLE_NAMES.get(comboBox.getSelectedIndex());
                VertexStyleChooser.this.setSelectedStyle(selectedItem);
            }
        });
        this.bitmapChangeButton = new JButton(I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.bitmap-change"));
        this.bitmapChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VertexStyleChooser.this.openFileChooser();
            }
        });
        if (this.sizeSlider == null) {
            this.sizeSlider = new JSlider();
        }
        this.sizeSlider.setBorder(BorderFactory.createTitledBorder("Point size: "));
        if (this.activateOwnSlider) {
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(new Integer(5), new JLabel("5"));
            labelTable.put(new Integer(10), new JLabel("10"));
            labelTable.put(new Integer(15), new JLabel("15"));
            labelTable.put(new Integer(20), new JLabel("20"));
            this.sizeSlider.setLabelTable(labelTable);
            this.sizeSlider.setEnabled(true);
            this.sizeSlider.setMajorTickSpacing(1);
            this.sizeSlider.setMajorTickSpacing(0);
            this.sizeSlider.setPaintLabels(true);
            this.sizeSlider.setMinimum(4);
            this.sizeSlider.setValue(4);
            this.sizeSlider.setMaximum(20);
            this.sizeSlider.setSnapToTicks(false);
            this.sizeSlider.setPreferredSize(new Dimension(130, 49));
        }
        JPanel oberstPanel = new JPanel();
        oberstPanel.add(new JLabel(I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.point-display-type")));
        oberstPanel.add(this.pointTypeComboBox);
        oberstPanel.add(this.bitmapChangeButton);
        JPanel sliderPanel = new JPanel();
        sliderPanel.add(this.sizeSlider);
        this.setLayout(new BorderLayout());
        this.add((Component)oberstPanel, "North");
        if (this.activateOwnSlider) {
            this.add((Component)sliderPanel, "Center");
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.pointTypeComboBox.addActionListener(actionListener);
        this.bitmapChangeButton.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.pointTypeComboBox.removeActionListener(actionListener);
        this.bitmapChangeButton.removeActionListener(actionListener);
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.activateOwnSlider) {
            this.sizeSlider.addChangeListener(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.activateOwnSlider) {
            this.sizeSlider.removeChangeListener(cl);
        }
    }

    boolean openFileChooser() {
        boolean imageIsLoaded = false;
        JFileChooser fileChooser = new JFileChooser();
        String f = (String)this.blackboard.get("VertexStyleChooser.last-location");
        if (f != null) {
            File dir = new File(f);
            while (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
            fileChooser.setCurrentDirectory(dir);
        }
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".gif") || file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".svg");
            }

            @Override
            public String getDescription() {
                return "*.png, *.gif, *.jpg, *.svg";
            }
        });
        int showFileChooser = fileChooser.showOpenDialog(this);
        if (showFileChooser == 0) {
            String currentFilePath = fileChooser.getSelectedFile().getAbsolutePath();
            this.setCurrentFileName(currentFilePath);
            this.setSelectedStyle("BITMAP");
            this.blackboard.put("VertexStyleChooser.last-location", currentFilePath);
            imageIsLoaded = true;
        }
        return imageIsLoaded;
    }

    protected void setCurrentFileName(String fileName) {
        this.currentFilename = fileName;
    }

    public String getCurrentFileName() {
        return this.currentFilename;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.pointTypeComboBox.setEnabled(enabled);
        this.bitmapChangeButton.setEnabled(enabled);
        if (this.activateOwnSlider) {
            this.sizeSlider.setEnabled(enabled);
        }
    }

    public VertexStyle getSelectedStyle() {
        String wellKnowName = STYLE_NAMES.get(this.pointTypeComboBox.getSelectedIndex());
        if ("BITMAP".equals(wellKnowName) && (wellKnowName = this.getCurrentFileName()) == null) {
            wellKnowName = STYLE_NAMES.get(0);
        }
        VertexStyle vertexStyle = VertexStylesFactory.createVertexStyle(wellKnowName);
        vertexStyle.setSize(this.sizeSlider.getValue());
        vertexStyle.setFillColor(this.stylePanel.getBasicStyle().getFillColor());
        vertexStyle.setLineColor(this.stylePanel.getBasicStyle().getLineColor());
        vertexStyle.setFilling(this.stylePanel.getBasicStyle().isRenderingFill());
        return vertexStyle;
    }

    public void setSelectedStyle(String currentVertexStyle) {
        int nameIndex = STYLE_NAMES.indexOf(currentVertexStyle);
        if (nameIndex > -1 && nameIndex < STYLE_NAMES.size()) {
            this.pointTypeComboBox.setSelectedIndex(nameIndex);
        }
    }

    static {
        ArrayList<String> TEMP_STYLE_NAMES = new ArrayList<String>(5);
        TEMP_STYLE_NAMES.add("SQUARE");
        TEMP_STYLE_NAMES.add("CIRCLE");
        TEMP_STYLE_NAMES.add("TRIANGLE");
        TEMP_STYLE_NAMES.add("CROSS");
        TEMP_STYLE_NAMES.add("STAR");
        TEMP_STYLE_NAMES.add("BITMAP");
        STYLE_NAMES = Collections.unmodifiableList(TEMP_STYLE_NAMES);
    }
}

