/*
 * Decompiled with CFR 0.152.
 */
package de.fho.jump.pirol.plugins.EditAttributeByFormula;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import de.fho.jump.pirol.plugins.EditAttributeByFormula.AddFormulaPartToTextArea_Action;
import de.fho.jump.pirol.plugins.EditAttributeByFormula.AddTextFieldTextToTextAreaOnClick_Action;
import de.fho.jump.pirol.ui.documents.NumberInputDocument;
import de.fho.jump.pirol.ui.panels.NewAttributePanel;
import de.fho.jump.pirol.utilities.FormulaParsing.FormulaParser;
import de.fho.jump.pirol.utilities.FormulaParsing.FormulaValue;
import de.fho.jump.pirol.utilities.attributes.AttributeInfo;
import de.fho.jump.pirol.utilities.debugOutput.DebugUserIds;
import de.fho.jump.pirol.utilities.debugOutput.PersonalLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openjump.core.apitools.FeatureSchemaTools;
import org.openjump.core.ui.swing.ValueChecker;
import org.openjump.io.PropertiesHandler;

public class FormulaEditingPanel
extends JPanel
implements ActionListener,
ValueChecker {
    protected PersonalLogger logger = new PersonalLogger(DebugUserIds.ALL);
    private static final long serialVersionUID = -7709755834905111906L;
    protected JTextArea formulaField = new JTextArea(4, 20);
    protected JTextArea errorMessages = new JTextArea(4, 20);
    protected FeatureSchema featureSchema = null;
    protected AttributeInfo[] attributeInfos = null;
    protected JTextField numberInputField = null;
    protected JComboBox storedFormulasDropDown = new JComboBox();
    protected static final String[] mathSigns = new String[]{"+", "-", "*", "/", "(", ")", "sqrt:", "power:", "\u03c0", "log:", "ln:", "root:", "sin:", "cos:", "tan:", "asin:", "acos:", "atan:", "ra>de:", "de>ra:"};
    private PropertiesHandler storedFormulas;
    private NewAttributePanel newAttributePanel;
    protected FormulaValue parsedFormula = null;

    public FormulaEditingPanel(FeatureSchema featureSchema, PropertiesHandler storedFormulas, NewAttributePanel newAttributePanel) {
        this.featureSchema = featureSchema;
        this.attributeInfos = FeatureSchemaTools.getAttributesWithTypes(this.featureSchema, new AttributeType[]{AttributeType.DOUBLE, AttributeType.INTEGER});
        this.formulaField.setWrapStyleWord(true);
        this.storedFormulas = storedFormulas;
        this.newAttributePanel = newAttributePanel;
        this.setupUI();
    }

    public FormulaEditingPanel(FeatureSchema featureSchema, NewAttributePanel newAttributePanel) {
        this.featureSchema = featureSchema;
        this.attributeInfos = FeatureSchemaTools.getAttributesWithTypes(this.featureSchema, new AttributeType[]{AttributeType.DOUBLE, AttributeType.INTEGER});
        this.formulaField.setWrapStyleWord(true);
        this.newAttributePanel = newAttributePanel;
        this.setupUI();
    }

    protected void setupUI() {
        JButton button;
        this.setLayout(new BorderLayout());
        JPanel formulaAndOperators = new JPanel();
        BorderLayout moreGenerousLayout = new BorderLayout();
        moreGenerousLayout.setVgap(5);
        formulaAndOperators.setLayout(moreGenerousLayout);
        JPanel loadedForms = null;
        if (this.storedFormulas != null) {
            loadedForms = new JPanel();
            loadedForms.setLayout(new BorderLayout());
            loadedForms.add((Component)new JLabel(I18N.getInstance().get("pirol.plugIns.FormulaEditingPanel.load-formula") + " : "), "West");
            String[] formulaNames = this.storedFormulas.keySet().toArray(new String[0]);
            for (int i = 0; i < formulaNames.length; ++i) {
                this.storedFormulasDropDown.addItem(formulaNames[i]);
            }
            this.storedFormulasDropDown.setSelectedItem(null);
            this.storedFormulasDropDown.addActionListener(this);
            loadedForms.add((Component)this.storedFormulasDropDown, "Center");
            formulaAndOperators.add((Component)loadedForms, "North");
        }
        formulaAndOperators.add((Component)this.formulaField, "Center");
        JPanel mathSignsButtonPanel = new JPanel();
        int gridColumns = mathSigns.length / 5;
        mathSignsButtonPanel.setLayout(new GridLayout(mathSigns.length / gridColumns, gridColumns));
        for (int i = 0; i < mathSigns.length; ++i) {
            button = new JButton();
            button.setAction(new AddFormulaPartToTextArea_Action(mathSigns[i], this.formulaField, mathSigns, this.featureSchema));
            mathSignsButtonPanel.add(button);
        }
        formulaAndOperators.add((Component)mathSignsButtonPanel, "South");
        this.add((Component)formulaAndOperators, "North");
        Box vbox = Box.createVerticalBox();
        Box hbox = Box.createHorizontalBox();
        int sumOfWidthes = 0;
        int wantedWidth = 0;
        if (loadedForms != null) {
            wantedWidth = loadedForms.getPreferredSize().width;
        }
        for (int i = 0; i < this.attributeInfos.length; ++i) {
            button = new JButton();
            button.setAction(new AddFormulaPartToTextArea_Action(this.attributeInfos[i].getUniqueAttributeName(), this.formulaField, mathSigns, this.featureSchema));
            hbox.add(button);
            this.logger.printDebug("sumOfWidthes: " + (sumOfWidthes += button.getPreferredSize().width) + ", wantedWidth: " + wantedWidth);
            if (sumOfWidthes < wantedWidth && i != this.attributeInfos.length - 1) continue;
            hbox.add(Box.createGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(5));
            hbox = Box.createHorizontalBox();
            sumOfWidthes = 0;
        }
        vbox.add(Box.createVerticalGlue());
        JScrollPane scrollPane = new JScrollPane(vbox);
        scrollPane.setSize(new Dimension(wantedWidth, 60));
        scrollPane.setMinimumSize(scrollPane.getSize());
        scrollPane.setPreferredSize(scrollPane.getSize());
        this.add((Component)scrollPane, "Center");
        JPanel numberInputAndErrorPanel = new JPanel(new BorderLayout());
        JPanel numberInputPanel = new JPanel(new BorderLayout());
        this.numberInputField = new JTextField();
        this.numberInputField.setDocument(new NumberInputDocument());
        numberInputPanel.add((Component)this.numberInputField, "Center");
        numberInputPanel.add((Component)new JButton(new AddTextFieldTextToTextAreaOnClick_Action(this.numberInputField, this.formulaField, I18N.getInstance().get("pirol.plugIns.FormulaEditingPanel.copy-value-to-formula"))), "East");
        numberInputAndErrorPanel.add((Component)numberInputPanel, "North");
        this.errorMessages.setEditable(false);
        this.errorMessages.setWrapStyleWord(true);
        this.errorMessages.setLineWrap(true);
        this.errorMessages.setFont(this.errorMessages.getFont().deriveFont(1).deriveFont(12.0f));
        this.errorMessages.setForeground(Color.red);
        this.errorMessages.setBackground(this.getBackground());
        numberInputAndErrorPanel.add((Component)this.errorMessages, "South");
        this.add((Component)numberInputAndErrorPanel, "South");
    }

    public String getFormula() {
        return this.formulaField.getText();
    }

    public FormulaValue getParsedFormula() {
        return this.parsedFormula;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.storedFormulas != null) {
            String selectedFormName = this.storedFormulasDropDown.getSelectedItem().toString();
            this.formulaField.setText(this.storedFormulas.getProperty(selectedFormName));
            this.newAttributePanel.setAttributeName(selectedFormName);
        }
    }

    @Override
    public boolean areValuesOk() {
        try {
            this.parsedFormula = FormulaParser.getValue(this.getFormula(), this.featureSchema);
        }
        catch (RuntimeException e) {
            this.parsedFormula = null;
            this.errorMessages.setText("\n" + GenericNames.ERROR + ": " + e.getMessage());
            return false;
        }
        return true;
    }
}

