/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.wms.AxisOrder;
import org.locationtech.jts.geom.Envelope;

public class BoundingBox {
    private final String srs;
    private final AxisOrder axisOrder;
    private final double westBound;
    private final double southBound;
    private final double eastBound;
    private final double northBound;

    public BoundingBox(String srs, Envelope envelope) {
        this.srs = srs;
        this.axisOrder = AxisOrder.getAxisOrder(srs);
        this.westBound = envelope.getMinX();
        this.southBound = envelope.getMinY();
        this.eastBound = envelope.getMaxX();
        this.northBound = envelope.getMaxY();
    }

    public BoundingBox(String srs, double westBound, double southBound, double eastBound, double northBound) {
        this.srs = srs;
        this.axisOrder = AxisOrder.getAxisOrder(srs);
        this.westBound = westBound;
        this.southBound = southBound;
        this.eastBound = eastBound;
        this.northBound = northBound;
    }

    public String getSRS() {
        return this.srs;
    }

    public AxisOrder getAxisOrder() {
        return this.axisOrder;
    }

    public double getWestBound() {
        return this.westBound;
    }

    public double getSouthBound() {
        return this.southBound;
    }

    public double getEastBound() {
        return this.eastBound;
    }

    public double getNorthBound() {
        return this.northBound;
    }

    public String getBBox(String wmsVersion) {
        if (this.axisOrder.equals((Object)AxisOrder.LONLAT) || wmsVersion.equals("1.0.0") || wmsVersion.equals("1.1.0") || wmsVersion.equals("1.1.1")) {
            return "BBOX=" + this.westBound + "," + this.southBound + "," + this.eastBound + "," + this.northBound;
        }
        return "BBOX=" + this.southBound + "," + this.westBound + "," + this.northBound + "," + this.eastBound;
    }

    public Envelope getEnvelope() {
        return new Envelope(this.westBound, this.eastBound, this.southBound, this.northBound);
    }

    public String toString() {
        return this.axisOrder == AxisOrder.LATLON ? "BBOX(" + this.getSRS() + ", " + this.southBound + ", " + this.westBound + ", " + this.northBound + ", " + this.eastBound + ")" : "BBOX(" + this.getSRS() + ", " + this.westBound + ", " + this.southBound + ", " + this.eastBound + ", " + this.northBound + ")";
    }
}

