/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadQueue;
import java.awt.geom.NoninvertibleTransformException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class PanToSelectedItemsPlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.pan(context.getLayerViewPanel().getSelectionManager().getSelectedItems(), context.getLayerViewPanel());
        return true;
    }

    public void pan(final Collection geometries, final LayerViewPanel panel) throws NoninvertibleTransformException {
        if (this.envelope(geometries).isNull()) {
            return;
        }
        Envelope proposedEnvelope = panel.getViewport().getEnvelopeInModelCoordinates();
        EnvelopeUtil.translate(proposedEnvelope, CoordUtil.subtract(EnvelopeUtil.centre(this.envelope(geometries)), EnvelopeUtil.centre(proposedEnvelope)));
        panel.getViewport().zoom(proposedEnvelope);
        ThreadQueue.Listener listener = new ThreadQueue.Listener(){

            @Override
            public void allRunningThreadsFinished() {
                panel.getRenderingManager().getDefaultRendererThreadQueue().remove(this);
                try {
                    GUIUtil.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PanToSelectedItemsPlugIn.this.flash(geometries, panel);
                            }
                            catch (NoninvertibleTransformException noninvertibleTransformException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        };
        panel.getRenderingManager().getDefaultRendererThreadQueue().add(listener);
    }

    private Envelope envelope(Collection geometries) {
        Envelope envelope = new Envelope();
        for (Geometry geometry : geometries) {
            envelope.expandToInclude(geometry.getEnvelopeInternal());
        }
        return envelope;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }

    public void flash(Collection geometries, LayerViewPanel panel) throws NoninvertibleTransformException {
        GeometryCollection gc = this.toGeometryCollection(geometries);
        if (!panel.getViewport().getEnvelopeInModelCoordinates().intersects(gc.getEnvelopeInternal())) {
            return;
        }
        panel.flash(gc);
    }

    private GeometryCollection toGeometryCollection(Collection geometries) {
        return new GeometryFactory().createGeometryCollection(geometries.toArray(new Geometry[0]));
    }
}

