/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.toolbox;

import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.CheckBoxed;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import java.util.HashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;

public abstract class ToolboxPlugInV2
extends AbstractPlugIn
implements CheckBoxed {
    private static HashMap toolboxMap = new HashMap();

    public ToolboxDialog getToolbox() throws Exception {
        String name = this.getName();
        ToolboxDialog toolbox = (ToolboxDialog)toolboxMap.get(name);
        if (toolbox == null) {
            toolbox = this.initializeToolbox();
            toolbox.finishAddingComponents();
            toolboxMap.put(name, toolbox);
        }
        return toolbox;
    }

    protected abstract ToolboxDialog initializeToolbox() throws Exception;

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ToolboxDialog tb = this.getToolbox();
        tb.setVisible(!tb.isVisible());
        return true;
    }

    @Override
    public EnableCheck getEnableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String name = ToolboxPlugInV2.this.getName();
                ToolboxDialog tb = (ToolboxDialog)toolboxMap.get(name);
                if (component instanceof JCheckBoxMenuItem) {
                    ((JCheckBoxMenuItem)component).setSelected(tb != null && tb.isVisible());
                }
                return null;
            }
        };
    }
}

