/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.TextEditor;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.style.LegendPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.util.LayerableUtil;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class LegendPlugIn
extends AbstractPlugIn {
    private JScrollPane scrollPane = new JScrollPane();
    String taskString = I18N.getInstance().get("ui.WorkbenchFrame.task");
    String layerString = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.layer");
    String labelString = I18N.getInstance().get("ui.renderer.style.ColorThemingTableModel.label");
    WorkbenchFrame frame = JUMPWorkbench.getInstance().getFrame();
    AdditionalResults frames;
    private static final String EMPTY = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.empty");
    private static final String POINT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.point");
    private static final String POLYLINE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.polyline");
    private static final String POLYGON = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.polygon");
    private static final String GEOMETRYCOLLECTION = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.geometrycollection");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(checkFactory.createSelectedLayersMustNotBeEmpty());
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("saig/addLegend.gif");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (this.getVectorLayers(context).size() == 0) {
            JOptionPane.showMessageDialog(this.frame, I18N.getInstance().get("org.openjump.core.ui.plugin.wms.WMSLegendPlugIn.message") + " (" + I18N.getInstance().get("com.vividsolutions.jump.workbench.imagery.ReferencedImagesLayer") + ", " + I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Null-Geometries") + ",...)", I18N.getInstance().get("ui.WorkbenchFrame.warning"), 2);
        } else {
            AdditionalResults.addAdditionalResultAndShow(this.getName() + "-" + I18N.getInstance().get("ui.WorkbenchFrame.task") + ": " + context.getTask().getName(), this.legend(context));
        }
        return true;
    }

    private LegendPanel legendPanel(Layer layer, BasicStyle style, FeatureCollection featureCollection) {
        LegendPanel previewPanel = new LegendPanel(layer, style, featureCollection);
        previewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
            }
        });
        return previewPanel;
    }

    private JLabel label(String text, Font font, int increaseSize) {
        final JLabel labelValue = new JLabel();
        labelValue.setToolTipText("");
        labelValue.setBorder(BorderFactory.createEmptyBorder());
        font = new Font(labelValue.getFont().getName(), labelValue.getFont().getStyle(), labelValue.getFont().getSize() + increaseSize);
        labelValue.setFont(font);
        labelValue.setText(text);
        labelValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    TextEditor fc = new TextEditor();
                    fc.setSelectedFont(labelValue.getFont());
                    fc.setSelectedFontSize(labelValue.getFont().getSize());
                    fc.setSelectedFontStyle(labelValue.getFont().getStyle());
                    fc.setSelectedFontFamily(labelValue.getFont().getFamily());
                    fc.setSampleTextField(labelValue.getText());
                    fc.showDialog(labelValue.getParent(), I18N.getInstance().get("org.openjump.core.ui.plugin.style.LegendPlugIn.modify-label"));
                    Font labelFont = fc.getSelectedFont();
                    if (fc.wasOKPressed()) {
                        labelValue.setFont(labelFont);
                        labelValue.setText(fc.getSampleTextField().getText());
                    } else {
                        LegendPlugIn.this.reportNothingToUndoYet(null);
                    }
                }
            }
        });
        labelValue.setForeground(new Color(20, 24, 25));
        return labelValue;
    }

    private void mapByGeomType(Feature feature, Map<String, FeatureCollection> map) {
        Geometry geometry = feature.getGeometry();
        Feature f = feature.clone(false, true);
        f.setGeometry(geometry);
        if (geometry.getGeometryType().equals("Point")) {
            map.get(POINT).add(f);
        } else if (geometry.getGeometryType().equals("MultiPoint")) {
            map.get(POINT).add(f);
        } else if (geometry.getGeometryType().equals("LineString")) {
            map.get(POLYLINE).add(f);
        } else if (geometry.getGeometryType().equals("MultiLineString")) {
            map.get(POLYLINE).add(f);
        } else if (geometry.getGeometryType().equals("Polygon")) {
            map.get(POLYGON).add(f);
        } else if (geometry.getGeometryType().equals("MultiPolygon")) {
            map.get(POLYGON).add(f);
        } else {
            map.get(GEOMETRYCOLLECTION).add(f);
        }
    }

    public JPanel layersPanel(List<Layer> layers) {
        JPanel mainPanel = new JPanel();
        Font plainFont = new Font(mainPanel.getFont().getName(), 0, mainPanel.getFont().getSize());
        mainPanel.setLayout(new GridBagLayout());
        boolean gridx = false;
        int gridy = 0;
        String projectTitle = this.taskString + ": " + JUMPWorkbench.getInstance().getContext().getTask().getName();
        JLabel projectName = this.label(projectTitle, plainFont, 6);
        projectName.setToolTipText(projectTitle);
        FormUtils.addRowInGBL((JComponent)mainPanel, gridy, 1, (JComponent)projectName, false, true);
        int n = ++gridy;
        ++gridy;
        FormUtils.addSpacerInGBL(mainPanel, n, 0, 80, Color.white);
        ++gridy;
        for (Layer layer : layers) {
            LegendPanel previewPanel = null;
            FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            FeatureDataset emptyFeatures = new FeatureDataset(schema);
            FeatureDataset pointFeatures = new FeatureDataset(schema);
            FeatureDataset polyLineFeatures = new FeatureDataset(schema);
            FeatureDataset polygonFeatures = new FeatureDataset(schema);
            FeatureDataset geometryCollectionFeatures = new FeatureDataset(schema);
            HashMap<String, FeatureCollection> mapfeat = new HashMap<String, FeatureCollection>();
            mapfeat.put(EMPTY, emptyFeatures);
            mapfeat.put(POINT, pointFeatures);
            mapfeat.put(POLYLINE, polyLineFeatures);
            mapfeat.put(POLYGON, polygonFeatures);
            mapfeat.put(GEOMETRYCOLLECTION, geometryCollectionFeatures);
            FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
            for (Feature feature : featureCollection.getFeatures()) {
                this.mapByGeomType(feature, mapfeat);
            }
            if (ColorThemingStyle.get(layer).isEnabled()) {
                JLabel layerName = this.label(layer.getName(), plainFont, 4);
                layerName.setToolTipText(this.taskString + " :" + JUMPWorkbench.getInstance().getContext().getTask().getName() + " - " + this.layerString + " :" + layer.getName());
                FormUtils.addRowInGBL((JComponent)mainPanel, gridy++, 0, (JComponent)layerName, true, true);
                Map<Object, BasicStyle> attributeValueToBasicStyleMap = ColorThemingStyle.get(layer).getAttributeValueToBasicStyleMap();
                Map<Object, String> attributeValueToLabelMap = ColorThemingStyle.get(layer).getAttributeValueToLabelMap();
                ArrayList<ColorThemingValue> colorThemingValues = new ArrayList<ColorThemingValue>();
                for (Map.Entry<Object, BasicStyle> entry : attributeValueToBasicStyleMap.entrySet()) {
                    Object key = entry.getKey();
                    for (Map.Entry entryFeatCol : mapfeat.entrySet()) {
                        if (((FeatureCollection)entryFeatCol.getValue()).size() == 0) continue;
                        if (this.isEsriType(layer)) {
                            colorThemingValues.add(new ColorThemingValue(key, entry.getValue(), attributeValueToLabelMap.get(key), (FeatureCollection)entryFeatCol.getValue()));
                            continue;
                        }
                        Set<String> listValues = LegendPlugIn.getAvailableValues(ColorThemingStyle.get(layer), (FeatureCollection)entryFeatCol.getValue());
                        for (String stock : listValues) {
                            if (!stock.toString().matches(entry.getKey().toString())) continue;
                            colorThemingValues.add(new ColorThemingValue(key, entry.getValue(), attributeValueToLabelMap.get(key), (FeatureCollection)entryFeatCol.getValue()));
                        }
                    }
                }
                for (ColorThemingValue colorThemingValue : colorThemingValues) {
                    previewPanel = this.legendPanel(layer, colorThemingValue.getStyle(), colorThemingValue.getFeatureCollection());
                    String text = colorThemingValue.toString();
                    JLabel entryName = this.label(colorThemingValue.toString(), plainFont, 2);
                    entryName.setToolTipText(this.taskString + " :" + JUMPWorkbench.getInstance().getContext().getTask().getName() + " - " + this.layerString + " :" + layer.getName() + " - " + this.labelString + " :" + text);
                    FormUtils.addRowInGBL((JComponent)mainPanel, gridy++, 0, previewPanel, (JComponent)entryName);
                    ++gridy;
                }
            } else {
                for (Map.Entry entryFeatCol : mapfeat.entrySet()) {
                    if (((FeatureCollection)entryFeatCol.getValue()).size() == 0) continue;
                    previewPanel = this.legendPanel(layer, layer.getBasicStyle(), (FeatureCollection)entryFeatCol.getValue());
                    previewPanel.setToolTipText(this.taskString + " :" + JUMPWorkbench.getInstance().getContext().getTask().getName() + " - " + this.layerString + " :" + layer.getName());
                    FormUtils.addRowInGBL((JComponent)mainPanel, gridy++, 0, previewPanel, (JComponent)this.label(layer.getName(), plainFont, 2));
                    ++gridy;
                }
            }
            FormUtils.addSpacerInGBL(mainPanel, gridy++, 0, 80, Color.white);
            ++gridy;
        }
        mainPanel.repaint();
        return mainPanel;
    }

    private List<Layer> getVectorLayers(PlugInContext context) {
        ArrayList<Layer> ListVectorLayerNames = new ArrayList<Layer>();
        Collection<Layer> layers1 = context.getLayerNamePanel().selectedNodes(Layer.class);
        for (Layer layer : layers1) {
            Envelope env = layer.getFeatureCollectionWrapper().getEnvelope();
            if (env.isNull() | LayerableUtil.isImage(layer)) {
                ListVectorLayerNames.remove(layer);
                continue;
            }
            ListVectorLayerNames.add(layer);
        }
        return ListVectorLayerNames;
    }

    private JScrollPane legend(PlugInContext context) throws IOException {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel mPanel = new JPanel();
        mPanel = this.layersPanel(this.getVectorLayers(context));
        this.scrollPane.setBackground(Color.WHITE);
        this.scrollPane = new JScrollPane(mPanel, 20, 30);
        this.scrollPane.getViewport().getView().setBackground(Color.WHITE);
        this.scrollPane.getViewport().getView().setForeground(Color.WHITE);
        this.scrollPane.setPreferredSize(new Dimension(400, context.getLayerViewPanel().getHeight() - 20));
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        mainPanel.add((Component)this.scrollPane, "Center");
        return this.scrollPane;
    }

    private boolean isEsriType(Layer layer) {
        return LayerableUtil.isLinealLayer(layer) || LayerableUtil.isPointLayer(layer) || LayerableUtil.isPolygonalLayer(layer);
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.style.LegendPlugIn");
    }

    public static Set<String> getAvailableValues(ColorThemingStyle style, FeatureCollection fc) {
        TreeSet<String> set = new TreeSet<String>();
        set.add("");
        for (Feature f : fc) {
            if (!style.isEnabled()) continue;
            try {
                set.add(f.getAttribute(style.getAttributeName()).toString());
            }
            catch (Throwable throwable) {}
        }
        return set;
    }

    public static class ColorThemingValue {
        private final Object value;
        private final BasicStyle style;
        private final String label;
        private final FeatureCollection featureCollection;

        ColorThemingValue(Object value, BasicStyle style, String label, FeatureCollection featureCollection) {
            this.value = value;
            this.style = style;
            Assert.isTrue((label != null ? 1 : 0) != 0);
            this.label = label;
            this.featureCollection = featureCollection;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object other) {
            return other instanceof ColorThemingValue && LangUtil.bothNullOrEqual(this.value, ((ColorThemingValue)other).value) && this.style == ((ColorThemingValue)other).style;
        }

        public BasicStyle getStyle() {
            return this.style;
        }

        public FeatureCollection getFeatureCollection() {
            return this.featureCollection;
        }
    }
}

