/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingFeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;

public class LayerRenderer
extends FeatureCollectionRenderer {
    private Layer layer;
    private LayerViewPanel panel;
    public static final String ALWAYS_USE_IMAGE_CACHING_KEY = LayerRenderer.class.getName() + " - ALWAYS USE IMAGE CACHING";

    public LayerRenderer(final Layer layer, LayerViewPanel panel) {
        super(layer, panel, new ImageCachingFeatureCollectionRenderer(layer, panel){

            @Override
            protected ThreadSafeImage getImage() {
                if (!layer.isVisible()) {
                    return null;
                }
                return super.getImage();
            }

            @Override
            public Runnable createRunnable() {
                if (!layer.isVisible()) {
                    return null;
                }
                return super.createRunnable();
            }
        });
        this.layer = layer;
        this.panel = panel;
    }

    @Override
    public Runnable createRunnable() {
        if (!LayerRenderer.render(this.layer, this.panel)) {
            return null;
        }
        return super.createRunnable();
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        if (!LayerRenderer.render(this.layer, this.panel)) {
            return;
        }
        super.copyTo(graphics);
    }

    public static boolean render(Layerable layerable, LayerViewPanel panel) {
        if (!layerable.isVisible()) {
            return false;
        }
        if (!layerable.getLayerManager().getLayerables(Layerable.class).contains(layerable)) {
            return false;
        }
        return LayerRenderer.withinVisibleScaleRange(layerable, panel);
    }

    public static boolean withinVisibleScaleRange(Layerable layerable, LayerViewPanel panel) {
        Assert.isTrue((layerable.getMaxScale() == null || layerable.getMinScale() == null || layerable.getMaxScale() <= layerable.getMinScale() ? 1 : 0) != 0);
        if (!layerable.isScaleDependentRenderingEnabled()) {
            return true;
        }
        if (layerable.getMaxScale() != null && LayerRenderer.scale(panel) < layerable.getMaxScale()) {
            return false;
        }
        return layerable.getMinScale() == null || !(LayerRenderer.scale(panel) > layerable.getMinScale());
    }

    private static double scale(LayerViewPanel panel) {
        return 1.0 / panel.getViewport().getScale();
    }

    @Override
    protected Collection<Style> styles() {
        ArrayList<Style> styles = new ArrayList<Style>(this.layer.getStyles());
        styles.remove(this.layer.getVertexStyle());
        styles.remove(this.layer.getLabelStyle());
        styles.add(this.layer.getVertexStyle());
        styles.add(this.layer.getLabelStyle());
        return styles;
    }

    @Override
    protected boolean useImageCaching(Map<Layer, List<Feature>> layerToFeaturesMap) {
        if (this.layer.getBlackboard().get(ALWAYS_USE_IMAGE_CACHING_KEY, false)) {
            return true;
        }
        return super.useImageCaching(layerToFeaturesMap);
    }

    @Override
    protected Map<Layer, Collection<Feature>> layerToFeaturesMap() {
        Envelope viewportEnvelope = this.panel.getViewport().getEnvelopeInModelCoordinates();
        return Collections.singletonMap(this.layer, this.layer.getFeatureCollectionWrapper().query(viewportEnvelope));
    }

    @Override
    public int getMaxFeatures() {
        return super.getMaxFeatures();
    }

    @Override
    public void setMaxFeatures(int maxFeatures) {
        super.setMaxFeatures(maxFeatures);
    }
}

