/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemovePanel;
import com.vividsolutions.jump.workbench.ui.addremove.DefaultAddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.TreeAddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.TreeAddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerTreeModel;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.MapStyle;
import com.vividsolutions.wms.WMService;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.locationtech.jts.util.Assert;

public class MapLayerPanel
extends JPanel {
    public static final ImageIcon ICON = IconLoader.icon("globe3_13.png");
    private final InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private AddRemovePanel addRemovePanel;
    private final JCheckBox checkBox = new JCheckBox(I18N.getInstance().get("ui.plugin.wms.MapLayerPanel.sort"), true);
    private final Map<String, String> fullSrsMap = new HashMap<String, String>();
    private WMService service = null;

    public MapLayerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initAddRemovePanel();
    }

    public List<MapLayer> getChosenMapLayers() {
        ArrayList<MapLayer> mapLayers = new ArrayList<MapLayer>();
        for (Object object : this.addRemovePanel.getRightItems()) {
            MapLayerTreeModel.LayerNode node = (MapLayerTreeModel.LayerNode)object;
            Assert.isTrue((node.getLayer().getName() != null ? 1 : 0) != 0);
            mapLayers.add(node.getLayer());
        }
        return mapLayers;
    }

    public WMService getService() {
        return this.service;
    }

    private void setRendererText(JLabel renderer, MapLayer layer) {
        String label = this.fullSrsMap.get(layer.getTitle());
        if (label == null) {
            label = layer.getTitle();
            this.fullSrsMap.put(layer.getTitle(), label);
        }
        renderer.setText(label);
    }

    void jbInit() {
        this.addRemovePanel = new AddRemovePanel(true);
        this.addRemovePanel.setRightText(I18N.getInstance().get("ui.plugin.wms.MapLayerPanel.chosen-layers"));
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.addRemovePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    private void addIfOnList(MapLayer layer, AddRemoveListModel model, Collection<String> names) {
        if (names.contains(layer.getName())) {
            model.add(new MapLayerTreeModel.LayerNode(layer, null));
        }
        for (MapLayer child : layer.getSubLayerList()) {
            this.addIfOnList(child, model, names);
        }
    }

    public List<String> commonSRSList() {
        List<MapLayer> mapLayers = this.getChosenMapLayers();
        ArrayList<String> commonSRSList = new ArrayList<String>();
        for (MapLayer mapLayer : mapLayers) {
            if (commonSRSList.isEmpty()) {
                commonSRSList.addAll(mapLayer.getFullSRSList());
                continue;
            }
            commonSRSList.retainAll(mapLayer.getFullSRSList());
        }
        return commonSRSList;
    }

    public List<MapStyle> commonStyleList() {
        List<MapLayer> mapLayers = this.getChosenMapLayers();
        if (mapLayers.isEmpty()) {
            return new ArrayList<MapStyle>();
        }
        ArrayList<MapStyle> commonStyleList = new ArrayList<MapStyle>(mapLayers.get(0).getStyles());
        for (MapLayer mapLayer : mapLayers) {
            commonStyleList.retainAll(mapLayer.getStyles());
        }
        return commonStyleList;
    }

    private void initAddRemovePanel() {
        TreeAddRemoveList leftList = new TreeAddRemoveList(){

            @Override
            public List<?> getSelectedItems() {
                ArrayList<MapLayerTreeModel.LayerNode> selectedItems = new ArrayList<MapLayerTreeModel.LayerNode>(super.getSelectedItems());
                selectedItems.removeIf(MapLayerTreeModel.LayerNode::isContainer);
                return selectedItems;
            }
        };
        this.addRemovePanel.setLeftList(leftList);
        leftList.getTree().setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (!(value instanceof MapLayerTreeModel.LayerNode)) {
                    return component;
                }
                MapLayer layer = ((MapLayerTreeModel.LayerNode)value).getLayer();
                MapLayerPanel.this.setRendererText(component, layer);
                if (layer.getName() == null) {
                    if (expanded) {
                        component.setIcon(UIManager.getIcon("Tree.openIcon"));
                    } else {
                        component.setIcon(UIManager.getIcon("Tree.closedIcon"));
                    }
                } else {
                    component.setIcon(ICON);
                }
                return component;
            }
        });
        DefaultAddRemoveList rightList = new DefaultAddRemoveList(new DefaultListModel<MapLayerTreeModel.LayerNode>(){

            @Override
            public void addElement(MapLayerTreeModel.LayerNode obj) {
                if (this.contains(obj)) {
                    return;
                }
                super.addElement(obj);
            }
        });
        this.addRemovePanel.setRightList(rightList);
        rightList.getList().setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                MapLayer layer = ((MapLayerTreeModel.LayerNode)value).getLayer();
                MapLayerPanel.this.setRendererText(component, layer);
                component.setIcon(ICON);
                return component;
            }
        });
        leftList.add(this.inputChangedFirer::fire);
        rightList.add(this.inputChangedFirer::fire);
        rightList.getList().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }
        });
        JPanel leftLabelPanel = new JPanel();
        leftLabelPanel.setLayout(new GridBagLayout());
        leftLabelPanel.add((Component)new JLabel(I18N.getInstance().get("ui.plugin.wms.MapLayerPanel.available-layers")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        leftLabelPanel.add((Component)new JPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.checkBox.addActionListener(e -> this.setSorted(this.checkBox.isSelected()));
        leftLabelPanel.add((Component)this.checkBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addRemovePanel.setLeftLabel(leftLabelPanel);
    }

    private void setSorted(boolean isSorted) {
        TreeAddRemoveList tarl = (TreeAddRemoveList)this.addRemovePanel.getLeftList();
        TreeAddRemoveListModel tarlm = (TreeAddRemoveListModel)tarl.getModel();
        MapLayerTreeModel mltm = (MapLayerTreeModel)tarlm.getTreeModel();
        mltm.setSorted(isSorted);
    }

    public void init(WMService service, Collection<String> initialChosenMapLayers) {
        this.service = service;
        final MapLayerTreeModel treeModel = new MapLayerTreeModel(service.getCapabilities().getTopLayer());
        treeModel.setSorted(this.checkBox.isSelected());
        TreeAddRemoveListModel treeAddRemoveListModel = new TreeAddRemoveListModel(treeModel){

            @Override
            public List<MapLayerTreeModel.LayerNode> getItems() {
                ArrayList<MapLayerTreeModel.LayerNode> items = new ArrayList<MapLayerTreeModel.LayerNode>(MapLayerPanel.this.items((MapLayerTreeModel.LayerNode)treeModel.getRoot()));
                items.removeIf(MapLayerTreeModel.LayerNode::isContainer);
                return items;
            }
        };
        ((TreeAddRemoveList)this.addRemovePanel.getLeftList()).setModel(treeAddRemoveListModel);
        this.addRemovePanel.getRightList().getModel().setItems(new ArrayList());
        if (initialChosenMapLayers != null) {
            this.addIfOnList(service.getCapabilities().getTopLayer(), this.addRemovePanel.getRightList().getModel(), initialChosenMapLayers);
        }
        this.addRemovePanel.updateEnabled();
    }

    public void reset() {
        ((TreeAddRemoveList)this.addRemovePanel.getLeftList()).setModel(new TreeAddRemoveListModel(new DefaultTreeModel(null)));
        this.addRemovePanel.getRightList().getModel().setItems(new ArrayList());
        this.addRemovePanel.updateEnabled();
    }

    private List<MapLayerTreeModel.LayerNode> items(MapLayerTreeModel.LayerNode node) {
        ArrayList<MapLayerTreeModel.LayerNode> items = new ArrayList<MapLayerTreeModel.LayerNode>();
        items.add(node);
        Enumeration<MapLayerTreeModel.LayerNode> e = node.children();
        while (e.hasMoreElements()) {
            MapLayerTreeModel.LayerNode child = e.nextElement();
            items.addAll(this.items(child));
        }
        items.removeAll(this.addRemovePanel.getRightItems());
        return items;
    }
}

