/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.imagery;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactoryFileLayerLoader;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.imagery.ReferencedImagesLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.openjump.core.ui.plugin.file.open.OpenFileWizard;

public class ImageLayerManagerPlugIn
extends AbstractPlugIn {
    public ImageLayerManagerPlugIn() {
        super(I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerPlugIn.Image-Layer-Manager"));
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("maps-edit_16.png");
    }

    public static EnableCheck createEnableCheck(final WorkbenchContext context) {
        MultiEnableCheck mec = new MultiEnableCheck();
        mec.add(EnableCheckFactory.getInstance(context).createExactlyNLayersMustBeSelectedCheck(1));
        mec.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return context.getLayerNamePanel().getSelectedLayers()[0].getStyle(ReferencedImageStyle.class) == null ? I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerPlugIn.Layer-must-be-an-Imagery-layer") : null;
            }
        });
        return mec;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ImageLayerManagerDialog dlg = new ImageLayerManagerDialog(context);
        dlg.pack();
        dlg.setModal(true);
        GUIUtil.centre(dlg, context.getWorkbenchFrame());
        dlg.setVisible(true);
        return false;
    }

    private static class ImageLayerManagerDialog
    extends JDialog {
        private static final long serialVersionUID = 3199060497667524101L;
        private PlugInContext context;
        private Layer layer;
        private Vector images;
        private JList imagesPaths;
        private JTextArea metadata;
        private JScrollPane metadataScrollPane;

        public ImageLayerManagerDialog(PlugInContext context) {
            super(context.getWorkbenchFrame());
            this.context = context;
            this.setTitle(I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Image-Layer-Manager"));
            this.layer = context.getSelectedLayer(0);
            this.updateImages();
            this.initialize();
            this.loadMetadata();
            this.imagesPaths.setSelectedIndex(0);
        }

        private void updateImages() {
            this.images = new Vector();
            if (this.layer == null) {
                return;
            }
            Iterator<Feature> i = this.layer.getFeatureCollectionWrapper().getFeatures().iterator();
            while (i.hasNext()) {
                this.images.add(new FeaturePrinter(i.next()));
            }
        }

        private void initialize() {
            JPanel mainPanel = this.createMainPanel();
            JPanel buttonPanel = this.createButtonPanel();
            JPanel dialogPanel = new JPanel(new BorderLayout());
            dialogPanel.add((Component)mainPanel, "Center");
            dialogPanel.add((Component)buttonPanel, "East");
            this.getContentPane().add(dialogPanel);
        }

        private JPanel createMainPanel() {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            this.imagesPaths = new JList();
            this.imagesPaths.setListData(this.images);
            this.imagesPaths.setBorder(BorderFactory.createLoweredBevelBorder());
            this.imagesPaths.setFont(this.context.getActiveInternalFrame().getFont());
            JScrollPane imagePathsScrollPane = new JScrollPane(this.imagesPaths);
            imagePathsScrollPane.setPreferredSize(new Dimension(400, 150));
            imagePathsScrollPane.setMinimumSize(new Dimension(400, 150));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.fill = 2;
            this.imagesPaths.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.loadMetadata();
                }
            });
            this.imagesPaths.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.flashSelectedImages();
                }
            });
            mainPanel.add((Component)imagePathsScrollPane, gbc);
            JLabel label = new JLabel();
            label.setText("Image Metadata");
            label.setFont(this.context.getActiveInternalFrame().getFont());
            label.setBackground(this.getBackground());
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.fill = 0;
            mainPanel.add((Component)label, gbc);
            this.metadata = new JTextArea();
            this.metadata.setBackground(this.getBackground());
            this.metadata.setAutoscrolls(true);
            this.metadata.setFont(this.context.getActiveInternalFrame().getFont());
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.ipadx = 4;
            gbc.ipady = 4;
            gbc.fill = 1;
            this.metadata.setMargin(new Insets(4, 4, 4, 4));
            this.metadata.setEditable(false);
            this.metadataScrollPane = new JScrollPane(this.metadata);
            this.metadataScrollPane.setPreferredSize(new Dimension(400, 100));
            mainPanel.add((Component)this.metadataScrollPane, gbc);
            return mainPanel;
        }

        private JPanel createButtonPanel() {
            int buttonNumber = 0;
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            JButton button = new JButton(I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Add") + "...", GUIUtil.toSmallIcon(IconLoader.icon("Plus.gif")));
            button.addActionListener(new AddButtonListener());
            buttonPanel.add((Component)button, new GridBagConstraints(0, buttonNumber++, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
            button = new JButton(I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Delete"), GUIUtil.toSmallIcon(IconLoader.icon("Delete.gif")));
            button.addActionListener(new DeleteButtonListener());
            buttonPanel.add((Component)button, new GridBagConstraints(0, buttonNumber++, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
            button = new JButton(I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Close"));
            button.addActionListener(new CloseButtonListener(this));
            buttonPanel.add((Component)button, new GridBagConstraints(0, buttonNumber++, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
            buttonPanel.add((Component)new Label(), new GridBagConstraints(0, buttonNumber++, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
            return buttonPanel;
        }

        private void flashSelectedImages() {
            GeometryFactory factory = new GeometryFactory();
            Object[] values = this.imagesPaths.getSelectedValues();
            Geometry[] geoms = new Geometry[values.length];
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    FeaturePrinter current = (FeaturePrinter)values[i];
                    geoms[i] = current.instance.getGeometry();
                }
            }
            try {
                GeometryCollection gc = factory.createGeometryCollection(geoms);
                this.context.getLayerViewPanel().flash(gc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadMetadata() {
            Object[] values;
            StringBuffer buf = new StringBuffer();
            if (this.images.size() > 0 && (values = this.imagesPaths.getSelectedValues()) != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    FeaturePrinter current;
                    if (values[i] != null && (current = (FeaturePrinter)values[i]).instance != null) {
                        this.appendMetadata(current.instance, buf);
                    }
                    buf.append("\n");
                }
            }
            buf.append("\n  ");
            this.metadata.setText(buf.toString());
            this.metadata.setCaretPosition(0);
        }

        private void appendMetadata(Feature imageFeat, StringBuffer buf) {
            buf.append("  " + I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Uri") + ": \t" + imageFeat.getAttribute(ImageryLayerDataset.ATTR_URI) + "\n");
            buf.append("  " + I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Factory") + ": \t" + imageFeat.getAttribute(ImageryLayerDataset.ATTR_FACTORY) + "\n");
            buf.append("  " + I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Type") + ": \t" + imageFeat.getAttribute(ImageryLayerDataset.ATTR_TYPE) + "\n");
            buf.append("  " + I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Loader") + ": \t" + imageFeat.getAttribute(ImageryLayerDataset.ATTR_LOADER) + "\n");
            this.appendEnvelope(imageFeat.getGeometry().getEnvelopeInternal(), buf);
        }

        private void appendEnvelope(Envelope env, StringBuffer buf) {
            buf.append("  " + I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Lower-Left") + ":  \t" + env.getMinX() + ", " + env.getMinY() + "\n");
            buf.append("  " + I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Upper-Right") + ": \t" + env.getMaxX() + ", " + env.getMaxY() + "\n");
        }

        private void deleteSelectedImages() {
            Object[] values = this.imagesPaths.getSelectedValues();
            for (int i = 0; values != null && i < values.length; ++i) {
                if (values[i] == null) continue;
                FeaturePrinter current = (FeaturePrinter)values[i];
                if (current.instance != null) {
                    Feature feat = current.instance;
                    this.layer.getFeatureCollectionWrapper().remove(feat);
                }
                this.images.remove(current);
                this.imagesPaths.setListData(this.images);
            }
        }

        private void loadImages() {
            final WorkbenchFrame workbenchFrame = this.context.getWorkbenchFrame();
            WorkbenchContext workbenchContext = this.context.getWorkbenchContext();
            final WizardDialog dialog = new WizardDialog((Frame)workbenchFrame, this.getName(), this.context.getErrorHandler());
            final OpenFileWizard wizard = new OpenFileWizard(workbenchContext, ReferencedImageFactoryFileLayerLoader.class);
            wizard.setLayer((ReferencedImagesLayer)this.layer);
            wizard.initialize(workbenchContext, dialog);
            List<WizardPanel> panels = wizard.getPanels();
            String firstId = wizard.getFirstId();
            dialog.init(panels);
            dialog.setCurrentWizardPanel(firstId);
            dialog.pack();
            GUIUtil.centreOnWindow(dialog);
            dialog.setVisible(true);
            boolean result = dialog.wasFinishPressed();
            try {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            wizard.run(dialog, new TaskMonitorDialog((Frame)workbenchFrame, context.getErrorHandler()));
                            this.updateImages();
                            imagesPaths.setListData(images);
                        }
                        catch (Exception e) {
                            throw new Error(e);
                        }
                    }
                };
                t.start();
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }

        private class CloseButtonListener
        implements ActionListener {
            private JDialog dialog;

            CloseButtonListener(JDialog dlg) {
                this.dialog = dlg;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.dialog.dispose();
            }
        }

        private class AddButtonListener
        implements ActionListener {
            private AddButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageLayerManagerDialog.this.loadImages();
            }
        }

        private class DeleteButtonListener
        implements ActionListener {
            private DeleteButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageLayerManagerDialog.this.deleteSelectedImages();
            }
        }
    }

    private static class FeaturePrinter {
        private Feature instance;

        public FeaturePrinter(Feature i) {
            this.instance = i;
        }

        public String toString() {
            String val = this.instance == null ? "   " : (String)this.instance.getAttribute(ImageryLayerDataset.ATTR_URI);
            return val;
        }
    }
}

