/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.MultiTabInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.locationtech.jts.algorithm.distance.DistanceToPoint;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class OffsetCurvePlugIn
extends AbstractThreadedUiPlugIn {
    private String MAIN_OPTIONS;
    private String PROCESSED_DATA;
    private String LAYER;
    private String SELECTION;
    private String SELECTION_HELP;
    private String DISTANCE;
    private String FIXED_DISTANCE;
    private String ATTRIBUTE;
    private String FROM_ATTRIBUTE;
    private String ATTRIBUTE_TOOLTIP;
    private String ROUGH_OFFSET_CURVE;
    private String ROUGH_OFFSET_CURVE_TOOLTIP;
    private String OFFSET;
    private String OTHER_OPTIONS;
    private String QUADRANT_SEGMENTS;
    private String ADVANCED_OPTIONS;
    private String JOIN_STYLE_TITLE;
    private String JOIN_STYLE;
    private String JOIN_BEVEL;
    private String JOIN_MITRE;
    private String JOIN_ROUND;
    private String MITRE_LIMIT;
    private String S_FEATURES_PROCESSED;
    private List<String> joinStyles;
    private Layer layer;
    private double offsetDistance = 1.0;
    private boolean roughOffsetCurve = false;
    private int joinStyleCode = 1;
    private double mitreLimit = 10.0;
    private boolean useSelected = false;
    private int quadrantSegments = 8;
    private String sideBarText = "";
    private boolean fromAttribute = false;
    private int attributeIndex = 0;
    private String categoryName = StandardCategoryNames.RESULT;

    public OffsetCurvePlugIn() {
        super(I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.analysis.OffsetCurvePlugIn") + "...", IconLoader.icon("offset.png"));
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName(), false, null, OffsetCurvePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.MAIN_OPTIONS = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.main-options");
        this.PROCESSED_DATA = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.processed-data");
        this.LAYER = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.layer");
        this.SELECTION = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.selection");
        this.SELECTION_HELP = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.selection-help");
        this.DISTANCE = I18N.getInstance().get("ui.plugin.analysis.OffsetCurvePlugIn.distance");
        this.FIXED_DISTANCE = I18N.getInstance().get("ui.plugin.analysis.OffsetCurvePlugIn.fixed-distance");
        this.FROM_ATTRIBUTE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.get-distance-from-attribute-value");
        this.ATTRIBUTE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.attribute-to-use");
        this.ATTRIBUTE_TOOLTIP = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.attribute-to-use-tooltip");
        this.ROUGH_OFFSET_CURVE = I18N.getInstance().get("ui.plugin.analysis.OffsetCurvePlugIn.rough-offset-curve");
        this.ROUGH_OFFSET_CURVE_TOOLTIP = I18N.getInstance().get("ui.plugin.analysis.OffsetCurvePlugIn.rough-offset-curve-tooltip");
        this.OFFSET = I18N.getInstance().get("ui.plugin.analysis.OffsetCurvePlugIn.offset");
        this.OTHER_OPTIONS = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.other-options");
        this.QUADRANT_SEGMENTS = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Number-of-segments-per-circle-quarter");
        this.ADVANCED_OPTIONS = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.advanced-options");
        this.JOIN_STYLE_TITLE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-style-subtitle");
        this.JOIN_STYLE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-style");
        this.JOIN_BEVEL = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-bevel");
        this.JOIN_MITRE = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-mitre");
        this.JOIN_ROUND = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.join-round");
        this.MITRE_LIMIT = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.mitre-join-limit");
        this.S_FEATURES_PROCESSED = I18N.getInstance().get("jump.features-processed");
        this.joinStyles = new ArrayList<String>();
        this.joinStyles.add(this.JOIN_BEVEL);
        this.joinStyles.add(this.JOIN_MITRE);
        this.joinStyles.add(this.JOIN_ROUND);
        MultiTabInputDialog dialog = new MultiTabInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), this.MAIN_OPTIONS, true);
        int n = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
        this.useSelected = n > 0;
        this.sideBarText = I18N.getInstance().get("ui.plugin.analysis.OffsetCurvePlugIn.description");
        this.setDialogValues(dialog, context);
        this.updateControls(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection inputC;
        monitor.allowCancellationRequests();
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset resultFC = new FeatureDataset(featureSchema);
        if (this.useSelected) {
            inputC = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            Feature feature = inputC.iterator().next();
            featureSchema = feature.getSchema();
            inputC = PasteItemsPlugIn.conform(inputC, featureSchema);
        } else {
            inputC = this.layer.getFeatureCollectionWrapper().getFeatures();
            featureSchema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
            resultFC = new FeatureDataset(featureSchema);
        }
        FeatureDataset inputFD = new FeatureDataset(inputC, featureSchema);
        if (inputFD.isEmpty()) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.empty-result-set"));
            return;
        }
        Collection<Geometry> resultGeomColl = this.runOffset(monitor, context, inputFD);
        FeatureDataset resultFeatureColl = new FeatureDataset(featureSchema);
        Iterator<Geometry> iResult = resultGeomColl.iterator();
        for (Feature sourceFeature : inputFD.getFeatures()) {
            Geometry gResult = iResult.next();
            if (gResult != null && !gResult.isEmpty()) {
                Feature newFeature = sourceFeature.clone(true);
                newFeature.setGeometry(gResult);
                resultFeatureColl.add(newFeature);
            }
            if (!monitor.isCancelRequested()) continue;
            break;
        }
        if ((resultFC = resultFeatureColl).isEmpty()) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.empty-result-set"));
            return;
        }
        context.getLayerManager().addCategory(this.categoryName);
        String name = !this.useSelected ? this.layer.getName() : I18N.getInstance().get("ui.MenuNames.SELECTION");
        name = name + "-" + this.OFFSET + "-" + this.offsetDistance;
        context.addLayer(this.categoryName, name, resultFC);
    }

    private Collection<Geometry> runOffset(TaskMonitor monitor, PlugInContext context, FeatureCollection fcA) throws Exception {
        int total = fcA.size();
        int count = 0;
        ArrayList<Geometry> resultColl = new ArrayList<Geometry>();
        for (Feature fa : fcA.getFeatures()) {
            monitor.report(count++, total, this.S_FEATURES_PROCESSED);
            if (monitor.isCancelRequested()) break;
            Geometry ga = fa.getGeometry();
            if (this.fromAttribute) {
                Object o = fa.getAttribute(this.attributeIndex);
                if (o instanceof Double) {
                    this.offsetDistance = (Double)o;
                } else if (o instanceof Integer) {
                    this.offsetDistance = ((Integer)o).doubleValue();
                }
            }
            try {
                Geometry result = this.runOffset(ga);
                resultColl.add(result);
            }
            catch (Exception e) {
                String errorMessage = I18N.getInstance().get("ui.plugin.analysis.BufferPlugIn.error-found", fa.getID(), ga.getCoordinate().x, ga.getCoordinate().x);
                context.getWorkbenchFrame().warnUser(errorMessage);
                throw new Exception(errorMessage, e);
            }
        }
        return resultColl;
    }

    private Geometry runOffset(Geometry a) {
        GeometryFactory gf = a.getFactory();
        if (a.getDimension() == 2) {
            a = a.getBoundary();
        }
        BufferParameters parameters = new BufferParameters(this.quadrantSegments, 2, this.joinStyleCode, this.mitreLimit);
        ArrayList<Geometry> offsetCurves = new ArrayList<Geometry>();
        if (this.roughOffsetCurve) {
            this.addRoughOffsetCurves(offsetCurves, a, parameters);
        } else {
            this.addCleanOffsetCurves(offsetCurves, a, parameters);
        }
        return gf.buildGeometry(offsetCurves);
    }

    private Collection<Geometry> merge(Collection<Geometry> linestrings) {
        LineMerger merger = new LineMerger();
        merger.add(linestrings);
        return merger.getMergedLineStrings();
    }

    private void addCleanOffsetCurves(Collection<Geometry> offsetCurves, Geometry sourceCurve, BufferParameters parameters) {
        parameters.setSingleSided(true);
        parameters.setQuadrantSegments(this.quadrantSegments);
        Geometry sidedBuffer = new BufferOp(sourceCurve, parameters).getResultGeometry(this.offsetDistance).getBoundary();
        ArrayList<Geometry> offsetSegments = new ArrayList<Geometry>();
        double lowerBound = Math.abs(this.offsetDistance) * Math.sin(Math.PI / (double)(4 * this.quadrantSegments));
        double upperBound = Math.abs(this.offsetDistance) * Math.cos(Math.PI / (double)(2 * this.quadrantSegments));
        for (int i = 0; i < sidedBuffer.getNumGeometries(); ++i) {
            Coordinate[] cc = sidedBuffer.getGeometryN(i).getCoordinates();
            PointPairDistance ppd = new PointPairDistance();
            DistanceToPoint.computeDistance((Geometry)sourceCurve, (Coordinate)cc[0], (PointPairDistance)ppd);
            double dj = ppd.getDistance();
            for (int j = 1; j < cc.length; ++j) {
                double di = dj;
                ppd = new PointPairDistance();
                DistanceToPoint.computeDistance((Geometry)sourceCurve, (Coordinate)cc[j], (PointPairDistance)ppd);
                dj = ppd.getDistance();
                if (Math.max(di, dj) < lowerBound || di == 0.0 || dj == 0.0) continue;
                if (Math.min(di, dj) > upperBound) {
                    LineString segment = sourceCurve.getFactory().createLineString(new Coordinate[]{cc[j - 1], cc[j]});
                    offsetSegments.add((Geometry)segment);
                    continue;
                }
                if (Math.min(di, dj) > lowerBound && Math.max(di, dj) < upperBound) continue;
                this.divide(offsetSegments, sourceCurve, cc[j - 1], cc[j], di, dj, lowerBound, upperBound);
            }
        }
        offsetCurves.addAll(this.merge(offsetSegments));
    }

    private void divide(Collection<Geometry> offsetSegments, Geometry sourceCurve, Coordinate c1, Coordinate c2, double d1, double d2, double lb, double ub) {
        LineString segment;
        if (c1.distance(c2) < 2.0 * lb) {
            return;
        }
        Coordinate c = new Coordinate((c1.x + c2.x) / 2.0, (c1.y + c2.y) / 2.0);
        PointPairDistance ppd = new PointPairDistance();
        DistanceToPoint.computeDistance((Geometry)sourceCurve, (Coordinate)c, (PointPairDistance)ppd);
        double d = ppd.getDistance();
        if (!(Math.max(d1, d) < lb || Math.min(d1, d) > lb && Math.max(d1, d) < ub)) {
            if (Math.min(d1, d) > ub) {
                segment = sourceCurve.getFactory().createLineString(new Coordinate[]{c1, c});
                offsetSegments.add((Geometry)segment);
            } else {
                this.divide(offsetSegments, sourceCurve, c1, c, d1, d, lb, ub);
            }
        }
        if (!(Math.max(d, d2) < lb || Math.min(d, d2) > lb && Math.max(d, d2) < ub)) {
            if (Math.min(d, d2) > ub) {
                segment = sourceCurve.getFactory().createLineString(new Coordinate[]{c, c2});
                offsetSegments.add((Geometry)segment);
            } else {
                this.divide(offsetSegments, sourceCurve, c, c2, d, d2, lb, ub);
            }
        }
    }

    private void addRoughOffsetCurves(Collection<Geometry> offsetCurves, Geometry sourceCurve, BufferParameters parameters) {
        OffsetCurveBuilder builder = new OffsetCurveBuilder(sourceCurve.getFactory().getPrecisionModel(), parameters);
        for (int i = 0; i < sourceCurve.getNumGeometries(); ++i) {
            if (!(sourceCurve.getGeometryN(i) instanceof LineString)) continue;
            LineString lineString = (LineString)sourceCurve.getGeometryN(i);
            Coordinate[] cc = lineString.getCoordinates();
            if (lineString.isClosed()) {
                offsetCurves.add((Geometry)lineString.getFactory().createLineString(builder.getRingCurve(cc, this.offsetDistance > 0.0 ? 1 : 2, Math.abs(this.offsetDistance))));
                continue;
            }
            offsetCurves.add((Geometry)lineString.getFactory().createLineString(builder.getOffsetCurve(cc, this.offsetDistance)));
        }
    }

    private void setDialogValues(final MultiTabInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sideBarText);
        dialog.addSubTitle(this.PROCESSED_DATA);
        final JComboBox<Layer> layerComboBox = dialog.addLayerComboBox(this.LAYER, context.getCandidateLayer(0), context.getLayerManager());
        dialog.addLabel(this.SELECTION);
        dialog.addLabel(this.SELECTION_HELP);
        dialog.addSeparator();
        dialog.addSubTitle(this.DISTANCE);
        JTextField offsetDistanceTextField = dialog.addDoubleField(this.FIXED_DISTANCE, this.offsetDistance, 10, null);
        JCheckBox fromAttributeCheckBox = dialog.addCheckBox(this.FROM_ATTRIBUTE, false, this.ATTRIBUTE_TOOLTIP);
        JComboBox<String> attributeComboBox = dialog.addAttributeComboBox(this.ATTRIBUTE, this.LAYER, AttributeTypeFilter.NUMERIC_FILTER, this.ATTRIBUTE_TOOLTIP);
        JCheckBox roughOffsetCurveCheckBox = dialog.addCheckBox(this.ROUGH_OFFSET_CURVE, this.roughOffsetCurve, this.ROUGH_OFFSET_CURVE_TOOLTIP);
        dialog.addSeparator();
        dialog.addSubTitle(this.OTHER_OPTIONS);
        JTextField quadrantSegmentsIntegerField = dialog.addIntegerField(this.QUADRANT_SEGMENTS, this.quadrantSegments, 3, null);
        JComboBox<String> joinStyleComboBox = dialog.addComboBox(this.JOIN_STYLE, this.joinStyle(this.joinStyleCode), this.joinStyles, null);
        JTextField mitreLimitTextField = dialog.addDoubleField(this.MITRE_LIMIT, this.mitreLimit, 10, null);
        mitreLimitTextField.setEnabled(this.joinStyleCode == 2);
        quadrantSegmentsIntegerField.setEnabled(this.joinStyleCode == 1);
        layerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionListener listener : layerComboBox.getActionListeners()) {
                    if (listener == this) continue;
                    listener.actionPerformed(e);
                }
                OffsetCurvePlugIn.this.updateControls(dialog);
            }
        });
        fromAttributeCheckBox.addActionListener(e -> this.updateControls(dialog));
        joinStyleComboBox.addActionListener(e -> this.updateControls(dialog));
    }

    private void getDialogValues(MultiInputDialog dialog) {
        if (!this.useSelected) {
            this.layer = dialog.getLayer(this.LAYER);
        }
        this.offsetDistance = dialog.getDouble(this.FIXED_DISTANCE);
        this.roughOffsetCurve = dialog.getBoolean(this.ROUGH_OFFSET_CURVE);
        this.quadrantSegments = dialog.getInteger(this.QUADRANT_SEGMENTS);
        this.joinStyleCode = this.joinStyleCode(dialog.getText(this.JOIN_STYLE));
        this.mitreLimit = dialog.getDouble(this.MITRE_LIMIT);
        if (!this.useSelected) {
            boolean hasNumericAttributes = AttributeTypeFilter.NUMERIC_FILTER.filter(this.layer.getFeatureCollectionWrapper().getFeatureSchema()).size() > 0;
            this.fromAttribute = dialog.getBoolean(this.FROM_ATTRIBUTE);
            if (this.fromAttribute && dialog.getCheckBox(this.FROM_ATTRIBUTE).isEnabled() && hasNumericAttributes) {
                FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
                String attributeName = dialog.getText(this.ATTRIBUTE);
                this.attributeIndex = schema.getAttributeIndex(attributeName);
            } else {
                dialog.getCheckBox(this.FROM_ATTRIBUTE).setSelected(false);
                this.fromAttribute = false;
            }
        }
    }

    private int joinStyleCode(String joinStyle) {
        if (joinStyle.equals(this.JOIN_BEVEL)) {
            return 3;
        }
        if (joinStyle.equals(this.JOIN_MITRE)) {
            return 2;
        }
        return 1;
    }

    private String joinStyle(int joinStyleCode) {
        if (joinStyleCode == 3) {
            return this.JOIN_BEVEL;
        }
        if (joinStyleCode == 2) {
            return this.JOIN_MITRE;
        }
        return this.JOIN_ROUND;
    }

    protected void updateControls(MultiInputDialog dialog) {
        this.getDialogValues(dialog);
        boolean hasNumericAttributes = !this.useSelected && AttributeTypeFilter.NUMERIC_FILTER.filter(this.layer.getFeatureCollectionWrapper().getFeatureSchema()).size() > 0;
        dialog.setFieldVisible(this.LAYER, !this.useSelected);
        dialog.setFieldVisible(this.SELECTION, this.useSelected);
        dialog.setFieldVisible(this.SELECTION_HELP, this.useSelected);
        dialog.setFieldEnabled(this.FIXED_DISTANCE, this.useSelected || !this.fromAttribute || !hasNumericAttributes);
        dialog.setFieldEnabled(this.FROM_ATTRIBUTE, !this.useSelected && hasNumericAttributes);
        dialog.setFieldEnabled(this.ATTRIBUTE, !this.useSelected && this.fromAttribute && hasNumericAttributes);
        dialog.setFieldEnabled(this.QUADRANT_SEGMENTS, this.joinStyleCode == 1);
        dialog.setFieldEnabled(this.MITRE_LIMIT, this.joinStyleCode == 2);
    }
}

