/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.Operation;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.Macro;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.SchemaPanel;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Assert;

public class ViewSchemaPlugIn
extends AbstractPlugIn {
    private static final String KEY = ViewSchemaPlugIn.class + " - FRAME";
    private EditingPlugIn editingPlugIn;
    private GeometryFactory factory = new GeometryFactory();
    private WKTReader wktReader = new WKTReader(this.factory);
    private DateFormat dateFormatter = DateFormat.getDateInstance();
    private FlexibleDateParser fdp;
    private static final String P_LAYER_NAME = "LayerName";
    private static final String P_SCHEMA_MAPPING = "SchemaMapping";
    private static final String P_FORCE_INVALID_CONVERSIONS_TO_NULL = "ForceInvalidConversionsToNull";
    Pattern TRUE_PATTERN = Pattern.compile("(?i)^(T(rue)?|Y(es)?|V(rai)?|1)$");
    Pattern FALSE_PATTERN = Pattern.compile("(?i)^(F(alse)?|N(o)?|F(aux)?|0)$");
    public static final ImageIcon ICON = IconLoader.icon("Object.gif");

    public ViewSchemaPlugIn(EditingPlugIn editingPlugIn) {
        this.editingPlugIn = editingPlugIn;
    }

    public ViewSchemaPlugIn() {
        this.editingPlugIn = EditingPlugIn.getInstance();
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.ViewSchemaPlugIn.view-edit-schema");
    }

    private void applyChanges(Layer layer, SchemaPanel panel, WorkbenchFrame workbenchFrame) throws Exception {
        int i;
        if (!panel.isModified()) {
            return;
        }
        if (panel.validateInput() != null) {
            throw new Exception(panel.validateInput());
        }
        panel.getModel().removeBlankRows();
        FeatureSchema newSchema = new FeatureSchema();
        FeatureSchema oldSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i2 = 0; i2 < panel.getModel().getRowCount(); ++i2) {
            String attributeName = panel.getModel().get(i2).getName();
            newSchema.addAttribute(attributeName, panel.getModel().get(i2).getType());
            if (oldSchema.hasAttribute(attributeName)) {
                if (newSchema.getAttributeType(attributeName).equals(oldSchema.getAttributeType(attributeName))) {
                    newSchema.setAttributeReadOnly(newSchema.getAttributeIndex(attributeName), oldSchema.isAttributeReadOnly(oldSchema.getAttributeIndex(attributeName)));
                    newSchema.setOperation(newSchema.getAttributeIndex(attributeName), oldSchema.getOperation(oldSchema.getAttributeIndex(attributeName)));
                } else if (ColorThemingStyle.get(layer) != null) {
                    layer.removeStyle(ColorThemingStyle.get(layer));
                    layer.getBasicStyle().setEnabled(true);
                    layer.fireAppearanceChanged();
                }
            }
            newSchema.setCoordinateSystem(oldSchema.getCoordinateSystem());
        }
        List<Feature> originalFeatures = layer.getFeatureCollectionWrapper().getFeatures();
        ArrayList<Feature> tempFeatures = new ArrayList<Feature>();
        this.fdp = new FlexibleDateParser();
        this.fdp.cachingEnabled(true);
        for (Feature feature : layer.getFeatureCollectionWrapper()) {
            tempFeatures.add(this.convert(feature, panel, newSchema));
        }
        for (int i3 = 0; i3 < originalFeatures.size(); ++i3) {
            Feature originalFeature = originalFeatures.get(i3);
            Feature tempFeature = (Feature)tempFeatures.get(i3);
            originalFeature.setSchema(tempFeature.getSchema());
            originalFeature.setAttributes(tempFeature.getAttributes());
        }
        layer.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
        layer.setFeatureCollection(new FeatureDataset(originalFeatures, newSchema));
        layer.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        this.addParameter(P_FORCE_INVALID_CONVERSIONS_TO_NULL, panel.isForcingInvalidConversionsToNull());
        LinkedHashMap<String, Attribute> schemaMapping = new LinkedHashMap<String, Attribute>();
        for (i = 0; i < panel.getModel().getRowCount(); ++i) {
            String attributeName = panel.getModel().get(i).getName();
            Attribute attribute = new Attribute();
            attribute.setType(panel.getModel().get(i).getType());
            if (oldSchema.hasAttribute(attributeName)) {
                int oldIndex = oldSchema.getAttributeIndex(attributeName);
                attribute.setReadOnly(oldSchema.isAttributeReadOnly(oldIndex));
            }
            attribute.setOldIndex(panel.getModel().get(i).getOriginalIndex());
            schemaMapping.put(attributeName, attribute);
        }
        this.addParameter(P_SCHEMA_MAPPING, schemaMapping);
        for (i = 0; i < panel.getModel().getRowCount(); ++i) {
            panel.getModel().get(i).setOriginalIndex(i);
        }
        panel.markAsUnmodified();
    }

    private void applyChanges(Layer layer, Map<String, Attribute> schemaMapping, boolean isForcingInvalidConversionsToNull) throws Exception {
        FeatureSchema oldSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (String string : schemaMapping.keySet()) {
            if (!oldSchema.hasAttribute(string) || schemaMapping.get(string).getType().equals(oldSchema.getAttributeType(string)) || ColorThemingStyle.get(layer) == null) continue;
            layer.removeStyle(ColorThemingStyle.get(layer));
            layer.getBasicStyle().setEnabled(true);
            layer.fireAppearanceChanged();
        }
        FeatureSchema newSchema = new FeatureSchema();
        for (String name : schemaMapping.keySet()) {
            newSchema.addAttribute(name, schemaMapping.get(name).getType());
            newSchema.setAttributeReadOnly(newSchema.getAttributeIndex(name), schemaMapping.get(name).isReadOnly());
        }
        List<Feature> list = layer.getFeatureCollectionWrapper().getFeatures();
        ArrayList<Feature> tempFeatures = new ArrayList<Feature>();
        this.fdp = new FlexibleDateParser();
        this.fdp.cachingEnabled(true);
        for (Feature feature : layer.getFeatureCollectionWrapper()) {
            tempFeatures.add(this.convert(feature, schemaMapping, newSchema, isForcingInvalidConversionsToNull));
        }
        for (int i = 0; i < list.size(); ++i) {
            Feature originalFeature = list.get(i);
            Feature tempFeature = (Feature)tempFeatures.get(i);
            originalFeature.setSchema(tempFeature.getSchema());
            originalFeature.setAttributes(tempFeature.getAttributes());
        }
        layer.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
        layer.setFeatureCollection(new FeatureDataset(list, newSchema));
        layer.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    private Feature convert(Feature oldFeature, SchemaPanel panel, FeatureSchema newSchema) throws ConversionException {
        BasicFeature newFeature = new BasicFeature(newSchema);
        for (int i = 0; i < panel.getModel().getRowCount(); ++i) {
            if (panel.getModel().get(i).getOriginalIndex() == -1) {
                newFeature.setAttribute(i, (Object)(panel.getModel().get(i).getType() == AttributeType.GEOMETRY ? oldFeature.getGeometry() : null));
                continue;
            }
            newFeature.setAttribute(i, this.convert(oldFeature.getAttribute(panel.getModel().get(i).getOriginalIndex()), oldFeature.getSchema().getAttributeType(panel.getModel().get(i).getOriginalIndex()), newFeature.getSchema().getAttributeType(i), panel.getModel().get(i).getName(), panel.isForcingInvalidConversionsToNull()));
        }
        return newFeature;
    }

    private Feature convert(Feature oldFeature, Map<String, Attribute> schemaMapping, FeatureSchema newSchema, boolean isForcingInvalidConversionsToNull) throws ConversionException {
        BasicFeature newFeature = new BasicFeature(newSchema);
        for (String name : schemaMapping.keySet()) {
            if (schemaMapping.get(name).getOldIndex() == -1) {
                newFeature.setAttribute(name, (Object)(newSchema.getAttributeType(name) == AttributeType.GEOMETRY ? oldFeature.getGeometry() : null));
                continue;
            }
            newFeature.setAttribute(name, this.convert(oldFeature.getAttribute(schemaMapping.get(name).getOldIndex()), oldFeature.getSchema().getAttributeType(schemaMapping.get(name).getOldIndex()), newFeature.getSchema().getAttributeType(name), name, isForcingInvalidConversionsToNull));
        }
        return newFeature;
    }

    private String limitLength(Object obj) {
        return obj == null ? null : this.limitLength(obj.toString());
    }

    private String limitLength(String s) {
        return StringUtil.limitLength(s, 30);
    }

    public Object convert(Object from, AttributeType fromType, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (fromType == AttributeType.STRING) {
            return this.convert((String)from, toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (fromType == AttributeType.GEOMETRY) {
            return this.convert((Geometry)from, toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (fromType == AttributeType.BOOLEAN) {
            return this.convert((Boolean)from, toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (fromType == AttributeType.INTEGER) {
            return this.convert((Integer)from, toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (fromType == AttributeType.LONG) {
            return this.convert((Long)from, toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (fromType == AttributeType.DOUBLE) {
            return this.convert((Double)from, toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (fromType == AttributeType.DATE) {
            return this.convert((Date)from, toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (fromType == AttributeType.OBJECT) {
            return this.convert(from, toType, attributeName, forcingInvalidConversionsToNull);
        }
        throw new ConversionException("Unknown type: " + fromType);
    }

    private ConversionException conversionException(String type, Object obj, String name) {
        return new ConversionException(I18N.getInstance().get("ui.plugin.ViewSchemaPlugIn.cannot-convert-to-" + type) + " \"" + this.limitLength(obj) + "\" (" + name + ")");
    }

    public Object convert(String from, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (from == null) {
            if (toType == AttributeType.GEOMETRY && forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            if (toType == AttributeType.GEOMETRY) {
                throw this.conversionException("geometry", from, attributeName);
            }
            return null;
        }
        if (toType == AttributeType.STRING) {
            return from;
        }
        if (toType == AttributeType.GEOMETRY) {
            try {
                return this.wktReader.read(from);
            }
            catch (org.locationtech.jts.io.ParseException e) {
                if (forcingInvalidConversionsToNull) {
                    return this.factory.createPoint((Coordinate)null);
                }
                throw this.conversionException("geometry", from, attributeName);
            }
        }
        if (toType == AttributeType.BOOLEAN) {
            if (this.FALSE_PATTERN.matcher(from).matches()) {
                return Boolean.FALSE;
            }
            if (this.TRUE_PATTERN.matcher(from).matches()) {
                return Boolean.TRUE;
            }
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("boolean", from, attributeName);
        }
        if (toType == AttributeType.INTEGER) {
            try {
                return Integer.parseInt(from.replaceAll("^0*([^0])", "$1"));
            }
            catch (NumberFormatException e) {
                if (forcingInvalidConversionsToNull) {
                    return null;
                }
                throw this.conversionException("integer", from, attributeName);
            }
        }
        if (toType == AttributeType.LONG) {
            try {
                return Long.parseLong(from.replaceAll("^0*([^0])]", "$1"));
            }
            catch (NumberFormatException e) {
                if (forcingInvalidConversionsToNull) {
                    return null;
                }
                throw this.conversionException("long", from, attributeName);
            }
        }
        if (toType == AttributeType.DOUBLE) {
            try {
                return Double.parseDouble(from);
            }
            catch (NumberFormatException e) {
                if (forcingInvalidConversionsToNull) {
                    return null;
                }
                throw this.conversionException("double", from, attributeName);
            }
        }
        if (toType == AttributeType.DATE) {
            try {
                return this.fdp.parse(from, false);
            }
            catch (ParseException e) {
                if (forcingInvalidConversionsToNull) {
                    return null;
                }
                throw this.conversionException("date", from, attributeName);
            }
        }
        if (toType == AttributeType.OBJECT) {
            return from;
        }
        throw new ConversionException("Unknown type: " + toType);
    }

    public Object convert(Geometry from, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (from == null) {
            if (toType == AttributeType.GEOMETRY && forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            if (toType == AttributeType.GEOMETRY) {
                throw this.conversionException("geometry", from, attributeName);
            }
            return null;
        }
        if (toType == AttributeType.STRING) {
            return from.toText();
        }
        if (toType == AttributeType.GEOMETRY) {
            return from;
        }
        if (toType == AttributeType.BOOLEAN) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("boolean", from, attributeName);
        }
        if (toType == AttributeType.INTEGER) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("integer", from, attributeName);
        }
        if (toType == AttributeType.LONG) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("long", from, attributeName);
        }
        if (toType == AttributeType.DOUBLE) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("double", from, attributeName);
        }
        if (toType == AttributeType.DATE) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("date", from, attributeName);
        }
        if (toType == AttributeType.OBJECT) {
            return from;
        }
        throw new ConversionException("Unknown type: " + toType);
    }

    public Object convert(Boolean from, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (from == null) {
            if (toType == AttributeType.GEOMETRY && forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            if (toType == AttributeType.GEOMETRY) {
                throw this.conversionException("geometry", from, attributeName);
            }
            return null;
        }
        if (toType == AttributeType.STRING) {
            return from.toString();
        }
        if (toType == AttributeType.GEOMETRY) {
            if (forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            throw this.conversionException("geometry", from, attributeName);
        }
        if (toType == AttributeType.BOOLEAN) {
            return from;
        }
        if (toType == AttributeType.INTEGER) {
            return from != false ? 1 : 0;
        }
        if (toType == AttributeType.LONG) {
            return from != false ? 1L : 0L;
        }
        if (toType == AttributeType.DOUBLE) {
            return from != false ? 1.0 : 0.0;
        }
        if (toType == AttributeType.DATE) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("date", from, attributeName);
        }
        if (toType == AttributeType.OBJECT) {
            return from;
        }
        throw new ConversionException("Unknown type: " + toType);
    }

    public Object convert(Integer from, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (from == null) {
            if (toType == AttributeType.GEOMETRY && forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            if (toType == AttributeType.GEOMETRY) {
                throw this.conversionException("geometry", from, attributeName);
            }
            return null;
        }
        if (toType == AttributeType.STRING) {
            return from.toString();
        }
        if (toType == AttributeType.GEOMETRY) {
            if (forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            throw this.conversionException("geometry", from, attributeName);
        }
        if (toType == AttributeType.BOOLEAN) {
            return from == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (toType == AttributeType.INTEGER) {
            return from;
        }
        if (toType == AttributeType.LONG) {
            return from.longValue();
        }
        if (toType == AttributeType.DOUBLE) {
            return from.doubleValue();
        }
        if (toType == AttributeType.DATE) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("date", from, attributeName);
        }
        if (toType == AttributeType.OBJECT) {
            return from;
        }
        throw new ConversionException("Unknown type: " + toType);
    }

    public Object convert(Long from, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (from == null) {
            if (toType == AttributeType.GEOMETRY && forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            if (toType == AttributeType.GEOMETRY) {
                throw this.conversionException("geometry", from, attributeName);
            }
            return null;
        }
        if (toType == AttributeType.STRING) {
            return from.toString();
        }
        if (toType == AttributeType.GEOMETRY) {
            if (forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            throw this.conversionException("geometry", from, attributeName);
        }
        if (toType == AttributeType.BOOLEAN) {
            return from == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        if (toType == AttributeType.INTEGER) {
            if (from >= Integer.MIN_VALUE && from <= Integer.MAX_VALUE) {
                return from.intValue();
            }
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("integer", from, attributeName);
        }
        if (toType == AttributeType.LONG) {
            return from;
        }
        if (toType == AttributeType.DOUBLE) {
            return from.doubleValue();
        }
        if (toType == AttributeType.DATE) {
            return new Date(from);
        }
        if (toType == AttributeType.OBJECT) {
            return from;
        }
        throw new ConversionException("Unknown type: " + toType);
    }

    public Object convert(Double from, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (from == null) {
            if (toType == AttributeType.GEOMETRY && forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            if (toType == AttributeType.GEOMETRY) {
                throw this.conversionException("geometry", from, attributeName);
            }
            return null;
        }
        if (toType == AttributeType.STRING) {
            return from.toString();
        }
        if (toType == AttributeType.GEOMETRY) {
            if (forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            throw this.conversionException("geometry", from, attributeName);
        }
        if (toType == AttributeType.BOOLEAN) {
            return from == 0.0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (toType == AttributeType.INTEGER) {
            if (from >= -2.147483648E9 && from <= 2.147483647E9) {
                return from.intValue();
            }
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("integer", from, attributeName);
        }
        if (toType == AttributeType.LONG) {
            if (from >= -9.223372036854776E18 && from <= 9.223372036854776E18) {
                return from.longValue();
            }
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("long", from, attributeName);
        }
        if (toType == AttributeType.DOUBLE) {
            return from;
        }
        if (toType == AttributeType.DATE) {
            if (from < 9.223372036854776E18 && from > 0.0) {
                return new Date(from.longValue());
            }
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("date", from, attributeName);
        }
        if (toType == AttributeType.OBJECT) {
            return from;
        }
        throw new ConversionException("Unknown type: " + toType);
    }

    public Object convert(Date from, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (from == null) {
            if (toType == AttributeType.GEOMETRY && forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            if (toType == AttributeType.GEOMETRY) {
                throw this.conversionException("geometry", from, attributeName);
            }
            return null;
        }
        if (toType == AttributeType.STRING) {
            return this.dateFormatter.format(from);
        }
        if (toType == AttributeType.GEOMETRY) {
            if (forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            throw this.conversionException("geometry", from, attributeName);
        }
        if (toType == AttributeType.BOOLEAN) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("boolean", from, attributeName);
        }
        if (toType == AttributeType.INTEGER) {
            if (forcingInvalidConversionsToNull) {
                return null;
            }
            throw this.conversionException("integer", from, attributeName);
        }
        if (toType == AttributeType.LONG) {
            return from.getTime();
        }
        if (toType == AttributeType.DOUBLE) {
            return (double)from.getTime();
        }
        if (toType == AttributeType.DATE) {
            return from;
        }
        if (toType == AttributeType.OBJECT) {
            return from;
        }
        throw new ConversionException("Unknown type: " + toType);
    }

    public Object convert(Object from, AttributeType toType, String attributeName, boolean forcingInvalidConversionsToNull) throws ConversionException {
        if (from == null) {
            if (toType == AttributeType.GEOMETRY && forcingInvalidConversionsToNull) {
                return this.factory.createPoint((Coordinate)null);
            }
            if (toType == AttributeType.GEOMETRY) {
                throw this.conversionException("geometry", from, attributeName);
            }
            return null;
        }
        if (toType == AttributeType.STRING) {
            return from.toString();
        }
        if (toType == AttributeType.GEOMETRY) {
            return this.convert(from.toString(), toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (toType == AttributeType.BOOLEAN) {
            return this.convert(from.toString(), toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (toType == AttributeType.INTEGER) {
            return this.convert(from.toString(), toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (toType == AttributeType.LONG) {
            return this.convert(from.toString(), toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (toType == AttributeType.DOUBLE) {
            return this.convert(from.toString(), toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (toType == AttributeType.DATE) {
            return this.convert(from.toString(), toType, attributeName, forcingInvalidConversionsToNull);
        }
        if (toType == AttributeType.OBJECT) {
            return from;
        }
        throw new ConversionException("Unknown type: " + toType);
    }

    private void commitEditsInProgress(SchemaPanel panel) {
        if (panel.getTable().getEditingRow() != -1) {
            panel.getTable().getCellEditor(panel.getTable().getEditingRow(), panel.getTable().getEditingColumn()).stopCellEditing();
        }
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (!context.getWorkbenchContext().getBlackboard().get("MacroRunning", false)) {
            if (this.frame(context) == null) {
                this.addParameter(P_LAYER_NAME, context.getSelectedLayer(0).getName());
                context.getSelectedLayer(0).getBlackboard().put(KEY, new EditSchemaFrame(context.getWorkbenchFrame(), context.getSelectedLayer(0), this.editingPlugIn));
            }
            this.frame(context).surface();
            if (context.getWorkbenchContext().getBlackboard().get("MacroStarted", false)) {
                ((Macro)context.getWorkbenchContext().getBlackboard().get("Macro")).addProcess(this);
            }
        } else {
            Layer layer;
            Layer[] selectedLayers = context.getLayerNamePanel().getSelectedLayers();
            if (selectedLayers.length == 1) {
                layer = selectedLayers[0];
            } else if (context.getLayerManager().getLayer((String)this.getParameter(P_LAYER_NAME)) != null) {
                layer = context.getLayerManager().getLayer((String)this.getParameter(P_LAYER_NAME));
            } else {
                return false;
            }
            this.applyChanges(layer, (Map)this.getParameter(P_SCHEMA_MAPPING), this.getBooleanParam(P_FORCE_INVALID_CONVERSIONS_TO_NULL));
        }
        return true;
    }

    private EditSchemaFrame frame(PlugInContext context) {
        return (EditSchemaFrame)context.getSelectedLayer(0).getBlackboard().get(KEY);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public static class Attribute {
        AttributeType type;
        boolean readOnly;
        boolean primaryKey;
        Operation operation;
        int oldIndex;

        public void setType(AttributeType type) {
            this.type = type;
        }

        public AttributeType getType() {
            return this.type;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setOldIndex(int oldIndex) {
            this.oldIndex = oldIndex;
        }

        public int getOldIndex() {
            return this.oldIndex;
        }
    }

    public static class ToNewSchema {
        public ToNewSchema(SchemaPanel panel) {
        }
    }

    private class EditSchemaFrame
    extends JInternalFrame
    implements LayerNamePanelProxy,
    LayerNamePanel,
    LayerManagerProxy {
        private LayerManager layerManager;
        private Layer layer;
        private WorkbenchFrame workbenchFrame;

        public EditSchemaFrame(final WorkbenchFrame workbenchFrame, final Layer layer, EditingPlugIn editingPlugIn) {
            this.layer = layer;
            this.workbenchFrame = workbenchFrame;
            layer.getBlackboard().put(KEY, this);
            this.layerManager = layer.getLayerManager();
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    layer.getBlackboard().put(KEY, null);
                }
            });
            final SchemaPanel panel = new SchemaPanel(layer, editingPlugIn, workbenchFrame.getContext());
            this.setResizable(true);
            this.setClosable(true);
            this.setMaximizable(true);
            this.setIconifiable(true);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)panel, "Center");
            this.setSize(500, 300);
            this.updateTitle(layer);
            layer.getLayerManager().addLayerListener(new LayerListener(){

                @Override
                public void categoryChanged(CategoryEvent e) {
                }

                @Override
                public void featuresChanged(FeatureEvent e) {
                }

                @Override
                public void layerChanged(LayerEvent e) {
                    EditSchemaFrame.this.updateTitle(layer);
                }
            });
            this.setDefaultCloseOperation(0);
            panel.add(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ViewSchemaPlugIn.this.commitEditsInProgress(panel);
                        ViewSchemaPlugIn.this.applyChanges(layer, panel, workbenchFrame);
                    }
                    catch (Exception x) {
                        workbenchFrame.handleThrowable(x);
                    }
                }
            });
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    ViewSchemaPlugIn.this.commitEditsInProgress(panel);
                    if (!layer.isEditable() || !panel.isModified()) {
                        EditSchemaFrame.this.dispose();
                        return;
                    }
                    switch (JOptionPane.showConfirmDialog(EditSchemaFrame.this, I18N.getInstance().get("ui.plugin.ViewSchemaPlugIn.apply-changes-to-schema"), "JUMP", 1, 2)) {
                        case 0: {
                            try {
                                ViewSchemaPlugIn.this.applyChanges(layer, panel, workbenchFrame);
                            }
                            catch (Exception x) {
                                workbenchFrame.handleThrowable(x);
                                return;
                            }
                            EditSchemaFrame.this.dispose();
                            return;
                        }
                        case 1: {
                            EditSchemaFrame.this.dispose();
                            return;
                        }
                        case 2: {
                            return;
                        }
                    }
                    Assert.shouldNeverReachHere();
                }
            });
        }

        private void updateTitle(Layer layer) {
            this.setTitle((layer.isEditable() ? I18N.getInstance().get("ui.plugin.ViewSchemaPlugIn.edit") : I18N.getInstance().get("ui.plugin.ViewSchemaPlugIn.view")) + " " + I18N.getInstance().get("ui.plugin.ViewSchemaPlugIn.schema") + ": " + layer.getName());
        }

        @Override
        public LayerManager getLayerManager() {
            return this.layerManager;
        }

        @Override
        public Layer chooseEditableLayer() {
            return TreeLayerNamePanel.chooseEditableLayer(this);
        }

        public void surface() {
            if (!this.workbenchFrame.hasInternalFrame(this)) {
                this.workbenchFrame.addInternalFrame(this, false, true);
            }
            this.workbenchFrame.activateFrame(this);
            this.moveToFront();
        }

        @Override
        public LayerNamePanel getLayerNamePanel() {
            return this;
        }

        public Collection getSelectedCategories() {
            return new ArrayList();
        }

        @Override
        public Layer[] getSelectedLayers() {
            return new Layer[]{this.layer};
        }

        public Collection selectedNodes(Class c) {
            if (!Layerable.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            return Arrays.asList(this.getSelectedLayers());
        }

        @Override
        public void addListener(LayerNamePanelListener listener) {
        }

        @Override
        public void removeListener(LayerNamePanelListener listener) {
        }
    }

    private static class ConversionException
    extends Exception {
        public ConversionException(String message) {
            super(message);
        }
    }
}

