/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.ExportImagePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.plugin.file.LayerPrinter2;
import org.openjump.core.ui.plugin.file.WorldFileWriter;

public class SaveImageAsPlugIn
extends ExportImagePlugIn {
    private List<MyFileFilter> myFileFilters = Arrays.asList(this.createFileFilter("PNG - Portable Network Graphics", "png", 2), this.createFileFilter("JPEG - Joint Photographic Experts Group", "jpg", 1));
    private JFileChooser fileChooser = null;
    private WorkbenchContext workbenchContext;
    private JCheckBox worldFileCheckBox = null;
    private JLabel pixelSizeLabel = new JLabel(I18N.getInstance().get("ui.plugin.SaveImageAsPlugIn.width-in-pixels"));
    private final ImageIcon icon = IconLoader.icon("Box.gif");
    private Geometry fence = null;
    private ValidatingTextField pixelSizeField = new ValidatingTextField("9999", 5, new ValidatingTextField.Validator(){

        @Override
        public boolean isValid(String text) {
            if (text.length() == 0) {
                return true;
            }
            try {
                int i = Integer.parseInt(text);
                long maxMemory = Runtime.getRuntime().maxMemory();
                int maxSize = 5 * (int)Math.sqrt(maxMemory / 1000L);
                return i <= maxSize;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    });
    private static final String FORMAT_KEY = "FORMAT";
    private static final String LAST_FILENAME_KEY = "LAST FILENAME";

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new GUIUtil.FileChooserWithOverwritePrompting(){

                @Override
                public File getSelectedFile() {
                    File file = super.getSelectedFile();
                    return file == null ? null : new File(SaveImageAsPlugIn.this.addExtension(file.getPath(), ((MyFileFilter)this.getFileFilter()).getFormat()));
                }
            };
            this.fileChooser.setDialogTitle(I18N.getInstance().get("ui.plugin.SaveImageAsPlugIn.save-image"));
            GUIUtil.removeChoosableFileFilters(this.fileChooser);
            HashMap<String, MyFileFilter> formatToFileFilterMap = new HashMap<String, MyFileFilter>();
            for (MyFileFilter fileFilter : this.myFileFilters) {
                this.fileChooser.addChoosableFileFilter(fileFilter);
                formatToFileFilterMap.put(fileFilter.getFormat(), fileFilter);
            }
            String lastFilename = (String)PersistentBlackboardPlugIn.get(this.workbenchContext).get(LAST_FILENAME_KEY);
            if (lastFilename != null) {
                this.fileChooser.setSelectedFile(new File(lastFilename));
            }
            this.fileChooser.setFileFilter((FileFilter)formatToFileFilterMap.get(PersistentBlackboardPlugIn.get(this.workbenchContext).get(FORMAT_KEY, "png")));
            Box box = new Box(1);
            JPanel jPanelSize = new JPanel(new FlowLayout(0));
            JPanel jPanelWF = new JPanel(new FlowLayout(0));
            this.worldFileCheckBox = new JCheckBox();
            this.worldFileCheckBox.setText(I18N.getInstance().get("ui.plugin.SaveImageAsPlugIn.write-world-file"));
            if (this.fence != null) {
                JLabel fenceIcon = new JLabel(this.icon);
                jPanelSize.add(fenceIcon);
            }
            jPanelSize.add(this.pixelSizeLabel);
            jPanelSize.add(this.pixelSizeField);
            jPanelWF.add(this.worldFileCheckBox);
            box.add(jPanelSize);
            box.add(jPanelWF);
            box.add(Box.createRigidArea(new Dimension(5, 180)));
            this.fileChooser.setAccessory(box);
        }
        return this.fileChooser;
    }

    private int getPixelSize() {
        String text = this.pixelSizeField.getText();
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return 800;
        }
    }

    private MyFileFilter createFileFilter(String description, String format, int bufferedmageType) {
        return new MyFileFilter(description, format);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.FILE, MenuNames.FILE_SAVEVIEW}, I18N.getInstance().get(this.getClass().getName()) + "...", false, null, SaveImageAsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        BufferedImage image;
        boolean fenceFound;
        this.workbenchContext = context.getWorkbenchContext();
        this.fence = context.getLayerViewPanel().getFence();
        boolean bl = fenceFound = this.fence != null;
        if (fenceFound) {
            this.pixelSizeField.setText("800");
        } else {
            this.pixelSizeField.setText(context.getLayerViewPanel().getWidth() + "");
        }
        if (0 != this.getFileChooser().showSaveDialog(context.getWorkbenchFrame())) {
            this.fileChooser = null;
            return false;
        }
        MyFileFilter fileFilter = (MyFileFilter)this.getFileChooser().getFileFilter();
        LayerViewPanel viewPanel = context.getLayerViewPanel();
        if (!fenceFound && this.getPixelSize() == context.getLayerViewPanel().getWidth()) {
            image = this.image(viewPanel);
        } else {
            Envelope envelope;
            LayerPrinter2 layerPrinter = new LayerPrinter2();
            if (fenceFound) {
                envelope = this.fence.getEnvelopeInternal();
                String fenceLayerName = I18N.getInstance().get("model.FenceLayerFinder.fence");
                Layer fenceLayer = this.workbenchContext.getLayerableNamePanel().getLayerManager().getLayer(fenceLayerName);
                fenceLayer.setVisible(false);
            } else {
                envelope = this.workbenchContext.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
            }
            image = layerPrinter.print(context.getLayerManager().getLayerables(Layerable.class), envelope, this.getPixelSize());
            viewPanel = layerPrinter.getLayerViewPanel();
        }
        String filename = this.addExtension(this.getFileChooser().getSelectedFile().getPath(), fileFilter.getFormat());
        File imageFile = new File(filename);
        this.save(image, fileFilter.getFormat(), imageFile);
        PersistentBlackboardPlugIn.get(this.workbenchContext).put(FORMAT_KEY, fileFilter.getFormat());
        PersistentBlackboardPlugIn.get(this.workbenchContext).put(LAST_FILENAME_KEY, filename);
        if (this.worldFileCheckBox != null && this.worldFileCheckBox.isSelected()) {
            WorldFileWriter.writeWorldFile(imageFile, viewPanel);
        }
        this.fileChooser = null;
        return true;
    }

    private void save(RenderedImage image, String format, File file) throws IOException {
        boolean writerFound = ImageIO.write(image, format, file);
        Assert.isTrue((boolean)writerFound, (String)(I18N.getInstance().get("ui.plugin.SaveImageAsPlugIn.cannot-find-writer-for-image-format") + " '" + format + "'"));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    private String addExtension(String path, String extension) {
        if (path.toUpperCase().endsWith(extension.toUpperCase())) {
            return path;
        }
        if (path.endsWith(".")) {
            return path + extension;
        }
        return path + "." + extension;
    }

    private static class MyFileFilter
    extends FileFilter {
        private FileFilter fileFilter;
        private String format;

        MyFileFilter(String description, String format) {
            this.fileFilter = GUIUtil.createFileFilter(description, new String[]{format});
            this.format = format;
        }

        @Override
        public boolean accept(File f) {
            return this.fileFilter.accept(f);
        }

        @Override
        public String getDescription() {
            return this.fileFilter.getDescription();
        }

        public String getFormat() {
            return this.format;
        }
    }
}

