/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.images;

import com.vividsolutions.jump.workbench.Logger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class IconLoader {
    private static final HashMap<String, ImageIcon> iconCache = new HashMap();
    private static final ImageIcon DEFAULT_UNKNOWN_ICON = new ImageIcon(IconLoader.class.getResource("saig/default_icon.png"));

    public static ImageIcon icon(String filename) {
        return IconLoader.getIcon(filename);
    }

    public static BufferedImage image(String filename) {
        ImageIcon icon = IconLoader.getIcon(filename);
        Image image = icon.getImage();
        BufferedImage bufImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D bGr = bufImg.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bufImg;
    }

    protected static ImageIcon getIcon(String filename) {
        filename = IconLoader.resolveFile(filename);
        return IconLoader.getIcon(IconLoader.class, filename);
    }

    protected static ImageIcon getIcon(Class<?> clazz, String filename) {
        URL url = clazz.getResource(filename);
        if (url == null) {
            Logger.error("Couldn't find '" + filename + "' via resource loading. Returning dummy default icon for now.");
            return DEFAULT_UNKNOWN_ICON;
        }
        return IconLoader.getIcon(url);
    }

    protected static ImageIcon getIcon(URL url) {
        ImageIcon icon;
        if (url == null) {
            throw new InvalidParameterException("parameter url must not be null.");
        }
        String key = url.toExternalForm();
        try {
            icon = iconCache.get(key);
            if (icon != null) {
                return icon;
            }
            icon = new ImageIcon(url);
            iconCache.put(key, icon);
        }
        catch (Exception e) {
            icon = DEFAULT_UNKNOWN_ICON;
            Logger.error("Error loading '" + key + "'. Using dummy default icon for now.", e);
        }
        return icon;
    }

    protected static String resolveFile(String filename) {
        for (String path : new String[]{"", "famfam/", "fugue/", "saig/"}) {
            if (IconLoader.class.getResource(path + filename) == null) continue;
            return path + filename;
        }
        return filename;
    }
}

