/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.util.CoordinateArrays;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Color;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Assert;

public class InsertVertexTool
extends NClickTool {
    private static final int PIXEL_RANGE = 5;
    private final EnableCheckFactory checkFactory;

    public InsertVertexTool(WorkbenchContext context) {
        super(context, 1);
        this.checkFactory = EnableCheckFactory.getInstance(context);
    }

    private double modelRange() {
        return 5.0 / this.getPanel().getViewport().getScale();
    }

    private Collection<Feature> featuresInRange(Coordinate modelClickCoordinate, Layer layer) {
        Point modelClickPoint = new GeometryFactory().createPoint(modelClickCoordinate);
        Collection<Feature> featuresWithSelectedItems = this.getPanel().getSelectionManager().getFeaturesWithSelectedItems(layer);
        if (featuresWithSelectedItems.isEmpty()) {
            return new ArrayList<Feature>();
        }
        ArrayList<Feature> featuresInRange = new ArrayList<Feature>();
        for (Feature candidate : featuresWithSelectedItems) {
            if (!(modelClickPoint.distance(candidate.getGeometry()) <= this.modelRange())) continue;
            featuresInRange.add(candidate);
        }
        return featuresInRange;
    }

    private Coordinate modelClickCoordinate() {
        return this.getCoordinates().get(0);
    }

    private LineSegment segmentInRange(Geometry geometry, Coordinate target) {
        LineSegment closest = null;
        List<Coordinate[]> coordArrays = CoordinateArrays.toCoordinateArrays(geometry, false);
        for (Coordinate[] coordinates : coordArrays) {
            for (int j = 1; j < coordinates.length; ++j) {
                LineSegment candidate = new LineSegment(coordinates[j - 1], coordinates[j]);
                if (candidate.distance(target) > this.modelRange() || closest != null && !(candidate.distance(target) < closest.distance(target))) continue;
                closest = candidate;
            }
        }
        return closest;
    }

    private Coordinate newVertex(LineSegment segment, Coordinate target) {
        Coordinate closestPoint = segment.closestPoint(target);
        if (!closestPoint.equals((Object)segment.p0) && !closestPoint.equals((Object)segment.p1)) {
            if (Double.isNaN(segment.p0.z) || Double.isNaN(segment.p1.z)) {
                return closestPoint;
            }
            closestPoint.z = (segment.p0.z + segment.p1.z) / 2.0;
        }
        double threshold = 6.0 / this.getPanel().getViewport().getScale();
        if (segment.getLength() < threshold) {
            return CoordUtil.average(segment.p0, segment.p1);
        }
        double offset = 3.0 / this.getPanel().getViewport().getScale();
        Coordinate unitVector = closestPoint.equals((Object)segment.p0) ? CoordUtil.divide(CoordUtil.subtract(segment.p1, segment.p0), segment.getLength()) : CoordUtil.divide(CoordUtil.subtract(segment.p0, segment.p1), segment.getLength());
        return CoordUtil.add(closestPoint, CoordUtil.multiply(offset, unitVector));
    }

    private SegmentContext findSegment(Layer layer, Collection<Feature> features, Coordinate target) {
        Assert.isTrue((boolean)layer.isEditable());
        for (Feature feature : features) {
            for (Geometry selectedItem : this.getPanel().getSelectionManager().getSelectedItems(layer, feature)) {
                LineSegment segment = this.segmentInRange(selectedItem, target);
                if (segment == null) continue;
                return new SegmentContext(layer, feature, segment);
            }
        }
        return null;
    }

    private SegmentContext findSegment(Map<Layer, Collection<Feature>> layerToFeaturesMap, Coordinate target) {
        for (Layer layer : layerToFeaturesMap.keySet()) {
            Collection<Feature> features;
            SegmentContext segmentContext = this.findSegment(layer, features = layerToFeaturesMap.get(layer), target);
            if (segmentContext == null) continue;
            return segmentContext;
        }
        return null;
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        if (!this.check(this.checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        Map<Layer, Collection<Feature>> layerToFeaturesInRangeMap = this.layerToFeaturesInRangeMap();
        if (layerToFeaturesInRangeMap.isEmpty()) {
            this.getPanel().getContext().warnUser(I18N.getInstance().get("ui.cursortool.editing.InsertVertexTool.no-selected-editable-items-here"));
            return;
        }
        SegmentContext segment = this.findSegment(layerToFeaturesInRangeMap, this.modelClickCoordinate());
        if (segment == null) {
            this.getPanel().getContext().warnUser(I18N.getInstance().get("ui.cursortool.editing.InsertVertexTool.no-selected-line-segments-here"));
            return;
        }
        Coordinate newVertex = this.newVertex(segment.getSegment(), this.modelClickCoordinate());
        Geometry newGeometry = new GeometryEditor().insertVertex(segment.getFeature().getGeometry(), segment.getSegment().p0, segment.getSegment().p1, newVertex);
        this.gestureFinished(newGeometry, newVertex, segment);
    }

    protected void gestureFinished(Geometry newGeometry, final Coordinate newVertex, SegmentContext segment) {
        EditTransaction transaction = new EditTransaction(Collections.singletonList(segment.getFeature()), this.getName(), segment.getLayer(), this.isRollingBackInvalidEdits(), false, this.getPanel());
        transaction.setGeometry(segment.getFeature(), newGeometry);
        transaction.commit(new EditTransaction.SuccessAction(){

            @Override
            public void run() {
                try {
                    Animations.drawExpandingRing(InsertVertexTool.this.getPanel().getViewport().toViewPoint(newVertex), false, Color.green, InsertVertexTool.this.getPanel(), null);
                }
                catch (Throwable t) {
                    InsertVertexTool.this.getPanel().getContext().warnUser(t.toString());
                }
            }
        });
    }

    private Map<Layer, Collection<Feature>> layerToFeaturesInRangeMap() {
        HashMap<Layer, Collection<Feature>> layerToFeaturesInRangeMap = new HashMap<Layer, Collection<Feature>>();
        for (Layer editableLayer : this.getPanel().getLayerManager().getEditableLayers()) {
            Collection<Feature> featuresInRange = this.featuresInRange(this.modelClickCoordinate(), editableLayer);
            if (featuresInRange.isEmpty()) continue;
            layerToFeaturesInRangeMap.put(editableLayer, featuresInRange);
        }
        return layerToFeaturesInRangeMap;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("InsertVertex.gif");
    }

    @Override
    public Cursor getCursor() {
        return InsertVertexTool.createCursor(IconLoader.icon("PlusCursor.gif").getImage());
    }

    protected static class SegmentContext {
        private final LineSegment segment;
        private final Feature feature;
        private final Layer layer;

        public SegmentContext(Layer layer, Feature feature, LineSegment segment) {
            this.layer = layer;
            this.feature = feature;
            this.segment = segment;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public LineSegment getSegment() {
            return this.segment;
        }
    }
}

