/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.Angle;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

public class CoordinateListMetrics {
    String sArea = I18N.getInstance().get("ui.cursortool.CoordinateListMetrics.Area");
    String sAzimuth = I18N.getInstance().get("ui.cursortool.CoordinateListMetrics.Azimuth");
    String sAngle = I18N.getInstance().get("ui.cursortool.CoordinateListMetrics.Angle");
    String sDistance = I18N.getInstance().get("ui.cursortool.CoordinateListMetrics.Distance");

    public void displayMetrics(List coordinates, LayerViewPanel panel) {
        this.displayMetrics(coordinates, panel, false);
    }

    public void displayMetrics(List coordinates, LayerViewPanel panel, boolean closedDistance) {
        panel.getContext().setStatusMessage(this.getMetricsString(coordinates, panel, closedDistance));
    }

    public String getMetricsString(List coordinates, LayerViewPanel panel) {
        return this.getMetricsString(coordinates, panel, false);
    }

    public String getMetricsString(List coordinates, LayerViewPanel panel, boolean closedDistance) {
        double dist = CoordinateListMetrics.distance(coordinates, closedDistance);
        String dispStr = this.sDistance + ": " + panel.format(dist);
        double distlast = CoordinateListMetrics.distancelast(coordinates, closedDistance);
        dispStr = dispStr + " (" + panel.format(distlast) + ")";
        double angle = CoordinateListMetrics.angle(coordinates);
        dispStr = dispStr + "   " + this.sAngle + ": " + panel.format(angle);
        double azimuth = this.azimuth(coordinates);
        dispStr = dispStr + "   " + this.sAzimuth + ": " + panel.format(azimuth);
        if (coordinates.size() > 2) {
            double area = CoordinateListMetrics.area(coordinates);
            dispStr = dispStr + "   " + this.sArea + ": " + panel.format(area);
        }
        return dispStr;
    }

    public static double distance(List coordinates) {
        return CoordinateListMetrics.distance(coordinates, false);
    }

    public static double distance(List coordinates, boolean closedDistance) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += ((Coordinate)coordinates.get(i - 1)).distance((Coordinate)coordinates.get(i));
        }
        if (coordinates.size() > 2 && closedDistance) {
            distance += ((Coordinate)coordinates.get(coordinates.size() - 1)).distance((Coordinate)coordinates.get(0));
        }
        return distance;
    }

    public static double angle(List coordinates) {
        int size = coordinates.size();
        if (size <= 1) {
            return 0.0;
        }
        Coordinate p1 = (Coordinate)coordinates.get(size - 2);
        Coordinate p2 = (Coordinate)coordinates.get(size - 1);
        Coordinate p0 = null;
        p0 = size > 2 ? (Coordinate)coordinates.get(size - 3) : new Coordinate(p1.x + 1.0, p1.y);
        double angRad = Angle.angleBetween(p1, p0, p2);
        return Math.toDegrees(angRad);
    }

    private static double area(List coordinates) {
        if (coordinates.size() < 3) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < coordinates.size(); ++i) {
            Coordinate b = (Coordinate)coordinates.get(i);
            int nexti = i + 1;
            if (nexti > coordinates.size() - 1) {
                nexti = 0;
            }
            Coordinate c = (Coordinate)coordinates.get(nexti);
            sum += (b.x + c.x) * (c.y - b.y);
        }
        double signedArea = -sum / 2.0;
        if (signedArea >= 0.0) {
            return signedArea;
        }
        return -signedArea;
    }

    public static double azimuth(List coordinates, boolean closedDistance) {
        double DEG;
        int size = coordinates.size();
        if (size <= 1) {
            return 0.0;
        }
        Coordinate p1 = (Coordinate)coordinates.get(size - 2);
        Coordinate p2 = (Coordinate)coordinates.get(size - 1);
        if (size > 2) {
            // empty if block
        }
        double d = 0.0;
        LineSegment ls = new LineSegment(p1, p2);
        d = ls.angle();
        double DEG1 = DEG = 90.0 - d * 57.29577951308232;
        if (DEG < 0.0) {
            DEG1 += 360.0;
        }
        return DEG1;
    }

    public double azimuth(List coordinates) {
        return CoordinateListMetrics.azimuth(coordinates, false);
    }

    public static double distancelast(List coordinates, boolean closedDistance) {
        double distance = 0.0;
        double lastSegmentLength = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += ((Coordinate)coordinates.get(i - 1)).distance((Coordinate)coordinates.get(i));
            if (i != coordinates.size() - 1) continue;
            lastSegmentLength = ((Coordinate)coordinates.get(i - 1)).distance((Coordinate)coordinates.get(i));
        }
        return lastSegmentLength;
    }

    public double distancelast(List coordinates) {
        return CoordinateListMetrics.distancelast(coordinates, false);
    }

    public static double bearing(List coordinates, boolean closedDistance) {
        int size = coordinates.size();
        if (size <= 1) {
            return 0.0;
        }
        Coordinate p1 = (Coordinate)coordinates.get(size - 2);
        Coordinate p2 = (Coordinate)coordinates.get(size - 1);
        if (size > 2) {
            // empty if block
        }
        Coordinate r = new Coordinate(p2.x - p1.x, p2.y - p1.y);
        double rMag = Math.sqrt(r.x * r.x + r.y * r.y);
        if (rMag == 0.0) {
            return 0.0;
        }
        double rCos = r.x / rMag;
        double rAng = Math.acos(rCos);
        if (r.y < 0.0) {
            rAng = -rAng;
        }
        return rAng * 360.0 / (Math.PI * 2);
    }

    public double bearing(List coordinates) {
        return CoordinateListMetrics.distancelast(coordinates, false);
    }
}

