/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Assert;

public abstract class AbstractClickSelectedLineStringsTool
extends SpecifyFeaturesTool {
    protected static final String NO_SELECTED_LINESTRINGS_HERE_MESSAGE = "No selected LineStrings here";

    public AbstractClickSelectedLineStringsTool(WorkbenchContext context) {
        super(context);
        this.setViewClickBuffer(10);
    }

    protected void warnLayerNotEditable(Layer layer) {
        this.getWorkbench().getFrame().warnUser(layer.getName() + " is not editable");
    }

    @Override
    public String getName() {
        return super.getName().replaceAll("Line String", "LineString");
    }

    @Override
    protected Coordinate getModelSource() {
        return this.getModelDestination();
    }

    @Override
    protected Shape getShape(Point2D source, Point2D destination) throws Exception {
        return null;
    }

    protected Point getModelClickPoint() {
        return new GeometryFactory().createPoint(this.getModelDestination());
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.check(this.checkFactory().createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        if (!this.check(this.checkFactory().createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        Collection<Feature> nearbyLineStringFeatures = CollectionUtil.select(CollectionUtil.concatenate(this.layerToSpecifiedFeaturesMap().values()), new Block(){

            @Override
            public Object yield(Object feature) {
                return AbstractClickSelectedLineStringsTool.this.getPanel().getSelectionManager().getFeaturesWithSelectedItems().contains(feature) && ((Feature)feature).getGeometry() instanceof LineString ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (nearbyLineStringFeatures.isEmpty()) {
            this.getWorkbench().getFrame().warnUser(NO_SELECTED_LINESTRINGS_HERE_MESSAGE);
            return;
        }
        this.gestureFinished(nearbyLineStringFeatures);
    }

    private EnableCheckFactory checkFactory() {
        return EnableCheckFactory.getInstance(this.getWorkbench().getContext());
    }

    protected abstract void gestureFinished(Collection<Feature> var1) throws NoninvertibleTransformException;

    protected Layer layer(Feature feature, Map<Layer, Set<Feature>> layerToSpecifiedFeaturesMap) {
        for (Layer layer : layerToSpecifiedFeaturesMap.keySet()) {
            Set<Feature> features = layerToSpecifiedFeaturesMap.get(layer);
            if (!features.contains(feature)) continue;
            return layer;
        }
        Assert.shouldNeverReachHere();
        return null;
    }
}

