/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableChecked;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AboutDialog;
import com.vividsolutions.jump.workbench.ui.ApplicationExitHandler;
import com.vividsolutions.jump.workbench.ui.ErrorDialog;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.InternalFrameCloseHandler;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiRecursiveKeyListener;
import com.vividsolutions.jump.workbench.ui.ShortcutPluginExecuteKeyListener;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.OptionsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ViewAttributesPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.ChoosableStyle;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToCoordinatePlugIn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultDesktopManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.openjump.core.CheckOS;
import org.openjump.core.model.TaskEvent;
import org.openjump.core.model.TaskListener;
import org.openjump.core.ui.plugin.view.ZoomToScalePlugIn;
import org.openjump.core.ui.swing.DetachableInternalFrame;
import org.openjump.core.ui.util.ScreenScale;
import org.openjump.swing.factory.component.ComponentFactory;

public class WorkbenchFrame
extends JFrame
implements LayerViewPanelContext,
ViewportListener,
ErrorHandler {
    private static I18N i18n = I18N.getInstance();
    private String EXIT_OPENJUMP = I18N.getInstance().get("ui.WorkbenchFrame.exit-jump");
    private String CLOSE_PROJECT = I18N.getInstance().get("ui.WorkbenchFrame.close-task");
    private String CLOSE_PROJECT_QUESTION = I18N.getInstance().get("ui.WorkbenchFrame.do-you-want-to-close-project");
    private String SAVE_PROJECT = I18N.getInstance().get("ui.WorkbenchFrame.save-project-before-closing-openjump");
    private String PROJECT_SAVED = I18N.getInstance().get("ui.WorkbenchFrame.save-project-saved");
    public static String MEMORY_GC = I18N.getInstance().get("ui.WorkbenchFrame.started-garbage-collection");
    public static String MEMORY_TIPS = I18N.getInstance().get("ui.WorkbenchFrame.click-to-garbage-collector");
    public static String COORDINATES = I18N.getInstance().get("ui.WorkbenchFrame.coordinates");
    public static String COORDINATES_TIPS = I18N.getInstance().get("ui.WorkbenchFrame.click-to-zoom-to-coordinates");
    public static String SCALE = I18N.getInstance().get("ui.WorkbenchFrame.scale");
    public static String SCALE_TIPS = I18N.getInstance().get("ui.WorkbenchFrame.click-to-change-view-scale");
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuBar menuBar = new JMenuBar(){

        @Override
        public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager manager) {
            super.processKeyEvent(e, path, manager);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return e.getKeyCode() == 18 && e.getID() == 402;
        }
    };
    JMenu fileMenu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(MenuNames.FILE), this.menuBar);
    private TaskFrame activeTaskFrame = null;
    private JPanel statusPanel;
    private JTextArea messageText;
    private JLabel timeLabel;
    private JLabel memoryLabel;
    private JLabel scaleLabel;
    private JLabel coordinateLabel;
    private DecimalFormat scaleFormat = new DecimalFormat("#,###");
    private DecimalFormat scaleFormatSmall = new DecimalFormat("#.####");
    private String lastStatusMessage = "";
    private JSplitPane statusPanelSplitPane1;
    private JSplitPane statusPanelSplitPane2;
    private JSplitPane statusPanelSplitPane3;
    private JSplitPane statusPanelSplitPane4;
    private JSplitPane desktopStatusSplit;
    WorkbenchToolBar toolBar;
    private static Icon internalFrameDefaultIcon = null;
    private static boolean internalFrameDefaultIconSet = false;
    JMenu windowMenu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(MenuNames.WINDOW), this.menuBar);
    private DecimalFormat memoryFormat = new DecimalFormat("###,###");
    private TitledPopupMenu categoryPopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(Category.class).size() != 1 ? "(" + panel.selectedNodes(Category.class).size() + " categories selected)" : panel.selectedNodes(Category.class).iterator().next().getName());
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private JDesktopPane desktopPane = new JDesktopPane(){
        {
            this.setDesktopManager(new DefaultDesktopManager());
            this.setBackground(new Color(58, 110, 165));
        }
    };
    private int envelopeRenderingThreshold = 500;
    private HTMLFrame outputFrame = null;
    private TitledPopupMenu layerNamePopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(Layer.class).size() != 1 ? "(" + panel.selectedNodes(Layer.class).size() + " " + I18N.getInstance().get("ui.WorkbenchFrame.layers-selected") + ")" : ((Layerable)panel.selectedNodes(Layer.class).iterator().next()).getName());
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private TitledPopupMenu wmsLayerNamePopupMenu = new TitledPopupMenu(){
        {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                    this.setTitle(panel.selectedNodes(WMSLayer.class).size() != 1 ? "(" + panel.selectedNodes(WMSLayer.class).size() + " " + I18N.getInstance().get("ui.WorkbenchFrame.wms-layers-selected") + ")" : ((Layerable)panel.selectedNodes(WMSLayer.class).iterator().next()).getName());
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    };
    private LayerNamePanelListener layerNamePanelListener = new LayerNamePanelListener(){

        @Override
        public void layerSelectionChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }
    };
    private LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){
        private StringBuffer positionStatusBuf = new StringBuffer("(");

        @Override
        public void cursorPositionChanged(String x, String y) {
            this.positionStatusBuf.setLength(1);
            this.positionStatusBuf.append(x).append(" ; ").append(y).append(")");
            WorkbenchFrame.this.coordinateLabel.setText(this.positionStatusBuf.toString());
            WorkbenchFrame.this.coordinateLabel.setToolTipText("<html><body>" + GUIUtil.escapeHTML(COORDINATES + ": " + this.positionStatusBuf.toString()) + "<br><br>" + GUIUtil.escapeHTML(COORDINATES_TIPS) + "</body></html>");
        }

        @Override
        public void selectionChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }

        public void fenceChanged() {
            WorkbenchFrame.this.toolBar.updateEnabledState();
        }

        @Override
        public void painted(Graphics graphics) {
        }
    };
    private int maximumFeatureExtentForEnvelopeRenderingInPixels = 10;
    private int minimumFeatureExtentForAnyRenderingInPixels = 2;
    private int taskSequence = 1;
    private WorkbenchContext workbenchContext;
    private Set choosableStyleClasses = new HashSet();
    private ArrayList<TaskListener> taskListeners = new ArrayList();
    private ArrayList<ApplicationExitHandler> applicationExitHandlers = new ArrayList();
    private Map<Class<?>, JPopupMenu> nodeClassToLayerNamePopupMenuMap = CollectionUtil.createMap(new Object[]{Layer.class, this.layerNamePopupMenu, WMSLayer.class, this.wmsLayerNamePopupMenu, Category.class, this.categoryPopupMenu});
    private int positionIndex = -1;
    private int primaryInfoFrameIndex = -1;
    private int addedMenuItems = -1;
    private ComponentFactory<TaskFrame> taskFrameFactory;
    MultiRecursiveKeyListener easyKeyListener;
    ShortcutPluginExecuteKeyListener shortcutListener;
    Thread thread = null;
    private boolean init_message_lnf = false;
    private ArrayList lastFiveThrowableDates = new ArrayList(){

        @Override
        public boolean add(Object o) {
            if (this.size() == 5) {
                this.remove(0);
            }
            return super.add(o);
        }
    };
    private final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
    private final int defaultInitialTimeout = ToolTipManager.sharedInstance().getInitialDelay();
    private final int defaultReshowTimeout = ToolTipManager.sharedInstance().getReshowDelay();
    InternalFrameCloseHandler internalFrameCloseHandler = new DefaultInternalFrameCloser();
    public static final String MAXIMIZED_KEY = WorkbenchFrame.class.getName() + " - MAXIMIZED_KEY";
    public static final String HORIZONTAL_KEY = WorkbenchFrame.class.getName() + " - HORIZONTAL_KEY";
    public static final String VERTICAL_KEY = WorkbenchFrame.class.getName() + " - VERTICAL_KEY";
    public static final String WIDTH_KEY = WorkbenchFrame.class.getName() + " - WIDTH_KEY";
    public static final String HEIGHT_KEY = WorkbenchFrame.class.getName() + " - HEIGHT_KEY";
    public static final String STATUSPANEL_DIVIDER_LOCATION_1 = WorkbenchFrame.class.getName() + " - STATUSPANEL_DIVIDER_LOCATION_1";
    public static final String STATUSPANEL_DIVIDER_LOCATION_2 = WorkbenchFrame.class.getName() + " - STATUSPANEL_DIVIDER_LOCATION_2";
    public static final String STATUSPANEL_DIVIDER_LOCATION_3 = WorkbenchFrame.class.getName() + " - STATUSPANEL_DIVIDER_LOCATION_3";
    public static final String STATUSPANEL_DIVIDER_LOCATION_4 = WorkbenchFrame.class.getName() + " - STATUSPANEL_DIVIDER_LOCATION_4";
    public static final String DESKTOPSTATUS_DIVIDER_LOCATION = WorkbenchFrame.class.getName() + " - DESKTOPSTATUS_DIVIDER_LOCATION";

    public WorkbenchFrame(String title, WorkbenchContext workbenchContext) throws Exception {
        this.setTitle(title);
        this.workbenchContext = workbenchContext;
        JUMPWorkbench.setIcon(this);
        this.getDesktopPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (JInternalFrame iframe : WorkbenchFrame.this.getInternalFrames()) {
                    WorkbenchFrame.this.legalize(iframe);
                }
            }
        });
        this.toolBar = new WorkbenchToolBar(workbenchContext);
        this.toolBar.setTaskMonitorManager(new TaskMonitorManager());
        try {
            this.jbInit();
            this.configureStatusBarComponent(this.messageText, 90);
            this.configureStatusBarComponent(this.timeLabel, 90);
            this.configureStatusBarComponent(this.memoryLabel, 90);
            this.configureStatusBarComponent(this.scaleLabel, 90);
            this.configureStatusBarComponent(this.coordinateLabel, 90);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = WorkbenchFrame.this.getMBCommittedMemory() + " MB " + I18N.getInstance().get("ui.WorkbenchFrame.committed-memory");
                WorkbenchFrame.this.memoryLabel.setText(msg);
                WorkbenchFrame.this.memoryLabel.setToolTipText("<html><body>" + GUIUtil.escapeHTML(msg) + "<br><br>" + GUIUtil.escapeHTML(MEMORY_TIPS) + "</body></html>");
            }
        }).start();
        this.easyKeyListener = new MultiRecursiveKeyListener(this);
        this.shortcutListener = new ShortcutPluginExecuteKeyListener(workbenchContext);
        if (CheckOS.isMacOsx()) {
            try {
                new AppleHandler().register();
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.log(sw.toString());
            }
        }
        KeyEventDispatcher dispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                Component focussed = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean valid = false;
                for (Component c = focussed; !(c == null || c.equals(WorkbenchFrame.this.statusPanel) || c instanceof TreeLayerNamePanel && focussed instanceof JTextComponent); c = c.getParent()) {
                    if (c instanceof TaskFrame || c instanceof ToolboxDialog && c.equals(EditingPlugIn.getInstance().getToolbox()) || c instanceof WorkbenchFrame) {
                        valid = true;
                        break;
                    }
                    if (c instanceof Window || c instanceof JInternalFrame) break;
                }
                if (!valid) {
                    return false;
                }
                switch (e.getID()) {
                    case 401: {
                        WorkbenchFrame.this.shortcutListener.keyPressed(e);
                        break;
                    }
                    case 402: {
                        WorkbenchFrame.this.shortcutListener.keyReleased(e);
                        break;
                    }
                    case 400: {
                        WorkbenchFrame.this.shortcutListener.keyTyped(e);
                    }
                }
                return e.isConsumed();
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(dispatcher);
    }

    public void addEasyKeyListener(KeyListener l) {
        this.easyKeyListener.addKeyListener(l);
    }

    public void removeEasyKeyListener(KeyListener l) {
        this.easyKeyListener.removeKeyListener(l);
    }

    public void addEasyKeyListenerToComp(Component c) {
        this.easyKeyListener.listenTo(c);
    }

    public void removeEasyKeyListenerFromComp(Component c) {
        this.easyKeyListener.ignore(c);
    }

    public String getMBCommittedMemory() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        double usedMemoryInMB = (double)usedMemory / 1048576.0;
        String memoryStr = this.memoryFormat.format(usedMemoryInMB);
        return memoryStr;
    }

    public void setEnvelopeRenderingThreshold(int newEnvelopeRenderingThreshold) {
        this.envelopeRenderingThreshold = newEnvelopeRenderingThreshold;
    }

    public void setMaximumFeatureExtentForEnvelopeRenderingInPixels(int newMaximumFeatureExtentForEnvelopeRenderingInPixels) {
        this.maximumFeatureExtentForEnvelopeRenderingInPixels = newMaximumFeatureExtentForEnvelopeRenderingInPixels;
    }

    @Deprecated
    public void log(String message) {
        this.log(message, null, new Exception().getStackTrace()[0]);
    }

    @Deprecated
    public void log(String message, Class clazz) {
        this.log(message, null, new Exception().getStackTrace()[0]);
    }

    @Deprecated
    public void log(String message, Throwable t) {
        this.log(message, t, new Exception().getStackTrace()[0]);
    }

    private void log(String message, Throwable t, StackTraceElement calledFrom) {
        Logger.log(message, Logger.isDebugEnabled() ? t : null, Logger.LogLevel.INFO, calledFrom);
    }

    public void setMinimumFeatureExtentForAnyRenderingInPixels(int newMinimumFeatureExtentForAnyRenderingInPixels) {
        this.minimumFeatureExtentForAnyRenderingInPixels = newMinimumFeatureExtentForAnyRenderingInPixels;
    }

    public void displayLastStatusMessage() {
        this.setStatusMessage(this.lastStatusMessage);
    }

    @Override
    public void setStatusMessage(String message) {
        this.setStatusMessage(message, null);
    }

    public void setStatusMessage(String message, int millis) {
        this.setStatusMessage(message, millis, null, false);
    }

    public void setStatusMessage(String message, Color color) {
        this.lastStatusMessage = message;
        this.setStatusBarText(message);
        boolean high = color != null;
        this.setStatusBarTextHighlighted(high, color);
    }

    public void setStatusMessage(final String msg, final int millis, final Color color, final boolean flash) {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (flash) {
                    WorkbenchFrame.this.flashStatusMessage(msg, color);
                } else {
                    WorkbenchFrame.this.setStatusMessage(msg, color);
                }
                if (millis > 0) {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (WorkbenchFrame.this.getStatusBarText().equals(msg)) {
                        WorkbenchFrame.this.setStatusMessage("");
                    }
                }
            }
        });
        this.thread.start();
    }

    private void setStatusBarText(String message) {
        this.messageText.setText(message);
        this.messageText.setToolTipText("<html><body>" + GUIUtil.escapeHTML(message) + "<br><br>" + GUIUtil.escapeHTML(I18N.getInstance().get("ui.WorkbenchFrame.copy-to-clipboard")) + "</body></html>");
    }

    private String getStatusBarText() {
        return this.messageText.getText();
    }

    private void setStatusBarTextHighlighted(boolean highlighted, Color color) {
        this.messageText.setForeground(highlighted ? Color.black : this.coordinateLabel.getForeground());
        this.messageText.setBackground(highlighted ? color : this.coordinateLabel.getBackground());
    }

    public void setTimeMessage(String message) {
        message = message == null || message.equals("") ? " " : message;
        this.timeLabel.setText(message);
        this.timeLabel.setToolTipText(message);
    }

    public void setScaleText(String message) {
        message = message == null || message.equals("") ? " " : message;
        this.scaleLabel.setText(message);
        this.scaleLabel.setToolTipText("<html><body>" + GUIUtil.escapeHTML(SCALE + " " + message) + "<br><br>" + GUIUtil.escapeHTML(SCALE_TIPS) + "</body></html>");
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this.init_message_lnf) {
            this.messageText.setFont(this.coordinateLabel.getFont());
            this.messageText.setBackground(this.coordinateLabel.getBackground());
            this.messageText.setForeground(this.coordinateLabel.getForeground());
            this.init_message_lnf = true;
        }
        super.setVisible(b);
    }

    public JInternalFrame getActiveInternalFrame() {
        return this.desktopPane.getSelectedFrame();
    }

    public JInternalFrame[] getInternalFrames() {
        return this.desktopPane.getAllFrames();
    }

    public TitledPopupMenu getCategoryPopupMenu() {
        return this.categoryPopupMenu;
    }

    public WorkbenchContext getContext() {
        return this.workbenchContext;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public int getEnvelopeRenderingThreshold() {
        return this.envelopeRenderingThreshold;
    }

    public TitledPopupMenu getLayerNamePopupMenu() {
        return this.layerNamePopupMenu;
    }

    public TitledPopupMenu getWMSLayerNamePopupMenu() {
        return this.wmsLayerNamePopupMenu;
    }

    public LayerViewPanelListener getLayerViewPanelListener() {
        return this.layerViewPanelListener;
    }

    public Map<Class<?>, JPopupMenu> getNodeClassToPopupMenuMap() {
        return this.nodeClassToLayerNamePopupMenuMap;
    }

    public LayerNamePanelListener getLayerNamePanelListener() {
        return this.layerNamePanelListener;
    }

    public int getMaximumFeatureExtentForEnvelopeRenderingInPixels() {
        return this.maximumFeatureExtentForEnvelopeRenderingInPixels;
    }

    public int getMinimumFeatureExtentForAnyRenderingInPixels() {
        return this.minimumFeatureExtentForAnyRenderingInPixels;
    }

    public HTMLFrame getOutputFrame() {
        if (this.outputFrame == null) {
            this.outputFrame = new HTMLFrame(this){
                {
                    super.setTitle(I18N.getInstance().get("ui.WorkbenchFrame.output"));
                }

                @Override
                public void setTitle(String title) {
                }
            };
        }
        return this.outputFrame;
    }

    public WorkbenchToolBar getToolBar() {
        return this.toolBar;
    }

    public void activateFrame(JInternalFrame frame) {
        try {
            if (frame.isIcon()) {
                frame.setIcon(false);
            }
            frame.moveToFront();
            frame.requestFocus();
            frame.setSelected(true);
            if (!(frame instanceof TaskFrame)) {
                frame.setMaximum(false);
            }
        }
        catch (PropertyVetoException e) {
            this.warnUser(StringUtil.stackTrace(e));
        }
    }

    public void addInternalFrame(JInternalFrame internalFrame) {
        this.addInternalFrame(internalFrame, false, true);
    }

    public void addInternalFrame(final JInternalFrame internalFrame, boolean alwaysOnTop, boolean autoUpdateToolBar) {
        if (internalFrame instanceof LayerManagerProxy) {
            this.setClosingBehaviour((LayerManagerProxy)((Object)internalFrame));
            this.installTitleBarModifiedIndicator((LayerManagerProxy)((Object)internalFrame));
        }
        if (!internalFrameDefaultIconSet) {
            internalFrameDefaultIcon = new JInternalFrame().getFrameIcon();
            internalFrameDefaultIconSet = true;
        }
        if (internalFrame.getFrameIcon() == null || internalFrame.getFrameIcon().equals(internalFrameDefaultIcon)) {
            JUMPWorkbench.setIcon(internalFrame);
        }
        internalFrame.setVisible(true);
        this.desktopPane.add((Component)internalFrame, alwaysOnTop ? JLayeredPane.PALETTE_LAYER : JLayeredPane.DEFAULT_LAYER);
        if (autoUpdateToolBar) {
            internalFrame.addInternalFrameListener(new InternalFrameListener(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                    if (internalFrame instanceof TaskFrameProxy) {
                        WorkbenchFrame.this.setActiveTaskFrame(((TaskFrameProxy)((Object)internalFrame)).getTaskFrame());
                    }
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }

                @Override
                public void internalFrameOpened(InternalFrameEvent e) {
                    WorkbenchFrame.this.toolBar.updateEnabledState();
                }
            });
        }
        internalFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                int new_y;
                if (internalFrame instanceof DetachableInternalFrame && ((DetachableInternalFrame)internalFrame).isDetached()) {
                    return;
                }
                int x = internalFrame.getX();
                int y = internalFrame.getY();
                int new_x = x < 0 ? 0 : x;
                int n = new_y = y < 0 ? 0 : y;
                if (x != new_x || y != new_y) {
                    internalFrame.setLocation(new_x, new_y);
                }
            }
        });
        internalFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (internalFrame.isMaximizable()) {
                    WorkbenchFrame.this.legalize(internalFrame);
                }
            }
        });
        this.position(internalFrame);
        this.activateFrame(internalFrame);
    }

    private void installTitleBarModifiedIndicator(final LayerManagerProxy internalFrame) {
        final JInternalFrame i = (JInternalFrame)((Object)internalFrame);
        new Block(){
            private boolean updatingTitle = false;

            private void updateTitle() {
                if (this.updatingTitle) {
                    return;
                }
                this.updatingTitle = true;
                try {
                    String newTitle = i.getTitle();
                    if (newTitle.length() > 0 && newTitle.charAt(0) == '*') {
                        newTitle = newTitle.substring(1);
                    }
                    if (!internalFrame.getLayerManager().getLayersWithModifiedFeatureCollections().isEmpty()) {
                        newTitle = '*' + newTitle;
                    }
                    i.setTitle(newTitle);
                }
                finally {
                    this.updatingTitle = false;
                }
            }

            @Override
            public Object yield() {
                final LayerListener layerListener = new LayerListener(){

                    @Override
                    public void layerChanged(LayerEvent e) {
                        if (e.getType() == LayerEventType.METADATA_CHANGED || e.getType() == LayerEventType.REMOVED) {
                            this.updateTitle();
                        }
                        if (e.getType() == LayerEventType.REMOVED && !(internalFrame instanceof TaskFrame)) {
                            internalFrame.getLayerManager().removeLayerListener(this);
                        }
                    }

                    @Override
                    public void categoryChanged(CategoryEvent e) {
                    }

                    @Override
                    public void featuresChanged(FeatureEvent e) {
                    }
                };
                internalFrame.getLayerManager().addLayerListener(layerListener);
                i.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosed(InternalFrameEvent e) {
                        internalFrame.getLayerManager().removeLayerListener(layerListener);
                    }
                });
                i.addPropertyChangeListener("title", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        this.updateTitle();
                    }
                });
                return null;
            }
        }.yield();
    }

    private void setClosingBehaviour(LayerManagerProxy proxy) {
        final JInternalFrame internalFrame = (JInternalFrame)((Object)proxy);
        internalFrame.setDefaultCloseOperation(0);
        internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                WorkbenchFrame.this.internalFrameCloseHandler.close(internalFrame);
            }
        });
    }

    private Collection getInternalFramesAssociatedWith(LayerManager layerManager) {
        ArrayList<JInternalFrame> internalFramesAssociatedWithLayerManager = new ArrayList<JInternalFrame>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof LayerManagerProxy) || ((LayerManagerProxy)((Object)internalFrames[i])).getLayerManager() != layerManager) continue;
            internalFramesAssociatedWithLayerManager.add(internalFrames[i]);
        }
        return internalFramesAssociatedWithLayerManager;
    }

    private Collection getTaskFramesAssociatedWith(LayerManager layerManager) {
        ArrayList<JInternalFrame> taskFramesAssociatedWithLayerManager = new ArrayList<JInternalFrame>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof TaskFrame) || ((TaskFrame)internalFrames[i]).getLayerManager() != layerManager) continue;
            taskFramesAssociatedWithLayerManager.add(internalFrames[i]);
        }
        return taskFramesAssociatedWithLayerManager;
    }

    private Collection getInternalFramesAssociatedWith(TaskFrame taskFrame) {
        ArrayList<JInternalFrame> internalFramesAssociatedWithTaskFrame = new ArrayList<JInternalFrame>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof TaskFrameProxy) || ((TaskFrameProxy)((Object)internalFrames[i])).getTaskFrame() != taskFrame || internalFrames[i] == taskFrame) continue;
            internalFramesAssociatedWithTaskFrame.add(internalFrames[i]);
        }
        return internalFramesAssociatedWithTaskFrame;
    }

    public TaskFrame addTaskFrame() {
        TaskFrame f = this.addTaskFrame(this.createTask());
        return f;
    }

    public Task createTask() {
        Task task = new Task();
        task.getLayerManager().addCategory(StandardCategoryNames.WORKING);
        task.getLayerManager().addCategory(StandardCategoryNames.SYSTEM);
        task.setName(I18N.getInstance().get("ui.WorkbenchFrame.task") + " " + this.taskSequence++);
        return task;
    }

    public TaskFrame addTaskFrame(Task task) {
        TaskFrame taskFrame;
        if (this.taskFrameFactory != null) {
            taskFrame = this.taskFrameFactory.createComponent();
            taskFrame.setTask(task);
        } else {
            taskFrame = new TaskFrame(task, this.workbenchContext);
        }
        return this.addTaskFrame(taskFrame);
    }

    public TaskFrame addTaskFrame(TaskFrame taskFrame) {
        double factor = 0.95;
        int w = (int)((double)this.getDesktopPane().getWidth() * factor);
        int h = (int)((double)this.getDesktopPane().getHeight() * factor);
        taskFrame.setSize(w, h);
        taskFrame.getTask().getLayerManager().addLayerListener(new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }

            @Override
            public void layerChanged(LayerEvent layerEvent) {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }
        });
        this.addInternalFrame(taskFrame);
        taskFrame.getLayerViewPanel().getLayerManager().getUndoableEditReceiver().add(new UndoableEditReceiver.Listener(){

            @Override
            public void undoHistoryChanged() {
                WorkbenchFrame.this.toolBar.updateEnabledState();
            }

            @Override
            public void undoHistoryTruncated() {
                WorkbenchFrame.this.toolBar.updateEnabledState();
                WorkbenchFrame.this.log(I18N.getInstance().get("ui.WorkbenchFrame.undo-history-was-truncated"));
            }
        });
        Object[] listeners = this.getTaskListeners().toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TaskListener l = (TaskListener)listeners[i];
            l.taskAdded(new TaskEvent(this, taskFrame.getTask()));
        }
        return taskFrame;
    }

    public List<TaskFrame> getTaskFrames() {
        ArrayList<TaskFrame> taskframes = new ArrayList<TaskFrame>();
        for (JInternalFrame frame : this.getInternalFrames()) {
            if (!(frame instanceof TaskFrame)) continue;
            taskframes.add((TaskFrame)frame);
        }
        return taskframes;
    }

    public TaskFrame getActiveTaskFrame() {
        return this.activeTaskFrame;
    }

    public void setActiveTaskFrame(TaskFrame taskFrame) {
        this.activeTaskFrame = taskFrame;
    }

    public void flash(final HTMLFrame frame) {
        final Color originalColor = frame.getBackgroundColor();
        new Timer(100, new ActionListener(){
            private int tickCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ++this.tickCount;
                    frame.setBackgroundColor(this.tickCount % 2 == 0 ? originalColor : Color.yellow);
                    if (this.tickCount == 2) {
                        Timer timer = (Timer)e.getSource();
                        timer.stop();
                    }
                }
                catch (Throwable t) {
                    WorkbenchFrame.this.handleThrowable(t);
                }
            }
        }).start();
    }

    private void flashStatusMessage(final String message, final Color color) {
        new Timer(100, new ActionListener(){
            private int tickCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                ++this.tickCount;
                WorkbenchFrame.this.setStatusBarText(message);
                WorkbenchFrame.this.setStatusBarTextHighlighted(this.tickCount % 2 == 0, color);
                if (this.tickCount == 4) {
                    Timer timer = (Timer)e.getSource();
                    timer.stop();
                }
            }
        }).start();
    }

    @Override
    public void handleThrowable(Throwable t) {
        Window parent = this;
        Window[] ownedWindows = this.getOwnedWindows();
        for (int i = 0; i < ownedWindows.length; ++i) {
            if (!(ownedWindows[i] instanceof Dialog) || !ownedWindows[i].isVisible() || !((Dialog)ownedWindows[i]).isModal()) continue;
            parent = ownedWindows[i];
            break;
        }
        this.handleThrowable(t, parent);
    }

    public void handleThrowable(final Throwable t, final Component parent) {
        Logger.error(t);
        final String stack = StringUtil.stackTrace(t);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.show(parent, StringUtil.toFriendlyName(t.getClass().getName()), WorkbenchFrame.toMessage(t), stack);
            }
        });
    }

    public static String toMessage(Throwable t) {
        SQLException nextT;
        String message = t.getLocalizedMessage() == null ? I18N.getInstance().get("ui.WorkbenchFrame.no-description-was-provided") : (t.getLocalizedMessage().toLowerCase().indexOf(I18N.getInstance().get("ui.WorkbenchFrame.side-location-conflict")) > -1 ? t.getLocalizedMessage() + " -- " + I18N.getInstance().get("ui.WorkbenchFrame.check-for-invalid-geometries") : t.getLocalizedMessage());
        if (t instanceof SQLException && (nextT = ((SQLException)t).getNextException()) != null) {
            message = message + "\n" + nextT.getLocalizedMessage();
        }
        return message + "\n\n (" + StringUtil.toFriendlyName(t.getClass().getName()) + ")";
    }

    public boolean hasInternalFrame(JInternalFrame internalFrame) {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] != internalFrame) continue;
            return true;
        }
        return false;
    }

    public void removeInternalFrame(JInternalFrame internalFrame) {
        this.desktopPane.getDesktopManager().closeFrame(internalFrame);
    }

    @Override
    public void warnUser(String warning) {
        this.log(I18N.getInstance().get("ui.WorkbenchFrame.warning") + ": " + warning);
        this.setStatusMessage(warning, 15000, Color.YELLOW, true);
    }

    @Override
    public void zoomChanged(Envelope modelEnvelope) {
        this.toolBar.updateEnabledState();
        if (this.getActiveTaskFrame() != null) {
            double scale = ScreenScale.getHorizontalMapScale(this.getActiveTaskFrame().getLayerViewPanel().getViewport());
            DecimalFormat format = scale >= 10.0 ? this.scaleFormat : this.scaleFormatSmall;
            this.setScaleText("1:" + format.format(scale));
        }
    }

    void exitMenuItem_actionPerformed(ActionEvent e) {
        this.closeApplication();
    }

    void this_componentShown(ComponentEvent e) {
        try {
            this.toolBar.updateEnabledState();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
    }

    void this_windowClosing(WindowEvent e) {
        this.closeApplication();
    }

    void windowMenu_menuSelected(MenuEvent e) {
        if (this.addedMenuItems == -1) {
            this.addedMenuItems = this.windowMenu.getItemCount();
            if (this.addedMenuItems > 0) {
                this.windowMenu.addSeparator();
                ++this.addedMenuItems;
            }
        }
        while (this.windowMenu.getItemCount() > this.addedMenuItems) {
            this.windowMenu.remove(this.windowMenu.getItemCount() - 1);
        }
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(GUIUtil.truncateString(frames[i].getTitle(), 40));
            this.associate(menuItem, frames[i]);
            this.windowMenu.add(menuItem);
        }
        if (this.windowMenu.getItemCount() == this.addedMenuItems) {
            this.windowMenu.add(new JMenuItem("(" + I18N.getInstance().get("ui.WorkbenchFrame.no-windows") + ")"));
        }
    }

    private void associate(JMenuItem menuItem, final JInternalFrame frame) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    WorkbenchFrame.this.activateFrame(frame);
                }
                catch (Throwable t) {
                    WorkbenchFrame.this.handleThrowable(t);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeApplication() {
        if (!this.confirmClose(I18N.getInstance().get("ui.WorkbenchFrame.exit-jump"), this.getLayersWithModifiedFeatureCollections(), this.getGeneratedLayers(), this)) {
            return;
        }
        try {
            Object[] handlers;
            int res = 0;
            if (this.getActiveTaskFrame() != null && (res = JOptionPane.showConfirmDialog(this, this.SAVE_PROJECT, this.EXIT_OPENJUMP, 1, -1, null)) == 0) {
                UndoableEditReceiver undoableEditReceiver;
                SaveProjectPlugIn saveProjectPlugIn = new SaveProjectPlugIn();
                UndoableEditReceiver undoableEditReceiver2 = undoableEditReceiver = this.workbenchContext.getLayerManager() != null ? this.workbenchContext.getLayerManager().getUndoableEditReceiver() : null;
                if (undoableEditReceiver != null) {
                    undoableEditReceiver.startReceiving();
                }
                PlugInContext context = this.getContext().createPlugInContext();
                saveProjectPlugIn.initialize(context);
                if (!saveProjectPlugIn.execute(context)) return;
                String projectName = this.workbenchContext.getTask().getProjectFile().getAbsolutePath();
                JOptionPane.showMessageDialog(this, this.PROJECT_SAVED + projectName, this.EXIT_OPENJUMP, -1);
            } else if (res == 2) {
                return;
            }
            this.saveWindowState();
            this.setVisible(false);
            for (Object handler : handlers = this.applicationExitHandlers.toArray()) {
                try {
                    ((ApplicationExitHandler)handler).exitApplication(this);
                }
                catch (Throwable t) {
                    this.handleThrowable(t);
                }
            }
        }
        catch (Throwable t) {
            try {
                Logger.warn(t.getMessage(), Logger.isDebugEnabled() ? t : null);
                ErrorDialog.show(this, StringUtil.toFriendlyName(t.getClass().getName()), WorkbenchFrame.toMessage(t), StringUtil.stackTrace(t));
            }
            catch (Throwable t2) {
                Logger.error(t2);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        });
    }

    private Collection getLayersWithModifiedFeatureCollections() {
        ArrayList<Layer> layersWithModifiedFeatureCollections = new ArrayList<Layer>();
        for (LayerManager layerManager : this.getLayerManagers()) {
            layersWithModifiedFeatureCollections.addAll(layerManager.getLayersWithModifiedFeatureCollections());
        }
        return layersWithModifiedFeatureCollections;
    }

    private Collection getGeneratedLayers() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (LayerManager layerManager : this.getLayerManagers()) {
            list.addAll(layerManager.getLayersWithNullDataSource());
            list.addAll(layerManager.getTemporaryRasterImageLayers());
        }
        return list;
    }

    private Collection getLayerManagers() {
        HashSet<LayerManager> layerManagers = new HashSet<LayerManager>();
        JInternalFrame[] internalFrames = this.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            if (!(internalFrames[i] instanceof LayerManagerProxy)) continue;
            layerManagers.add(((LayerManagerProxy)((Object)internalFrames[i])).getLayerManager());
        }
        return layerManagers;
    }

    private void configureStatusBarComponent(JComponent component, int width) {
        component.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        if (width > 0) {
            component.setMinimumSize(new Dimension(width, (int)component.getMinimumSize().getHeight()));
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                WorkbenchFrame.this.this_componentShown(e);
            }
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.addWindowListener(new WindowAdapter(){
            Exception lastException = null;

            @Override
            public void windowActivated(WindowEvent e) {
                try {
                    TaskFrame f = WorkbenchFrame.this.getActiveTaskFrame();
                    if (f != null) {
                        f.getLayerViewPanel().reSetCurrentCursorTool();
                    }
                }
                catch (Exception ex) {
                    if (this.lastException != null && ex.getStackTrace()[0].equals(this.lastException.getStackTrace()[0])) {
                        Logger.error(ex);
                        return;
                    }
                    WorkbenchFrame.this.handleThrowable(ex);
                    this.lastException = ex;
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                WorkbenchFrame.this.this_windowClosing(e);
            }
        });
        this.setJMenuBar(this.menuBar);
        this.setSize(900, 665);
        this.windowMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                WorkbenchFrame.this.windowMenu_menuSelected(e);
            }
        });
        this.messageText = new JTextArea(" ");
        this.timeLabel = new JLabel(" ");
        this.memoryLabel = new JLabel(" ");
        this.scaleLabel = new JLabel(" ");
        this.coordinateLabel = new JLabel(" ");
        this.memoryLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Runtime.getRuntime().gc();
                WorkbenchFrame.this.setStatusMessage(MEMORY_GC, 2000);
            }
        });
        this.scaleLabel.addMouseListener(new MouseAdapter(){
            PlugIn plugin = null;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (this.plugin == null) {
                    this.plugin = new ZoomToScalePlugIn(){

                        @Override
                        public void initialize(PlugInContext context) throws Exception {
                            super.initialize(context);
                        }
                    };
                    try {
                        this.plugin.initialize(WorkbenchFrame.this.workbenchContext.createPlugInContext());
                    }
                    catch (Exception ex) {
                        WorkbenchFrame.this.handleThrowable(ex);
                        return;
                    }
                }
                WorkbenchFrame.this.executePlugin(this.plugin);
            }
        });
        this.coordinateLabel.addMouseListener(new MouseAdapter(){
            PlugIn plugin = null;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (this.plugin == null) {
                    this.plugin = new ZoomToCoordinatePlugIn();
                    try {
                        this.plugin.initialize(WorkbenchFrame.this.workbenchContext.createPlugInContext());
                    }
                    catch (Exception ex) {
                        WorkbenchFrame.this.handleThrowable(ex);
                        return;
                    }
                }
                WorkbenchFrame.this.executePlugin(this.plugin);
            }
        });
        this.coordinateLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(1000);
                ToolTipManager.sharedInstance().setDismissDelay(1800);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(WorkbenchFrame.this.defaultInitialTimeout);
                ToolTipManager.sharedInstance().setDismissDelay(WorkbenchFrame.this.defaultDismissTimeout);
            }
        });
        this.scaleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(1000);
                ToolTipManager.sharedInstance().setDismissDelay(1800);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(WorkbenchFrame.this.defaultInitialTimeout);
                ToolTipManager.sharedInstance().setDismissDelay(WorkbenchFrame.this.defaultDismissTimeout);
            }
        });
        this.memoryLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(1000);
                ToolTipManager.sharedInstance().setDismissDelay(1800);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(WorkbenchFrame.this.defaultInitialTimeout);
                ToolTipManager.sharedInstance().setDismissDelay(WorkbenchFrame.this.defaultDismissTimeout);
            }
        });
        this.messageText.setMinimumSize(new Dimension(50, 1));
        this.messageText.setLineWrap(true);
        this.messageText.setWrapStyleWord(true);
        this.messageText.setEditable(false);
        this.setStatusBarText("");
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.windowMenu);
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.getContentPane().add((Component)this.toolBar, "North");
        this.statusPanel = new JPanel(new BorderLayout());
        int dividerSize = 3;
        this.statusPanelSplitPane4 = new JSplitPane(1, true, this.scaleLabel, this.coordinateLabel);
        this.statusPanelSplitPane4.setDividerSize(dividerSize);
        this.statusPanelSplitPane4.setResizeWeight(0.0);
        this.statusPanelSplitPane3 = new JSplitPane(1, true, this.memoryLabel, this.statusPanelSplitPane4);
        this.statusPanelSplitPane3.setDividerSize(dividerSize);
        this.statusPanelSplitPane3.setResizeWeight(0.0);
        this.statusPanelSplitPane2 = new JSplitPane(1, true, this.timeLabel, this.statusPanelSplitPane3);
        this.statusPanelSplitPane2.setDividerSize(dividerSize);
        this.statusPanelSplitPane2.setResizeWeight(0.0);
        this.statusPanelSplitPane1 = new JSplitPane(1, true, this.messageText, this.statusPanelSplitPane2);
        this.statusPanelSplitPane1.setDividerSize(dividerSize);
        this.statusPanelSplitPane1.setResizeWeight(1.0);
        Border b = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.statusPanelSplitPane1.setBorder(b);
        this.statusPanelSplitPane2.setBorder(b);
        this.statusPanelSplitPane3.setBorder(b);
        this.statusPanelSplitPane4.setBorder(b);
        this.statusPanel.add((Component)this.statusPanelSplitPane1, "Center");
        this.desktopStatusSplit = new JSplitPane(0, this.desktopPane, this.statusPanel);
        this.desktopStatusSplit.setDividerSize(dividerSize);
        this.desktopStatusSplit.setResizeWeight(1.0);
        this.getContentPane().add((Component)this.desktopStatusSplit, "Center");
    }

    private void position(JInternalFrame internalFrame) {
        int offset;
        int STEP = 5;
        GUIUtil.Location location = null;
        if (internalFrame instanceof InfoFrame || internalFrame instanceof ViewAttributesPlugIn.ViewAttributesFrame) {
            ++this.primaryInfoFrameIndex;
            offset = this.primaryInfoFrameIndex % 3 * 5;
            location = new GUIUtil.Location(offset + 10, false, offset + 10, true);
        } else {
            ++this.positionIndex;
            offset = this.positionIndex % 5 * 5;
            location = new GUIUtil.Location(offset, false, offset, false);
        }
        int x = location.x;
        int y = location.y;
        int w = internalFrame.getWidth();
        int h = internalFrame.getHeight();
        int pane_w = this.getDesktopPane().getWidth();
        int pane_h = this.getDesktopPane().getHeight();
        int new_w = w;
        int new_h = h;
        if (x + w > pane_w) {
            new_w = pane_w - x;
        }
        if (y + h > pane_h) {
            new_h = pane_h - y;
        }
        GUIUtil.setBounds(internalFrame, location, new_w, new_h, this.getDesktopPane());
    }

    private void legalize(JInternalFrame iframe) {
        if (iframe instanceof DetachableInternalFrame && ((DetachableInternalFrame)iframe).isDetached()) {
            return;
        }
        int x = iframe.getX();
        int y = iframe.getY();
        int w = iframe.getWidth();
        int h = iframe.getHeight();
        int pane_w = this.getDesktopPane().getWidth();
        int pane_h = this.getDesktopPane().getHeight();
        int new_x = x;
        int new_y = y;
        int new_w = w;
        int new_h = h;
        if (x + w >= pane_w) {
            if (pane_w - w < 0) {
                new_x = 0;
                new_w = pane_w;
            } else {
                new_x = pane_w - w;
            }
        }
        if (y + h >= pane_h) {
            if (pane_h - h < 0) {
                new_y = 0;
                new_h = pane_h;
            } else {
                new_y = pane_h - h;
            }
        }
        if (x != new_x || y != new_y || w != new_w || h != new_h) {
            iframe.setBounds(new_x, new_y, new_w, new_h);
        }
    }

    public Set getChoosableStyleClasses() {
        return Collections.unmodifiableSet(this.choosableStyleClasses);
    }

    public void addChoosableStyleClass(Class choosableStyleClass) {
        Assert.isTrue((boolean)ChoosableStyle.class.isAssignableFrom(choosableStyleClass));
        this.choosableStyleClasses.add(choosableStyleClass);
    }

    public void addKeyboardShortcut(KeyStroke stroke, PlugIn plugIn) {
        this.shortcutListener.add(stroke, plugIn);
    }

    public PlugIn getKeyboardShortcutPlugin(KeyStroke key) {
        PlugIn p = this.shortcutListener.getPlugIn(key);
        return p;
    }

    public final Set<KeyStroke> getKeyboardShortcuts() {
        return this.shortcutListener.getAllKeyStrokes();
    }

    public InternalFrameCloseHandler getInternalFrameCloseHandler() {
        return this.internalFrameCloseHandler;
    }

    public void setInternalFrameCloseHandler(InternalFrameCloseHandler value) {
        this.internalFrameCloseHandler = value;
    }

    private List<ApplicationExitHandler> getApplicationExitHandlers() {
        return this.applicationExitHandlers;
    }

    public void addApplicationExitHandler(ApplicationExitHandler aeh) {
        if (aeh == null) {
            throw new IllegalArgumentException("ApplicationExitHandler must not be null!");
        }
        this.applicationExitHandlers.add(aeh);
    }

    public void removeApplicationExitHandler(ApplicationExitHandler aeh) {
        this.applicationExitHandlers.remove(aeh);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeTaskFrame(TaskFrame taskFrame) {
        boolean lastTaskFrame;
        LayerManager layerManager = taskFrame.getLayerManager();
        Collection associatedFrames = this.getInternalFramesAssociatedWith(taskFrame);
        boolean bl = lastTaskFrame = this.getTaskFramesAssociatedWith(layerManager).size() == 1;
        if (lastTaskFrame) {
            Collection<Layer> modifiedItems = layerManager.getLayersWithModifiedFeatureCollections();
            LinkedList<Layer> generatedItems = layerManager.getLayersWithNullDataSource();
            if (!this.confirmClose(I18N.getInstance().get("ui.WorkbenchFrame.close-task"), modifiedItems, generatedItems, taskFrame)) return;
            try {
                int res = JOptionPane.showConfirmDialog(this, this.CLOSE_PROJECT_QUESTION, this.CLOSE_PROJECT, 2, -1, null);
                if (res == 2) {
                    return;
                }
            }
            catch (Exception e) {
                this.log("", e);
            }
            if (associatedFrames.size() != 0) {
                if (!this.confirmClose(StringUtil.split(I18N.getInstance().get("ui.WorkbenchFrame.other-internal-frames-depend-on-this-task-frame") + " " + I18N.getInstance().get("ui.WorkbenchFrame.do-you-want-to-close-them-also"), 60), I18N.getInstance().get("ui.WorkbenchFrame.close-all"))) return;
                Iterator it = associatedFrames.iterator();
                while (it.hasNext()) {
                    GUIUtil.dispose((JInternalFrame)it.next(), this.desktopPane);
                }
            }
            layerManager.dispose();
            taskFrame.getLayerViewPanel().dispose();
            taskFrame.getLayerNamePanel().dispose();
            GUIUtil.dispose(taskFrame, this.desktopPane);
            return;
        }
        if (associatedFrames.size() != 0) {
            if (!this.confirmClose(StringUtil.split(I18N.getInstance().get("ui.WorkbenchFrame.other-internal-frames-depend-on-this-task-frame") + " " + I18N.getInstance().get("ui.WorkbenchFrame.do-you-want-to-close-them-also"), 60), I18N.getInstance().get("ui.WorkbenchFrame.close-all"))) return;
            Iterator it = associatedFrames.iterator();
            while (it.hasNext()) {
                GUIUtil.dispose((JInternalFrame)it.next(), this.desktopPane);
            }
        }
        taskFrame.getLayerViewPanel().dispose();
        taskFrame.getLayerNamePanel().dispose();
        GUIUtil.dispose(taskFrame, this.desktopPane);
    }

    private boolean confirmClose(String action, Collection modifiedLayers, Collection generatedLayers, Container container) {
        if (modifiedLayers.isEmpty()) {
            if (generatedLayers.isEmpty()) {
                return true;
            }
            JOptionPane pane = new JOptionPane();
            String message = null;
            if (container instanceof WorkbenchFrame) {
                message = I18N.getInstance().get("ui.WorkbenchFrame.do-you-really-want-to-close-openjump", generatedLayers.size());
            } else if (container instanceof TaskFrame) {
                message = I18N.getInstance().get("ui.WorkbenchFrame.do-you-really-want-to-close-the-project", generatedLayers.size());
            }
            pane.setMessage(message);
            pane.setMessageType(3);
            pane.setOptions(new String[]{action, I18N.getInstance().get("ui.WorkbenchFrame.cancel")});
            pane.createDialog(this, "OpenJUMP").setVisible(true);
            return pane.getValue().equals(action);
        }
        JOptionPane pane = new JOptionPane(StringUtil.split(modifiedLayers.size() + " " + I18N.getInstance().get("ui.WorkbenchFrame.dataset") + StringUtil.s(modifiedLayers.size()) + " " + (modifiedLayers.size() > 1 ? I18N.getInstance().get("ui.WorkbenchFrame.have-been-modified") : I18N.getInstance().get("ui.WorkbenchFrame.has-been-modified")) + " (" + (modifiedLayers.size() > 3 ? "e.g. " : "") + StringUtil.toCommaDelimitedString(new ArrayList(modifiedLayers).subList(0, Math.min(3, modifiedLayers.size()))) + ").\n" + I18N.getInstance().get("ui.WorkbenchFrame.continue"), 80), 2);
        pane.setOptions(new String[]{action, I18N.getInstance().get("ui.WorkbenchFrame.cancel")});
        pane.createDialog(this, "OpenJUMP").setVisible(true);
        return pane.getValue().equals(action);
    }

    private boolean confirmClose(String question, String action) {
        JOptionPane pane = new JOptionPane(question, 2);
        pane.setOptions(new String[]{action, I18N.getInstance().get("ui.WorkbenchFrame.cancel")});
        pane.createDialog(this, "OpenJUMP").setVisible(true);
        return pane.getValue().equals(action);
    }

    public void setTaskFrameFactory(ComponentFactory<TaskFrame> taskFrameFactory) {
        this.taskFrameFactory = taskFrameFactory;
    }

    public void saveWindowState() {
        boolean maximized = this.getExtendedState() == 6;
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        blackboard.put(MAXIMIZED_KEY, maximized);
        Point p = this.getLocation(null);
        blackboard.put(HORIZONTAL_KEY, p.x);
        blackboard.put(VERTICAL_KEY, p.y);
        Dimension d = this.getSize();
        blackboard.put(WIDTH_KEY, d.width);
        blackboard.put(HEIGHT_KEY, d.height);
        blackboard.put(STATUSPANEL_DIVIDER_LOCATION_1, new Integer(this.statusPanelSplitPane1.getDividerLocation()));
        blackboard.put(STATUSPANEL_DIVIDER_LOCATION_2, new Integer(this.statusPanelSplitPane2.getDividerLocation()));
        blackboard.put(STATUSPANEL_DIVIDER_LOCATION_3, new Integer(this.statusPanelSplitPane3.getDividerLocation()));
        blackboard.put(STATUSPANEL_DIVIDER_LOCATION_4, new Integer(this.statusPanelSplitPane4.getDividerLocation()));
        blackboard.put(DESKTOPSTATUS_DIVIDER_LOCATION, new Integer(this.desktopStatusSplit.getDividerLocation()));
    }

    private boolean recallMaximizedState() {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        boolean maximized = true;
        if (blackboard.get(MAXIMIZED_KEY) == null) {
            blackboard.put(MAXIMIZED_KEY, maximized);
        }
        maximized = (Boolean)blackboard.get(MAXIMIZED_KEY);
        return maximized;
    }

    public Point initWindowLocation() {
        Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return new Point((rect.width - this.getWidth()) / 2 + rect.x, (rect.height - this.getHeight()) / 2 + rect.y);
    }

    public Dimension initWindowSize() {
        Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (rect.width > 740) {
            rect.width = 740;
        }
        if (rect.height > 480) {
            rect.height = 480;
        }
        return rect.getSize();
    }

    private Point recallWindowLocation() {
        Point p;
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        if (blackboard.get(HORIZONTAL_KEY) == null) {
            p = this.initWindowLocation();
            blackboard.put(HORIZONTAL_KEY, p.x);
            blackboard.put(VERTICAL_KEY, p.y);
        } else {
            p = new Point((Integer)blackboard.get(HORIZONTAL_KEY), (Integer)blackboard.get(VERTICAL_KEY));
        }
        return p;
    }

    private Dimension recallWindowSize() {
        Dimension d;
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        this.statusPanelSplitPane1.setDividerLocation(blackboard.get(STATUSPANEL_DIVIDER_LOCATION_1, 200));
        this.statusPanelSplitPane2.setDividerLocation(blackboard.get(STATUSPANEL_DIVIDER_LOCATION_2, 200));
        this.statusPanelSplitPane3.setDividerLocation(blackboard.get(STATUSPANEL_DIVIDER_LOCATION_3, 100));
        this.statusPanelSplitPane4.setDividerLocation(blackboard.get(STATUSPANEL_DIVIDER_LOCATION_4, 100));
        this.desktopStatusSplit.setDividerLocation(blackboard.get(DESKTOPSTATUS_DIVIDER_LOCATION, -1));
        if (blackboard.get(WIDTH_KEY) == null) {
            d = this.initWindowSize();
            blackboard.put(WIDTH_KEY, d.width);
            blackboard.put(HEIGHT_KEY, d.height);
        }
        d = new Dimension();
        d.width = (Integer)blackboard.get(WIDTH_KEY);
        d.height = (Integer)blackboard.get(HEIGHT_KEY);
        return d;
    }

    public void restore() {
        this.setSize(this.recallWindowSize());
        this.setLocation(this.recallWindowLocation());
        if (this.recallMaximizedState()) {
            this.setExtendedState(6);
        }
    }

    public ArrayList<TaskListener> getTaskListeners() {
        return this.taskListeners;
    }

    public void addTaskListener(TaskListener l) {
        this.getTaskListeners().add(l);
    }

    public void removeTaskListener(TaskListener l) {
        this.getTaskListeners().remove(l);
    }

    private boolean executePlugin(PlugIn plugin) {
        try {
            String error;
            String string = error = plugin instanceof EnableChecked ? ((EnableChecked)((Object)plugin)).getEnableCheck().check(new JLabel()) : "";
            if (!StringUtils.isEmpty((CharSequence)error)) {
                this.warnUser(error);
                return false;
            }
            return plugin.execute(this.workbenchContext.createPlugInContext());
        }
        catch (Exception e) {
            this.handleThrowable(e);
            return false;
        }
    }

    private class AppleHandler
    implements InvocationHandler {
        String[] defaultPackageNames = new String[]{"java.awt.desktop", "com.apple.eawt"};

        private AppleHandler() {
        }

        public void register() {
            try {
                Class desktopClass = null;
                Object desktopObject = null;
                Class quitHandlerClass = this.findClass("QuitHandler");
                Class aboutHandlerClass = this.findClass("AboutHandler");
                Class openFilesHandlerClass = this.findClass("OpenFilesHandler");
                Class preferencesHandlerClass = this.findClass("PreferencesHandler");
                if (quitHandlerClass != null && quitHandlerClass.getPackage().getName().equals("com.apple.eawt") && (desktopClass = this.findClass("Application", new String[]{"com.apple.eawt"})) != null) {
                    desktopObject = desktopClass.getDeclaredMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
                }
                if (desktopClass == null && (desktopClass = this.findClass("Desktop", new String[]{"java.awt"})) != null) {
                    desktopObject = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                }
                if (desktopClass == null) {
                    Logger.error("Couldn't find desktop class. Skip registering desktop handlers.");
                    return;
                }
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{quitHandlerClass, aboutHandlerClass, openFilesHandlerClass, preferencesHandlerClass}, (InvocationHandler)this);
                if (quitHandlerClass != null) {
                    desktopClass.getDeclaredMethod("setQuitHandler", quitHandlerClass).invoke(desktopObject, proxy);
                }
                if (aboutHandlerClass != null) {
                    desktopClass.getDeclaredMethod("setAboutHandler", aboutHandlerClass).invoke(desktopObject, proxy);
                }
                if (openFilesHandlerClass != null) {
                    desktopClass.getDeclaredMethod("setOpenFileHandler", openFilesHandlerClass).invoke(desktopObject, proxy);
                }
                if (preferencesHandlerClass != null) {
                    desktopClass.getDeclaredMethod("setPreferencesHandler", preferencesHandlerClass).invoke(desktopObject, proxy);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Logger.error(e);
            }
        }

        private Class findClass(String className) {
            return this.findClass(className, null);
        }

        private Class findClass(String className, String[] packageNameList) {
            if (packageNameList == null || packageNameList.length < 1) {
                packageNameList = this.defaultPackageNames;
            }
            for (String packageName : packageNameList) {
                Logger.debug("Looking for class '" + className + "' ..");
                String fullClassName = packageName + "." + className;
                try {
                    Logger.debug("Try '" + fullClassName + "' ..");
                    return Class.forName(fullClassName);
                }
                catch (ClassNotFoundException e) {
                    Logger.debug("Class not avail '" + fullClassName + "'");
                }
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("openFiles".equals(method.getName())) {
                Object files;
                if (args[0] != null && (files = args[0].getClass().getMethod("getFiles", new Class[0]).invoke(args[0], new Object[0])) instanceof List) {
                    for (File file : (List)files) {
                        Logger.error("Opening file '" + file.getAbsolutePath() + "' currently not implemented");
                    }
                }
            } else if ("handleQuitRequestWith".equals(method.getName())) {
                WorkbenchFrame.this.closeApplication();
                if (args[1] != null) {
                    args[1].getClass().getDeclaredMethod("cancelQuit", new Class[0]).invoke(args[1], new Object[0]);
                }
            } else if ("handleAbout".equals(method.getName())) {
                AboutDialog.instance(WorkbenchFrame.this.getContext()).setVisible(true);
            } else if ("handlePreferences".equals(method.getName())) {
                OptionsPlugIn.execute();
            }
            return null;
        }
    }

    private class DefaultInternalFrameCloser
    implements InternalFrameCloseHandler {
        private DefaultInternalFrameCloser() {
        }

        @Override
        public void close(JInternalFrame internalFrame) {
            if (internalFrame instanceof TaskFrame) {
                JInternalFrame activeInternalFrame;
                if (WorkbenchFrame.this.activeTaskFrame == internalFrame) {
                    WorkbenchFrame.this.closeTaskFrame((TaskFrame)internalFrame);
                }
                if (!((activeInternalFrame = WorkbenchFrame.this.getActiveInternalFrame()) instanceof TaskFrameProxy)) {
                    WorkbenchFrame.this.activeTaskFrame = null;
                } else {
                    WorkbenchFrame.this.activeTaskFrame = ((TaskFrameProxy)((Object)activeInternalFrame)).getTaskFrame();
                }
            } else {
                GUIUtil.dispose(internalFrame, WorkbenchFrame.this.desktopPane);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.runFinalization();
                    System.gc();
                }
            });
        }
    }

    public class ExitPlugin
    extends AbstractPlugIn {
        public ExitPlugin() {
            super(I18N.getInstance().get("ui.WorkbenchFrame.exit"));
            this.setShortcutKeys(81);
            this.setShortcutModifiers(128);
        }

        @Override
        public void initialize(PlugInContext context) throws Exception {
            super.initialize(context);
            context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.FILE});
            context.getFeatureInstaller().registerShortcuts(this);
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            WorkbenchFrame.this.closeApplication();
            return true;
        }

        @Override
        public Icon getIcon() {
            return IconLoader.icon("famfam/door_in.png");
        }
    }
}

