/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.InfoModelListener;
import com.vividsolutions.jump.workbench.ui.LayerTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InfoModel {
    private Map<Layerable, LayerTableModel> layerToTableModelMap = new LinkedHashMap<Layerable, LayerTableModel>();
    private ArrayList listeners = new ArrayList();

    public void dispose() {
        for (Layer layer : new ArrayList<Layer>(this.getLayers())) {
            this.remove(layer);
        }
    }

    public Collection getLayerTableModels() {
        return Collections.unmodifiableCollection(this.layerToTableModelMap.values());
    }

    public void add(Layer layer, Collection features) {
        boolean layerNew = !this.layerToTableModelMap.containsKey(layer);
        LayerTableModel layerTableModel = this.getTableModel(layer);
        layerTableModel.addAll(features);
        if (layerNew) {
            for (InfoModelListener listener : this.listeners) {
                listener.layerAdded(layerTableModel);
            }
        }
    }

    public void remove(Layer layer) {
        if (!this.layerToTableModelMap.containsKey(layer)) {
            return;
        }
        LayerTableModel layerTableModel = this.getTableModel(layer);
        LayerManager layerManager = layer.getLayerManager();
        if (layerManager == null) {
            layerManager.removeLayerListener(layerTableModel.layerListener);
        }
        for (InfoModelListener listener : this.listeners) {
            listener.layerRemoved(layerTableModel);
        }
        this.layerToTableModelMap.get(layer).dispose();
        this.layerToTableModelMap.remove(layer);
    }

    public void clear() {
        ArrayList<Layerable> layers = new ArrayList<Layerable>(this.layerToTableModelMap.keySet());
        for (Layer layer : layers) {
            this.remove(layer);
        }
    }

    public LayerTableModel getTableModel(Layer layer) {
        if (!this.layerToTableModelMap.containsKey(layer)) {
            this.layerToTableModelMap.put(layer, new LayerTableModel(layer));
        }
        return this.layerToTableModelMap.get(layer);
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(new ArrayList<Layerable>(this.layerToTableModelMap.keySet()));
    }

    public void addListener(InfoModelListener listener) {
        this.listeners.add(listener);
    }
}

