/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.AlphaComposite;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;

public class GUIUtil {
    public static final String dbf = "dbf";
    public static final String dbfDesc = "DBF";
    public static final String fme = "fme";
    public static final String fmeDesc = "FME GML";
    public static final String gml = "gml";
    public static final String gmlDesc = "GML";
    public static final String jml = "jml";
    public static final String jmlDesc = "JCS GML";
    public static final String shp = "shp";
    public static final String shpDesc = "ESRI Shapefile";
    public static final String shx = "shx";
    public static final String shxDesc = "SHX";
    public static final String wkt = "wkt";
    public static final String wktDesc = "Well Known Text";
    public static final String wktaDesc = "Well Known Text (Show Attribute)";
    public static final String xml = "xml";
    public static final String xmlDesc = "XML";
    public static final FileFilter ALL_FILES_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return "All Files";
        }
    };
    public static final int UNIFORM_TRANSLUCENCY = 0;
    public static final int PERPIXEL_TRANSLUCENCY = 1;
    public static final int SHAPED_WINDOW = 2;

    public static String escapeHTML(String value) {
        return GUIUtil.escapeHTML(value, true, true);
    }

    public static String escapeHTML(String value, boolean escapeSpaces, boolean escapeNewlines) {
        if (value == null) {
            return null;
        }
        char[] content = new char[value.length()];
        value.getChars(0, value.length(), content, 0);
        StringBuilder result = new StringBuilder();
        block36: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case ' ': {
                    result.append(escapeSpaces ? "&#32;" : " ");
                    continue block36;
                }
                case '\n': {
                    result.append(escapeNewlines ? "<BR>" : "\n");
                    continue block36;
                }
                case '!': {
                    result.append("&#33;");
                    continue block36;
                }
                case '\"': {
                    result.append("&#34;");
                    continue block36;
                }
                case '#': {
                    result.append("&#35;");
                    continue block36;
                }
                case '$': {
                    result.append("&#36;");
                    continue block36;
                }
                case '%': {
                    result.append("&#37;");
                    continue block36;
                }
                case '&': {
                    result.append("&#38;");
                    continue block36;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block36;
                }
                case '(': {
                    result.append("&#40;");
                    continue block36;
                }
                case ')': {
                    result.append("&#41;");
                    continue block36;
                }
                case '*': {
                    result.append("&#42;");
                    continue block36;
                }
                case '+': {
                    result.append("&#43;");
                    continue block36;
                }
                case ',': {
                    result.append("&#44;");
                    continue block36;
                }
                case '-': {
                    result.append("&#45;");
                    continue block36;
                }
                case '.': {
                    result.append("&#46;");
                    continue block36;
                }
                case '/': {
                    result.append("&#47;");
                    continue block36;
                }
                case ':': {
                    result.append("&#58;");
                    continue block36;
                }
                case ';': {
                    result.append("&#59;");
                    continue block36;
                }
                case '<': {
                    result.append("&#60;");
                    continue block36;
                }
                case '=': {
                    result.append("&#61;");
                    continue block36;
                }
                case '>': {
                    result.append("&#62;");
                    continue block36;
                }
                case '?': {
                    result.append("&#63;");
                    continue block36;
                }
                case '@': {
                    result.append("&#64;");
                    continue block36;
                }
                case '[': {
                    result.append("&#91;");
                    continue block36;
                }
                case '\\': {
                    result.append("&#92;");
                    continue block36;
                }
                case ']': {
                    result.append("&#93;");
                    continue block36;
                }
                case '^': {
                    result.append("&#94;");
                    continue block36;
                }
                case '_': {
                    result.append("&#95;");
                    continue block36;
                }
                case '`': {
                    result.append("&#96;");
                    continue block36;
                }
                case '{': {
                    result.append("&#123;");
                    continue block36;
                }
                case '|': {
                    result.append("&#124;");
                    continue block36;
                }
                case '}': {
                    result.append("&#125;");
                    continue block36;
                }
                case '~': {
                    result.append("&#126;");
                    continue block36;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String getExtension(File f) {
        return FileUtil.getExtension(f);
    }

    public static Color alphaColor(Color color, int alpha) {
        if (color == null) {
            return null;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static void centre(Component componentToMove, Component componentToCentreOn) {
        int offset = 30;
        Dimension screendim = GUIUtil.getMultiScreenDimension();
        Dimension componentToCentreOnSize = componentToCentreOn.getSize();
        int newx = componentToCentreOn.getX() + (componentToCentreOnSize.width - componentToMove.getWidth()) / 2;
        int newy = componentToCentreOn.getY() + (componentToCentreOnSize.height - componentToMove.getHeight()) / 2;
        int neww = componentToMove.getWidth();
        int newh = componentToMove.getHeight();
        if (newx < offset) {
            newx = offset;
        }
        if (newy < offset) {
            newy = offset;
        }
        if (newx + neww > screendim.width - offset) {
            neww = screendim.width - offset - newx;
        }
        if (newy + newh > screendim.height - offset) {
            newh = screendim.height - offset - newy;
        }
        componentToMove.setBounds(newx, newy, neww, newh);
    }

    private static Dimension getMultiScreenDimension() {
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int w = 0;
        int h = 0;
        for (GraphicsDevice gd : gds) {
            Rectangle r = gd.getDefaultConfiguration().getBounds();
            if (r.getX() + r.getWidth() > (double)w) {
                w = (int)(r.getX() + r.getWidth());
            }
            if (!(r.getY() + r.getHeight() > (double)h)) continue;
            h = (int)(r.getY() + r.getHeight());
        }
        return new Dimension(w, h);
    }

    public static void centreOnScreen(Component componentToMove) {
        Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int newx = (rect.width - componentToMove.getWidth()) / 2 + rect.x;
        int newy = (rect.height - componentToMove.getHeight()) / 2 + rect.y;
        Dimension screendim = Toolkit.getDefaultToolkit().getScreenSize();
        int offset = 30;
        int neww = componentToMove.getWidth();
        int newh = componentToMove.getHeight();
        if (neww > screendim.width - 2 * offset) {
            neww = screendim.width - 2 * offset;
            newx = offset;
        }
        if (newh > screendim.height - 2 * offset) {
            newh = screendim.height - 2 * offset;
            newy = offset;
        }
        componentToMove.setBounds(newx, newy, neww, newh);
    }

    public static void centreOnWindow(Component componentToMove) {
        GUIUtil.centre(componentToMove, SwingUtilities.windowForComponent(componentToMove));
    }

    public static void centreOnWindow(Window windowToMove) {
        windowToMove.pack();
        GUIUtil.centre(windowToMove, SwingUtilities.windowForComponent(windowToMove));
    }

    public static void chooseGoodColumnWidths(JTable table) {
        int PADDING = 5;
        if (table.getModel().getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            double headerWidth = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, table.getModel().getColumnName(i), false, false, 0, i).getPreferredSize().getWidth() + 5.0;
            double valueWidth = 10.0;
            try {
                valueWidth = table.getCellRenderer(0, i).getTableCellRendererComponent(table, table.getModel().getValueAt(0, i), false, false, 0, i).getPreferredSize().getWidth() + 5.0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            int width = Math.min(200, Math.max((int)headerWidth, (int)valueWidth));
            column.setPreferredWidth(width);
            column.setWidth(width);
        }
    }

    public static JFileChooser createJFileChooserWithExistenceChecking() {
        return new JFCWithEnterAction(){

            @Override
            public void approveSelection() {
                File[] files = GUIUtil.selectedFiles(this);
                if (files.length == 0) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].exists() || files[i].isFile()) continue;
                    return;
                }
                super.approveSelection();
            }
        };
    }

    public static JFileChooser createJFileChooserWithOverwritePrompting() {
        return new FileChooserWithOverwritePrompting();
    }

    public static JFileChooser createJFileChooserWithOverwritePrompting(String ext) {
        return new FileChooserWithOverwritePrompting(ext);
    }

    public static boolean showConfirmOverwriteDialog(Component parent, File file) {
        int response = JOptionPane.showConfirmDialog(parent, I18N.getInstance().get("ui.GUIUtil.overwrite-prompting", file.getName()), "JUMP", 0);
        return response == 0;
    }

    public static void doNotRoundDoubles(JTable table) {
        table.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){
            {
                this.setHorizontalAlignment(4);
            }

            @Override
            public void setValue(Object value) {
                this.setText(value == null ? "" : "" + value);
            }
        });
    }

    public static void fixEditableComboBox(JComboBox cb) {
        Assert.isTrue((boolean)cb.isEditable());
        if (!UIManager.getLookAndFeel().getName().equals("Windows")) {
            return;
        }
        cb.setEditor(new BasicComboBoxEditor(){

            @Override
            public void setItem(Object item) {
                super.setItem(item);
                this.editor.selectAll();
            }
        });
    }

    public static void handleThrowable(final Throwable t, final Component parent) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    t.printStackTrace(System.out);
                    JOptionPane.showMessageDialog(parent, StringUtil.split(t.toString(), 80), "Exception", 0);
                }
            });
        }
        catch (Throwable t2) {
            t2.printStackTrace(System.out);
        }
    }

    public static void invokeOnEventThread(Runnable r) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeAndWait(r);
        }
    }

    public static String nameWithoutExtension(File file) {
        String name = file.getName();
        int dotPosition = name.indexOf(46);
        return dotPosition < 0 ? name : name.substring(0, dotPosition);
    }

    public static void removeChoosableFileFilters(JFileChooser fc) {
        FileFilter[] filters;
        for (FileFilter fileFilter : filters = fc.getChoosableFileFilters()) {
            fc.removeChoosableFileFilter(fileFilter);
        }
    }

    public static FileFilter createFileFilter(final String description, final String[] extensions) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (String ext : extensions) {
                    if (!GUIUtil.getExtension(f).equalsIgnoreCase(ext)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                ArrayList<String> extensionStrings = new ArrayList<String>();
                for (String ext : extensions) {
                    extensionStrings.add("*." + ext);
                }
                return description + " (" + StringUtil.replaceAll(StringUtil.toCommaDelimitedString(extensionStrings), ",", ";") + ")";
            }
        };
    }

    public static Color toSimulatedTransparency(Color color) {
        return new Color(color.getRed() + (int)((double)((255 - color.getRed()) * (255 - color.getAlpha())) / 255.0), color.getGreen() + (int)((double)((255 - color.getGreen()) * (255 - color.getAlpha())) / 255.0), color.getBlue() + (int)((double)((255 - color.getBlue()) * (255 - color.getAlpha())) / 255.0));
    }

    public static String truncateString(String s, int maxLength) {
        if (s.length() < maxLength) {
            return s;
        }
        return s.substring(0, maxLength - 3) + "...";
    }

    public static Point2D subtract(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static Point2D add(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Point2D multiply(Point2D v, double x) {
        return new Point2D.Double(v.getX() * x, v.getY() * x);
    }

    public static Transferable getContents(Clipboard clipboard) {
        try {
            return clipboard.getContents(null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static double trueAscent(TextLayout layout) {
        return -layout.getBounds().getY();
    }

    public static Image toImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static ImageIcon toImageIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return new ImageIcon(GUIUtil.toImage(icon));
    }

    public static ImageIcon fromColor(Color color, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics g = img.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        return new ImageIcon(img);
    }

    public static ImageIcon resize(ImageIcon icon, int extent_xy) {
        return GUIUtil.resize(icon, extent_xy, extent_xy);
    }

    public static ImageIcon resize(ImageIcon icon, int extent_x, int extent_y) {
        return new ImageIcon(GUIUtil.resize(icon.getImage(), extent_x, extent_y));
    }

    public static Image resize(Image image, int extent_x, int extent_y) {
        return image.getScaledInstance(extent_x, extent_y, 16);
    }

    public static ImageIcon toSmallIcon(ImageIcon icon) {
        return GUIUtil.resize(icon, 16);
    }

    public static ImageIcon toSmallIcon(ImageIcon icon, int width) {
        return GUIUtil.resize(icon, width);
    }

    public static ImageIcon pad(ImageIcon icon, int border) {
        return GUIUtil.pad(icon, border, border, border, border);
    }

    public static ImageIcon pad(ImageIcon icon, int top, int left, int bottom, int right) {
        BufferedImage padded = new BufferedImage(icon.getIconWidth() + left + right, icon.getIconHeight() + top + bottom, 2);
        Graphics2D g = padded.createGraphics();
        g.drawImage(icon.getImage(), left, top, null);
        return new ImageIcon(padded);
    }

    public static ImageIcon toGrayScale(ImageIcon icon) {
        BufferedImage gray = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        BufferedImage orig = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = orig.getGraphics();
        g.drawImage(icon.getImage(), 0, 0, null);
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(orig, gray);
        return new ImageIcon(gray);
    }

    public static ImageIcon overlay(ImageIcon icon, ImageIcon overlay, int x, int y) {
        return GUIUtil.overlay(icon, overlay, x, y, 1.0f, null);
    }

    public static ImageIcon overlay(ImageIcon image, ImageIcon overlay, int x, int y, float alpha, Image mask) {
        Image overlay_image;
        if (mask != null) {
            BufferedImage masked = new BufferedImage(overlay.getIconWidth(), overlay.getIconHeight(), 2);
            Graphics2D g2 = masked.createGraphics();
            g2.drawImage(overlay.getImage(), 0, 0, null);
            AlphaComposite ac = AlphaComposite.getInstance(6, 1.0f);
            g2.setComposite(ac);
            g2.drawImage(GUIUtil.transformGrayToTransparency(mask), 0, 0, null);
            g2.dispose();
            overlay_image = masked;
        } else {
            overlay_image = overlay.getImage();
        }
        BufferedImage combined = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage(image.getImage(), 0, 0, null);
        AlphaComposite ac2 = AlphaComposite.getInstance(3, alpha);
        g.setComposite(ac2);
        g.drawImage(overlay_image, x, y, null);
        return new ImageIcon(combined);
    }

    private static Image transformGrayToTransparency(Image image) {
        if (image == null) {
            return image;
        }
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                return rgb << 8 & 0xFF000000;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static int swingThreadPriority() {
        final Int i = new Int();
        try {
            GUIUtil.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    i.i = Thread.currentThread().getPriority();
                }
            });
        }
        catch (InvocationTargetException e) {
            Assert.shouldNeverReachHere();
        }
        catch (InterruptedException e) {
            Assert.shouldNeverReachHere();
        }
        return i.i;
    }

    public static void fixClicks(final Component c) {
        c.addMouseListener(new MouseListener(){
            private ArrayList events = new ArrayList();

            @Override
            public void mousePressed(MouseEvent e) {
                this.add(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.add(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.add(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.add(e);
            }

            private MouseEvent event(int i) {
                return (MouseEvent)this.events.get(i);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.add(e);
                if (this.events.size() == 4 && this.event(0).getID() == 501 && this.event(1).getID() == 505 && this.event(2).getID() == 504) {
                    c.dispatchEvent(new MouseEvent(c, 500, System.currentTimeMillis(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger()));
                }
            }

            private void add(MouseEvent e) {
                if (this.events.size() == 4) {
                    this.events.remove(0);
                }
                this.events.add(e);
            }
        });
    }

    public static void addInternalFrameListener(JDesktopPane pane, final InternalFrameListener listener) {
        JInternalFrame[] frames;
        for (JInternalFrame frame : frames = pane.getAllFrames()) {
            frame.addInternalFrameListener(listener);
        }
        pane.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JInternalFrame) {
                    ((JInternalFrame)e.getChild()).removeInternalFrameListener(listener);
                    ((JInternalFrame)e.getChild()).addInternalFrameListener(listener);
                }
            }
        });
    }

    public static DocumentListener toDocumentListener(final ActionListener listener) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }
        };
    }

    public static ListDataListener toListDataListener(final ActionListener listener) {
        return new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), 0, e.toString()));
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), 0, e.toString()));
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                listener.actionPerformed(null);
            }
        };
    }

    public static InternalFrameListener toInternalFrameListener(final ActionListener listener) {
        return new InternalFrameListener(){

            private void fireActionPerformed(InternalFrameEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.toString()));
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }
        };
    }

    public static Timer createRestartableSingleEventTimer(int delay, ActionListener listener) {
        Timer timer = new Timer(delay, listener);
        timer.setCoalesce(true);
        timer.setInitialDelay(delay);
        timer.setRepeats(false);
        return timer;
    }

    public static ValidatingTextField createSyncdTextField(JSlider s) {
        int columns = (int)Math.ceil(Math.log(s.getMaximum()) / Math.log(10.0));
        return GUIUtil.createSyncdTextField(s, columns);
    }

    public static ValidatingTextField createSyncdTextField(JSlider s, int columns) {
        ValidatingTextField t = new ValidatingTextField(s.getValue() + "", columns, 4, ValidatingTextField.INTEGER_VALIDATOR, new ValidatingTextField.CompositeCleaner(new ValidatingTextField.Cleaner[]{new ValidatingTextField.BlankCleaner("" + s.getMinimum()), new ValidatingTextField.MinIntCleaner(s.getMinimum()), new ValidatingTextField.MaxIntCleaner(s.getMaximum())}));
        GUIUtil.sync(s, t);
        GUIUtil.syncEnabledStates(s, t);
        return t;
    }

    public static void sync(final JSlider s, final ValidatingTextField t) {
        t.setText("" + s.getValue());
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        s.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    t.setText("" + s.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        t.getDocument().addDocumentListener(new DocumentListener(){

            private void changed() {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s.setValue(t.getInteger());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }
        });
    }

    public static void syncEnabledStates(final JComponent c1, final JComponent c2) {
        c2.setEnabled(c1.isEnabled());
        c1.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (c1.isEnabled() == c2.isEnabled()) {
                    return;
                }
                c2.setEnabled(c1.isEnabled());
            }
        });
        c2.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (c1.isEnabled() == c2.isEnabled()) {
                    return;
                }
                c1.setEnabled(c2.isEnabled());
            }
        });
    }

    public static void sync(final JSlider s1, final JSlider s2) {
        s2.setValue(s1.getValue());
        Assert.isTrue((s1.getMinimum() == s2.getMinimum() ? 1 : 0) != 0);
        Assert.isTrue((s1.getMaximum() == s2.getMaximum() ? 1 : 0) != 0);
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        s1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s2.setValue(s1.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        s2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s1.setValue(s2.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
    }

    public static void sync(final JCheckBox c1, final JCheckBox c2) {
        c2.setSelected(c1.isSelected());
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        c1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    c2.setSelected(c1.isSelected());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        c2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    c1.setSelected(c2.isSelected());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
    }

    public static List items(JComboBox comboBox) {
        ArrayList items = new ArrayList();
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            items.add(comboBox.getItemAt(i));
        }
        return items;
    }

    public static void setSelectedWithClick(JCheckBox checkBox, boolean selected) {
        checkBox.setSelected(!selected);
        checkBox.doClick();
    }

    public static void setLocation(Component componentToMove, Location location, Component other) {
        GUIUtil.setBounds(componentToMove, location, componentToMove.getWidth(), componentToMove.getHeight(), other);
    }

    public static void setBounds(Component componentToMove, Location location, int width, int height, Component other) {
        Point p = new Point((int)other.getLocationOnScreen().getX() + (location.fromRight ? other.getWidth() - componentToMove.getWidth() - location.x : location.x), (int)other.getLocationOnScreen().getY() + (location.fromBottom ? other.getHeight() - componentToMove.getHeight() - location.y : location.y));
        if (!(componentToMove instanceof Window)) {
            SwingUtilities.convertPointFromScreen(p, other);
        }
        componentToMove.setBounds(p.x, p.y, width, height);
    }

    public static void highlightForDebugging(JComponent component, Color color) {
        component.setBackground(color);
        component.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, color));
    }

    public static Component topCard(Container c) {
        Component[] components;
        Assert.isTrue((boolean)(c.getLayout() instanceof CardLayout));
        for (Component component : components = c.getComponents()) {
            if (!component.isVisible()) continue;
            return component;
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public static File[] selectedFiles(JFileChooser chooser) {
        File[] fileArray;
        if (chooser.getSelectedFiles().length == 0 && chooser.getSelectedFile() != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = chooser.getSelectedFile();
        } else {
            fileArray = chooser.getSelectedFiles();
        }
        return fileArray;
    }

    public static ImageIcon toDisabledIcon(ImageIcon icon) {
        return new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
    }

    public static Component getDescendantOfClass(Class c, Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component descendant;
            if (c.isInstance(container.getComponent(i))) {
                return container.getComponent(i);
            }
            if (!(container.getComponent(i) instanceof Container) || (descendant = GUIUtil.getDescendantOfClass(c, (Container)container.getComponent(i))) == null) continue;
            return descendant;
        }
        return null;
    }

    public static void dispose(JInternalFrame internalFrame, JDesktopPane desktopPane) {
        desktopPane.getDesktopManager().closeFrame(internalFrame);
        internalFrame.dispose();
    }

    public static Cursor createCursorFromIcon(Image iconImage) {
        ImageIcon icon = new ImageIcon(iconImage.getScaledInstance(12, 12, 8));
        ImageIcon basicCursor = IconLoader.icon("basic-cursor.png");
        BufferedImage image = new BufferedImage(basicCursor.getIconWidth(), basicCursor.getIconHeight(), 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(basicCursor.getImage(), 0, 0, null);
        graphics.drawImage(icon.getImage(), 10, 10, null);
        return GUIUtil.createCursor(image, new Point(0, 15), null);
    }

    public static Cursor createCursorOld(Image image, Point hotSpot) {
        if (null == image) {
            return Cursor.getDefaultCursor();
        }
        if (Toolkit.getDefaultToolkit().getBestCursorSize(32, 32).equals(new Dimension(0, 0))) {
            return Cursor.getDefaultCursor();
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(image, hotSpot, I18N.getInstance().get("ui.GUIUtil.jump-workbench-custom-cursor"));
    }

    public static Cursor createCursor(Image cursorImage, Point hotSpot, String name) {
        Dimension bestCursorSize;
        Dimension curCursorSize;
        if (Toolkit.getDefaultToolkit().getBestCursorSize(32, 32).equals(new Dimension(0, 0))) {
            return Cursor.getDefaultCursor();
        }
        if (null == cursorImage) {
            Logger.error("cannot create a custom cursor from NuLL image");
            return Cursor.getDefaultCursor();
        }
        if (null == hotSpot) {
            Logger.debug("apply default hotspot Point(0,0)");
            hotSpot = new Point(0, 0);
        }
        if (name == null) {
            name = I18N.getInstance().get("ui.GUIUtil.jump-workbench-custom-cursor");
        }
        if (!(curCursorSize = new Dimension(cursorImage.getWidth(null), cursorImage.getHeight(null))).equals(bestCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(curCursorSize.width, curCursorSize.height))) {
            cursorImage = GUIUtil.resize(cursorImage, bestCursorSize.width, bestCursorSize.height);
            double hotSpot_x = (double)hotSpot.x * ((double)bestCursorSize.width / curCursorSize.getWidth());
            double hotSpot_y = (double)hotSpot.y * ((double)bestCursorSize.height / curCursorSize.getHeight());
            hotSpot = new Point((int)Math.round(hotSpot_x), (int)Math.round(hotSpot_y));
            Logger.trace("Cursor resized to " + cursorImage.getWidth(null) + "/" + cursorImage.getHeight(null));
            Logger.trace("Hotspot now " + hotSpot);
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, hotSpot, name);
    }

    public static JTextArea makeTabMoveFocus(JTextArea textArea) {
        textArea.setFocusTraversalKeys(0, new HashSet<KeyStroke>(Collections.singleton(KeyStroke.getKeyStroke("TAB"))));
        textArea.setFocusTraversalKeys(1, new HashSet<KeyStroke>(Collections.singleton(KeyStroke.getKeyStroke("shift TAB"))));
        return textArea;
    }

    public static void shrinkFont(JComponent component) {
        component.setFont(component.getFont().deriveFont((float)component.getFont().getSize() - 2.0f));
    }

    public static GraphicsDevice getDefaultScreenDevice() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getDefaultScreenDevice();
    }

    private static boolean isWindowTranslucencySupported(int type) {
        boolean supported = false;
        try {
            GraphicsDevice.WindowTranslucency[] kinds = new GraphicsDevice.WindowTranslucency[]{GraphicsDevice.WindowTranslucency.TRANSLUCENT, GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT, GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT};
            supported = GUIUtil.getDefaultScreenDevice().isWindowTranslucencySupported(kinds[type]);
        }
        catch (Exception exception) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IllegalAccessError illegalAccessError) {
            // empty catch block
        }
        return supported;
    }

    public static boolean isUniformTranslucencySupported() {
        return GUIUtil.isWindowTranslucencySupported(0);
    }

    public static boolean isPerPixelTranslucencySupported() {
        return GUIUtil.isWindowTranslucencySupported(1);
    }

    public static boolean isShapedWindowSupported() {
        return GUIUtil.isWindowTranslucencySupported(2);
    }

    public static class Location {
        public int x;
        public int y;
        public boolean fromRight;
        public boolean fromBottom;

        public Location(int x, boolean fromRight, int y, boolean fromBottom) {
            this.x = x;
            this.y = y;
            this.fromRight = fromRight;
            this.fromBottom = fromBottom;
        }
    }

    private static class Int {
        public volatile int i;

        private Int() {
        }
    }

    public static class FileChooserWithOverwritePrompting
    extends JFCWithEnterAction {
        private String ext;

        public FileChooserWithOverwritePrompting(String ext) {
            this.ext = ext;
        }

        public FileChooserWithOverwritePrompting() {
        }

        @Override
        public void approveSelection() {
            File[] files = GUIUtil.selectedFiles(this);
            if (files.length != 1) {
                return;
            }
            File file = files[0];
            if (file.exists() && !file.isFile()) {
                return;
            }
            if (this.ext != null && !file.toString().toLowerCase().endsWith(this.ext.toLowerCase())) {
                file = new File(file.toString() + "." + this.ext);
            }
            if (file.exists() && !GUIUtil.showConfirmOverwriteDialog(this, file)) {
                return;
            }
            super.approveSelection();
        }

        @Deprecated
        protected File selectedFile() {
            return this.getSelectedFile();
        }
    }
}

