/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.util.Assert;

public class EditTransaction {
    private final Set<Feature> features;
    private final Map<Integer, Geometry> originalGeometries;
    private final Map<Integer, Geometry> proposedGeometries;
    private final Layer layer;
    private final String name;
    private final boolean rollingBackInvalidEdits;
    public static final String ROLLING_BACK_INVALID_EDITS_KEY = EditTransaction.class.getName() + " - ROLLING_BACK_INVALID_EDITS";
    public static final Geometry EMPTY_GEOMETRY = new GeometryFactory().createGeometryCollection(new Geometry[0]);
    private final LayerViewPanelContext layerViewPanelContext;
    private final GeometryEditor editor = new GeometryEditor();
    private boolean allowAddingAndRemovingFeatures;

    public EditTransaction(Collection<Feature> features, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures, LayerViewPanel layerViewPanel) {
        this(features, name, layer, rollingBackInvalidEdits, allowAddingAndRemovingFeatures, layerViewPanel.getContext());
    }

    public EditTransaction(Collection<Feature> features, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures, LayerViewPanelContext layerViewPanelContext) {
        this.layerViewPanelContext = layerViewPanelContext;
        this.layer = layer;
        this.rollingBackInvalidEdits = rollingBackInvalidEdits;
        this.allowAddingAndRemovingFeatures = allowAddingAndRemovingFeatures;
        this.name = name;
        this.features = new LinkedHashSet<Feature>(features);
        this.originalGeometries = this.geometryClones(features);
        this.proposedGeometries = this.geometryClones(features);
    }

    public static EditTransaction createTransactionOnSelection(SelectionEditor editor, SelectionManagerProxy selectionManagerProxy, LayerViewPanelContext layerViewPanelContext, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures) {
        Map<Feature, Geometry> featureToNewGeometryMap = EditTransaction.featureToNewGeometryMap(editor, selectionManagerProxy, layer);
        EditTransaction transaction = new EditTransaction(featureToNewGeometryMap.keySet(), name, layer, rollingBackInvalidEdits, allowAddingAndRemovingFeatures, layerViewPanelContext);
        transaction.setGeometries(featureToNewGeometryMap);
        return transaction;
    }

    public static Map<Feature, Geometry> featureToNewGeometryMap(SelectionEditor editor, SelectionManagerProxy selectionManagerProxy, Layer layer) {
        LinkedHashMap<Feature, Geometry> featureToNewGeometryMap = new LinkedHashMap<Feature, Geometry>();
        SelectionManager selectionManager = selectionManagerProxy.getSelectionManager();
        for (Feature feature : selectionManager.getFeaturesWithSelectedItems(layer)) {
            Geometry newGeometry = feature.getGeometry().copy();
            ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
            for (AbstractSelection selection : selectionManager.getSelections()) {
                selectedItems.addAll(selection.items(newGeometry, selection.getSelectedItemIndices(layer, feature)));
            }
            newGeometry = editor.edit(newGeometry, selectedItems);
            featureToNewGeometryMap.put(feature, newGeometry);
        }
        return featureToNewGeometryMap;
    }

    public Geometry getGeometry(int i) {
        Feature f = (Feature)this.features.toArray()[i];
        return this.proposedGeometries.get(f.getID());
    }

    public Geometry getGeometry(Feature feature) {
        return this.proposedGeometries.get(feature.getID());
    }

    public void setGeometry(Feature feature, Geometry geometry) {
        this.proposedGeometries.put(feature.getID(), geometry);
    }

    public void setGeometries(Map<Feature, Geometry> featureToGeometryMap) {
        for (Feature feature : featureToGeometryMap.keySet()) {
            this.proposedGeometries.put(feature.getID(), this.editor.removeRepeatedPoints(featureToGeometryMap.get(feature)));
        }
    }

    public void setGeometry(int i, Geometry geometry) {
        Feature f = (Feature)this.features.toArray()[i];
        this.proposedGeometries.put(f.getID(), this.editor.removeRepeatedPoints(geometry));
    }

    public boolean commit() {
        return EditTransaction.commit(Collections.singleton(this));
    }

    public static boolean commit(Collection<EditTransaction> editTransactions) {
        return EditTransaction.commit(editTransactions, new SuccessAction(){

            @Override
            public void run() {
            }
        });
    }

    public static boolean commit(Collection<EditTransaction> editTransactions, SuccessAction successAction) {
        if (editTransactions.isEmpty()) {
            return true;
        }
        final ArrayList<UndoableCommand> commands = new ArrayList<UndoableCommand>();
        for (EditTransaction editTransaction : editTransactions) {
            editTransaction.clearEnvelopeCaches();
            if (!editTransaction.proposedGeometriesValid()) {
                if (editTransaction.rollingBackInvalidEdits) {
                    editTransaction.layerViewPanelContext.warnUser(I18N.getInstance().get("ui.EditTransaction.the-geometry-is-invalid-cancelled"));
                    return false;
                }
                editTransaction.layerViewPanelContext.warnUser(I18N.getInstance().get("ui.EditTransaction.the-new-geometry-is-invalid"));
            }
            commands.add(editTransaction.createCommand());
        }
        successAction.run();
        UndoableCommand command = new UndoableCommand(((UndoableCommand)commands.iterator().next()).getName()){

            @Override
            public void execute() {
                for (UndoableCommand subCommand : commands) {
                    if (subCommand.isCanceled()) continue;
                    subCommand.execute();
                }
            }

            @Override
            public void unexecute() {
                for (UndoableCommand subCommand : commands) {
                    if (subCommand.isCanceled()) continue;
                    subCommand.unexecute();
                }
            }
        };
        command.execute();
        editTransactions.iterator().next().layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        return true;
    }

    public boolean commit(SuccessAction successAction) {
        return EditTransaction.commit(Collections.singleton(this), successAction);
    }

    public void clearEnvelopeCaches() {
        for (Geometry proposedGeometry : this.proposedGeometries.values()) {
            proposedGeometry.geometryChanged();
        }
    }

    public boolean proposedGeometriesValid() {
        for (Geometry proposedGeometry : this.proposedGeometries.values()) {
            if (proposedGeometry.isValid()) continue;
            return false;
        }
        return true;
    }

    protected UndoableCommand createCommand() {
        UndoableCommand command = new UndoableCommand(this.name, this.layer){

            @Override
            public void dispose() {
                super.dispose();
                EditTransaction.this.features.clear();
                EditTransaction.this.proposedGeometries.clear();
                EditTransaction.this.originalGeometries.clear();
            }

            @Override
            public void execute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.proposedGeometries, EditTransaction.this.originalGeometries, EditTransaction.this.layer);
            }

            @Override
            public void unexecute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.originalGeometries, EditTransaction.this.proposedGeometries, EditTransaction.this.layer);
            }
        };
        return command;
    }

    private Map<Integer, Geometry> geometryClones(Collection<Feature> features) {
        LinkedHashMap<Integer, Geometry> geometryClones = new LinkedHashMap<Integer, Geometry>();
        for (Feature feature : features) {
            geometryClones.put(feature.getID(), feature.getGeometry().copy());
        }
        return geometryClones;
    }

    private void changeGeometries(Map<Integer, Geometry> newGeometries, Map<Integer, Geometry> oldGeometries, Layer layer) {
        ArrayList<Feature> modifiedFeatures = new ArrayList<Feature>();
        ArrayList<Feature> modifiedFeaturesOldClones = new ArrayList<Feature>();
        ArrayList<Feature> featuresToAdd = new ArrayList<Feature>();
        ArrayList<Feature> featuresToRemove = new ArrayList<Feature>();
        for (Feature feature : this.features) {
            Geometry oldGeometry = oldGeometries.get(feature.getID());
            Geometry newGeometry = newGeometries.get(feature.getID());
            if (this.allowAddingAndRemovingFeatures && oldGeometry.isEmpty() && !newGeometry.isEmpty()) {
                featuresToAdd.add(feature);
                continue;
            }
            if (this.allowAddingAndRemovingFeatures && newGeometry.isEmpty()) {
                featuresToRemove.add(feature);
                continue;
            }
            modifiedFeatures.add(feature);
            modifiedFeaturesOldClones.add(feature.clone(true, true));
            feature.setGeometry(newGeometry);
        }
        Layer.tryToInvalidateEnvelope(layer);
        if (!featuresToRemove.isEmpty()) {
            layer.getFeatureCollectionWrapper().removeAll(featuresToRemove);
        }
        if (!featuresToAdd.isEmpty()) {
            layer.getFeatureCollectionWrapper().addAll(featuresToAdd);
        }
        if (!modifiedFeatures.isEmpty()) {
            layer.getLayerManager().fireGeometryModified(modifiedFeatures, layer, modifiedFeaturesOldClones);
        }
    }

    public int size() {
        return this.features.size();
    }

    public Feature getFeature(int i) {
        return (Feature)this.features.toArray()[i];
    }

    public Collection<Feature> getFeatures() {
        return Collections.unmodifiableSet(this.features);
    }

    public void createFeature(Feature feature) {
        Assert.isTrue((boolean)this.allowAddingAndRemovingFeatures);
        this.features.add(feature);
        this.originalGeometries.put(feature.getID(), EMPTY_GEOMETRY);
        this.proposedGeometries.put(feature.getID(), feature.getGeometry());
    }

    public void deleteFeature(Feature feature) {
        Assert.isTrue((boolean)this.allowAddingAndRemovingFeatures);
        this.features.add(feature);
        this.originalGeometries.put(feature.getID(), feature.getGeometry());
        this.proposedGeometries.put(feature.getID(), EMPTY_GEOMETRY);
    }

    public void modifyFeatureGeometry(Feature feature, Geometry newGeometry) {
        if (newGeometry == null || newGeometry.isEmpty()) {
            if (this.allowAddingAndRemovingFeatures) {
                this.features.add(feature);
                this.originalGeometries.put(feature.getID(), feature.getGeometry());
                this.proposedGeometries.put(feature.getID(), EMPTY_GEOMETRY);
            }
        } else {
            this.features.add(feature);
            this.originalGeometries.put(feature.getID(), feature.getGeometry());
            this.proposedGeometries.put(feature.getID(), newGeometry);
        }
    }

    public Layer getLayer() {
        return this.layer;
    }

    public static int emptyGeometryCount(Collection<EditTransaction> transactions) {
        int count = 0;
        for (EditTransaction transaction : transactions) {
            count += transaction.getEmptyGeometryCount();
        }
        return count;
    }

    private int getEmptyGeometryCount() {
        int count = 0;
        for (Feature feature : this.features) {
            Geometry geometry = feature.getGeometry();
            if (!geometry.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static interface SuccessAction {
        public void run();
    }

    public static interface SelectionEditor {
        public Geometry edit(Geometry var1, Collection<Geometry> var2);
    }
}

