/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class PlugInClassLoader
extends URLClassLoader {
    public PlugInClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        if (parent instanceof URLClassLoader) {
            this.addUrls(((URLClassLoader)parent).getURLs());
        } else {
            ArrayList<URL> ucp = new ArrayList<URL>();
            String cp = System.getProperty("java.class.path", "");
            PlugInClassLoader.addClassPathToUCP(cp, ucp);
            this.addUrls(ucp.toArray(new URL[0]));
        }
    }

    public PlugInClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.getParent().getParent().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null && !name.equals("com.vividsolutions.jump.workbench.plugin.PlugInClassLoader")) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null && name.equals("com.vividsolutions.jump.workbench.plugin.PlugInClassLoader")) {
            try {
                c = this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        if (name.startsWith("/")) {
            name = name.replaceAll("^/+", "");
        }
        return super.getResource(name);
    }

    public void addUrls(URL[] urls) {
        for (URL url : urls) {
            this.addURL(url);
        }
    }

    private static void addClassPathToUCP(String cp, List<URL> ucp) {
        URL url;
        int next;
        int off = 0;
        while ((next = cp.indexOf(File.pathSeparator, off)) != -1) {
            url = PlugInClassLoader.toFileURL(cp.substring(off, next));
            if (url != null) {
                ucp.add(url);
            }
            off = next + 1;
        }
        url = PlugInClassLoader.toFileURL(cp.substring(off));
        if (url != null) {
            ucp.add(url);
        }
    }

    private static URL toFileURL(String s) {
        try {
            return Paths.get(s, new String[0]).toRealPath(new LinkOption[0]).toUri().toURL();
        }
        catch (IOException | InvalidPathException ignore) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ignore.printStackTrace(pw);
            String stack = sw.toString();
            int index = stack.indexOf("\n");
            System.err.println("Problem adding classpath entry '" + s + "': " + stack.substring(0, index > 0 ? index : stack.length()));
            return null;
        }
    }

    private void appendToClassPathForInstrumentation(String path) {
        assert (Thread.holdsLock(this));
        super.addURL(PlugInClassLoader.getFileURL(new File(path)));
    }

    private static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new InternalError();
        }
    }
}

