/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableChecked;
import com.vividsolutions.jump.workbench.plugin.Iconified;
import com.vividsolutions.jump.workbench.plugin.Macro;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.Recordable;
import com.vividsolutions.jump.workbench.plugin.ShortcutEnabled;
import com.vividsolutions.jump.workbench.plugin.StartMacroPlugIn;
import com.vividsolutions.jump.workbench.plugin.StopMacroPlugIn;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoableEdit;

public abstract class AbstractPlugIn
implements PlugIn,
ShortcutEnabled,
EnableChecked,
Iconified,
Recordable {
    protected int shortcutModifiers = 0;
    protected int shortcutKeys = 0;
    private String name;
    private Map<String, Object> parameters;
    private PlugInContext context = null;

    public void addParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(name, value);
    }

    public Object getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    public Boolean getBooleanParam(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (Boolean)this.parameters.get(name);
    }

    public Integer getIntegerParam(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (Integer)this.parameters.get(name);
    }

    public Double getDoubleParam(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (Double)this.parameters.get(name);
    }

    public String getStringParam(String name) {
        if (this.parameters == null) {
            return null;
        }
        return (String)this.parameters.get(name);
    }

    @Override
    public void setParameters(Map<String, Object> map) {
        this.parameters = map;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    protected void execute(UndoableCommand command, PlugInContext context) {
        AbstractPlugIn.execute(command, context.getLayerViewPanel());
    }

    public AbstractPlugIn() {
    }

    public AbstractPlugIn(String name) {
        this.name = name;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.context = context;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    protected void reportNothingToUndoYet(PlugInContext context) {
        if (context.getLayerManager() == null) {
            return;
        }
        context.getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
    }

    protected boolean isRollingBackInvalidEdits(PlugInContext context) {
        return PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    @Override
    public boolean isShortcutEnabled() {
        return this.shortcutKeys > 0;
    }

    @Override
    public final int getShortcutModifiers() {
        return this.shortcutModifiers;
    }

    @Override
    public void setShortcutModifiers(int shortcutModifiers) {
        this.shortcutModifiers = shortcutModifiers;
    }

    @Override
    public final int getShortcutKeys() {
        return this.shortcutKeys;
    }

    @Override
    public void setShortcutKeys(int shortcutKeys) {
        this.shortcutKeys = shortcutKeys;
    }

    @Override
    public KeyStroke getShortcutKeyStroke() {
        return this.getShortcutKeys() > 0 ? KeyStroke.getKeyStroke(this.getShortcutKeys(), this.getShortcutModifiers()) : null;
    }

    @Override
    public EnableCheck getEnableCheck() {
        try {
            Method m = null;
            Class<?> c = this.getClass();
            do {
                try {
                    m = c.getDeclaredMethod("createEnableCheck", WorkbenchContext.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            } while (m == null && (c = c.getSuperclass()) != null);
            if (m != null) {
                m.setAccessible(true);
                PlugInContext pc = this.getContext();
                if (pc == null) {
                    throw new IllegalArgumentException(this.getName());
                }
                return (EnableCheck)m.invoke((Object)this, pc.getWorkbenchContext());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            Logger.error(e);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        Icon icon = null;
        Class<?> c = this.getClass();
        try {
            Field f = c.getDeclaredField("ICON");
            if (Icon.class.isAssignableFrom(f.getType())) {
                icon = (Icon)f.get(this);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return icon;
    }

    @Override
    public Icon getIcon(int height) {
        return this.getIcon(new Dimension(height, height));
    }

    @Override
    public Icon getIcon(Dimension dim) {
        Icon icon = this.getIcon();
        if (icon instanceof ImageIcon && dim != null && icon.getIconHeight() != dim.height) {
            icon = GUIUtil.resize((ImageIcon)icon, dim.height);
        }
        return icon;
    }

    @Override
    public String getName() {
        return this.name == null ? AbstractPlugIn.createName(this.getClass()) : this.name;
    }

    public String toString() {
        return this.getName();
    }

    public static String createName(Class<? extends PlugIn> plugInClass) {
        try {
            return I18N.getInstance().get(plugInClass.getName());
        }
        catch (MissingResourceException e) {
            Logger.error(e.getMessage() + " " + plugInClass.getName());
            return StringUtil.toFriendlyName(plugInClass.getName(), "PlugIn");
        }
    }

    public static ActionListener toActionListener(final PlugIn plugIn, final WorkbenchContext workbenchContext, final TaskMonitorManager taskMonitorManager) {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UndoableEditReceiver undoableEditReceiver;
                    if (workbenchContext.getWorkbench() != null) {
                        workbenchContext.getWorkbench().getFrame().setStatusMessage("");
                        Logger.info(I18N.getInstance().get("plugin.AbstractPlugIn.executing") + " " + plugIn.getName());
                    }
                    PlugInContext plugInContext = workbenchContext.createPlugInContext();
                    UndoableEditReceiver undoableEditReceiver2 = undoableEditReceiver = workbenchContext.getLayerManager() != null ? workbenchContext.getLayerManager().getUndoableEditReceiver() : null;
                    if (undoableEditReceiver != null) {
                        undoableEditReceiver.startReceiving();
                    }
                    try {
                        boolean executeComplete = plugIn.execute(plugInContext);
                        if (workbenchContext.getBlackboard().get("MacroStarted", false) && !(plugIn instanceof StartMacroPlugIn) && !(plugIn instanceof StopMacroPlugIn)) {
                            ((Macro)workbenchContext.getBlackboard().get("Macro")).addProcess((Recordable)((Object)plugIn));
                        }
                        if (plugIn instanceof ThreadedPlugIn && executeComplete) {
                            taskMonitorManager.execute((ThreadedPlugIn)plugIn, plugInContext);
                        }
                    }
                    finally {
                        if (undoableEditReceiver != null) {
                            undoableEditReceiver.stopReceiving();
                        }
                    }
                    Logger.info(I18N.getInstance().get("plugin.AbstractPlugIn.done-current-committed-memory") + workbenchContext.getWorkbench().getFrame().getMBCommittedMemory() + " MB");
                }
                catch (Throwable t) {
                    workbenchContext.getErrorHandler().handleThrowable(t);
                }
            }
        };
    }

    public static void execute(final UndoableCommand command, LayerManagerProxy layerManagerProxy) {
        LayerManager layerManager;
        boolean exceptionOccurred = true;
        try {
            command.execute();
            exceptionOccurred = false;
        }
        finally {
            if (exceptionOccurred) {
                layerManagerProxy.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
            }
        }
        final UndoableEdit undoableEdit = command.toUndoableEdit();
        if (command.getLayer() != null && (layerManager = command.getLayer().getLayerManager()) != null) {
            LayerListener listener = new LayerListener(){

                @Override
                public void categoryChanged(CategoryEvent e) {
                }

                @Override
                public void featuresChanged(FeatureEvent e) {
                }

                @Override
                public void layerChanged(LayerEvent e) {
                    if (e.getType() == LayerEventType.REMOVED && e.getLayerable() == command.getLayer()) {
                        undoableEdit.die();
                        layerManager.removeLayerListener(this);
                    }
                }
            };
            layerManager.addLayerListener(listener);
        }
        layerManagerProxy.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
    }

    protected PlugInContext getContext() {
        if (this.context == null) {
            throw new RuntimeException("Add super.initialize() to your AbstractPlugIn.initialize() implementation!\n" + this.getClass().getName());
        }
        return this.context;
    }

    protected WorkbenchContext getWorkbenchContext() {
        return this.getContext().getWorkbenchContext();
    }
}

