/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.GeoReferencedLayerable;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.MapRequest;
import com.vividsolutions.wms.MapStyle;
import com.vividsolutions.wms.WMService;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ccordsys.utils.SRSInfo;

public class WMSLayer
extends GeoReferencedLayerable
implements Cloneable {
    private WMService service;
    private String wmsVersion = "1.3.0";
    private List<String> layerNames = new ArrayList<String>();
    private String srs;
    private String format;
    private MapStyle style;
    private String moreParameters;
    private String apiKeyNameAndValue;
    private int alpha = 255;
    private Reference oldImage;
    private URL oldURL;
    private final Blackboard blackboard = new Blackboard();
    private String serverURL;

    public WMSLayer() {
        this.init();
    }

    public WMSLayer(LayerManager layerManager, String serverURL, String srs, List<String> layerNames, String format, String version) throws IOException {
        this(layerManager, WMSLayer.initializedService(serverURL, version, null), srs, layerNames, format);
    }

    private static WMService initializedService(String serverURL, String version, String apiKeyNameAndValue) throws IOException {
        WMService initializedService = new WMService(serverURL, version, apiKeyNameAndValue, true);
        initializedService.initialize();
        return initializedService;
    }

    public WMSLayer(LayerManager layerManager, WMService initializedService, String srs, List<String> layerNames, String format) throws IOException {
        this(layerManager, initializedService, srs, layerNames, format, initializedService.getVersion());
    }

    public WMSLayer(String title, LayerManager layerManager, WMService initializedService, String srs, List<String> layerNames, String format) throws IOException {
        this(title, layerManager, initializedService, srs, layerNames, format, initializedService.getVersion());
    }

    public WMSLayer(String title, LayerManager layerManager, WMService initializedService, String srs, List<String> layerNames, String format, String version) {
        super(title, layerManager);
        this.setService(initializedService);
        this.setSRS(srs);
        this.setLayerNames(layerNames);
        this.setFormat(format);
        this.setWmsVersion(version);
        this.init();
    }

    public WMSLayer(LayerManager layerManager, WMService initializedService, String srs, List<String> layerNames, String format, String version) {
        this(layerNames.get(0), layerManager, initializedService, srs, layerNames, format, version);
    }

    protected void init() {
        this.getBlackboard().put(RenderingManager.USE_MULTI_RENDERING_THREAD_QUEUE_KEY, true);
        this.getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
    }

    public void setService(WMService service) {
        this.service = service;
        this.serverURL = service.getServerUrl();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public Image createImage(LayerViewPanel panel) throws IOException {
        Image image;
        MapRequest request = this.createRequest(panel);
        URL newURL = request.getURL();
        if (!newURL.equals(this.oldURL) || this.oldImage == null || (image = (Image)this.oldImage.get()) == null) {
            image = request.getImage();
            MediaTracker mt = new MediaTracker(new JButton());
            mt.addImage(image, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException e) {
                Assert.shouldNeverReachHere();
            }
            this.oldImage = new SoftReference<Image>(image);
            this.oldURL = newURL;
        }
        return image;
    }

    private BoundingBox toBoundingBox(String srs, Envelope e) {
        return new BoundingBox(srs, e);
    }

    public MapRequest createRequest(LayerViewPanel panel) throws IOException {
        MapRequest request = this.getService().createMapRequest();
        request.setBoundingBox(this.toBoundingBox(this.srs, panel.getViewport().getEnvelopeInModelCoordinates()));
        request.setFormat(this.format);
        request.setStyle(this.style);
        request.setMoreParameters(this.moreParameters);
        request.setApiKeyNameAndValue(this.apiKeyNameAndValue);
        request.setImageWidth(panel.getWidth());
        request.setImageHeight(panel.getHeight());
        request.setLayerNames(this.layerNames);
        request.setTransparent(true);
        return request;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void addLayerName(String layerName) {
        this.layerNames.add(layerName);
    }

    public void setLayerNames(List<String> list) {
        this.layerNames = list;
    }

    public List<String> getLayerNames() {
        return Collections.unmodifiableList(this.layerNames);
    }

    public void setSRS(String srs) {
        this.srs = srs;
        this.setSrsInfo(new SRSInfo().setCode(srs).complete());
    }

    public String getSRS() {
        return this.srs;
    }

    public MapStyle getStyle() {
        return this.style;
    }

    public void setStyle(MapStyle style) {
        this.style = style;
    }

    public String getMoreParameters() {
        return this.moreParameters;
    }

    public void setMoreParameters(String moreParameters) {
        this.moreParameters = moreParameters;
    }

    public String getApiKeyNameAndValue() {
        return this.apiKeyNameAndValue;
    }

    public void setApiKeyNameAndValue(String apiKeyNameAndValue) {
        this.apiKeyNameAndValue = apiKeyNameAndValue;
    }

    public Object clone() throws CloneNotSupportedException {
        WMSLayer clone = (WMSLayer)super.clone();
        clone.layerNames = new ArrayList<String>(this.layerNames);
        return clone;
    }

    public void removeAllLayerNames() {
        this.layerNames.clear();
    }

    @Override
    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public WMService getService() throws IOException {
        if (this.service == null) {
            Assert.isTrue((this.serverURL != null ? 1 : 0) != 0);
            this.setService(WMSLayer.initializedService(this.serverURL, this.wmsVersion, this.apiKeyNameAndValue));
        }
        return this.service;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getWmsVersion() {
        return this.wmsVersion;
    }

    public void setWmsVersion(String wmsVersion) {
        this.wmsVersion = wmsVersion;
    }

    @Override
    public Envelope getEnvelope() {
        Envelope envelope = new Envelope();
        List<String> list = this.getLayerNames();
        try {
            for (String name : list) {
                MapLayer lyr = this.getService().getCapabilities().getMapLayerByName(name);
                if (lyr != null) {
                    BoundingBox bb = lyr.getBoundingBox(this.getSRS());
                    if (bb == null || !(bb.getEnvelope().getMinX() < bb.getEnvelope().getMaxX())) continue;
                    envelope.expandToInclude(bb.getEnvelope());
                    continue;
                }
                Logger.debug("Could not get WMS MapLayer " + name);
            }
        }
        catch (IOException e) {
            Logger.error("WMSLayer envelope calculation failed." + (Logger.isDebugEnabled() ? "" : " - " + e.getLocalizedMessage()), Logger.isDebugEnabled() ? e : null);
        }
        return envelope;
    }

    @Override
    public void dispose() {
    }
}

