/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.openjpeg;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import com.vividsolutions.jump.workbench.imagery.openjpeg.GMLJP2;
import com.vividsolutions.jump.workbench.imagery.openjpeg.GeoJP2;
import com.vividsolutions.jump.workbench.model.Disposable;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AlphaSetting;
import de.digitalcollections.openjpeg.Info;
import de.digitalcollections.openjpeg.OpenJpeg;
import de.digitalcollections.openjpeg.imageio.OpenJp2ImageReader;
import de.digitalcollections.openjpeg.imageio.OpenJp2ImageReaderSpi;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.util.AffineTransformation;

public class OpenJpegImage
implements ReferencedImage,
AlphaSetting,
Disposable {
    private File location;
    private Envelope imageEnvInModelCoordinate = new Envelope();
    private Envelope previousViewportEnvInModelCoordinates;
    private Envelope subImageInViewportCoordinates;
    private int alpha = 255;
    private double[] pyramid_x_resolutions;
    private double[] pyramid_y_resolutions;
    protected BufferedImage cachedImage = null;

    public OpenJpegImage(String location) throws Exception {
        this.init(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String location) throws Exception {
        ImageReader reader = null;
        try {
            Logger.info("Init image reader for " + location);
            URI uri = new URI(location);
            this.location = new File(uri);
            Info info = new OpenJpeg().getInfo(this.location.toPath());
            this.imageEnvInModelCoordinate = this.getEnvelope(location, info.getNativeSize().width, info.getNativeSize().height);
            Logger.info("Image envelope in model coordinates : " + this.imageEnvInModelCoordinate);
            int numResolutions = info.getNumResolutions();
            reader = new OpenJp2ImageReaderSpi().createReaderInstance();
            ImageInputStream iis = ImageIO.createImageInputStream(this.location);
            reader.setInput(iis);
            this.pyramid_x_resolutions = new double[numResolutions];
            this.pyramid_y_resolutions = new double[numResolutions];
            for (int i = 0; i < numResolutions; ++i) {
                this.pyramid_x_resolutions[i] = this.imageEnvInModelCoordinate.getWidth() / (double)reader.getWidth(i);
                this.pyramid_y_resolutions[i] = this.imageEnvInModelCoordinate.getHeight() / (double)reader.getHeight(i);
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    private Envelope getEnvelope(String location, int width, int height) throws URISyntaxException {
        URI uri = new URI(location);
        String path = new File(uri).getPath();
        Logger.info("File path: " + path);
        String j2wLocation = this.changeExtension(path, ".j2w");
        String tabLocation = this.changeExtension(path, ".tab");
        if (new File(j2wLocation).exists()) {
            Logger.info("Georeference from : " + j2wLocation);
            WorldFile wf = WorldFile.create(location);
            return new Envelope(wf.getXUpperLeft() - wf.getXSize() / 2.0, wf.getXUpperLeft() - wf.getXSize() / 2.0 + wf.getXSize() * (double)width, wf.getYUpperLeft() - wf.getYSize() / 2.0, wf.getYUpperLeft() - wf.getYSize() / 2.0 + wf.getYSize() * (double)height);
        }
        if (new File(tabLocation).exists()) {
            Logger.info("Georeference from : " + tabLocation);
            return this.envelopeFromTab(tabLocation);
        }
        GeoJP2 geoJP2 = new GeoJP2(location);
        if (geoJP2.getMetadata() != null) {
            Logger.info("Georeference from GeoJP2");
            return geoJP2.getMetadata().getActualEnvelope();
        }
        GMLJP2 gmlJP2 = new GMLJP2(location);
        if (gmlJP2.getMetadata() != null) {
            Logger.info("Georeference from GMLJP2");
            return gmlJP2.getMetadata().getActualEnvelope();
        }
        Pattern pattern = Pattern.compile("(?i)\\d+-20\\d\\d-0*(\\d+)-0*(\\d+)-[0-9A-Z_]+-0M(\\d+)-([0-9A-Z_]+-)?E\\d+\\.jp2");
        Matcher matcher = pattern.matcher(new File(path).getName());
        Logger.info(matcher.toString());
        if (matcher.matches()) {
            Logger.info("File name matches BDORTHO pattern");
            double xmin = Double.parseDouble(matcher.group(1));
            double yMax = Double.parseDouble(matcher.group(2));
            double res = Double.parseDouble("0." + matcher.group(3));
            return new Envelope(xmin * 1000.0, xmin * 1000.0 + (double)width * res, yMax * 1000.0 - (double)height * res, yMax * 1000.0);
        }
        return new Envelope(0.0, (double)width, 0.0, (double)height);
    }

    private String changeExtension(String path, String newExt) {
        return path.replace(".jp2", newExt).replace(".JP2", newExt);
    }

    private Envelope envelopeFromTab(String tabLocation) {
        Envelope envelope = null;
        if (new File(tabLocation).exists()) {
            Logger.info("Find tab file : " + tabLocation);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(tabLocation, new String[0]), new OpenOption[0])));){
                String line;
                String[] tt3 = null;
                while (null != (line = br.readLine())) {
                    if (!line.trim().equals("Type \"RASTER\"")) continue;
                    String[] tt1 = br.readLine().split("[() ,]");
                    String[] tt2 = br.readLine().split("[() ,]");
                    tt3 = br.readLine().split("[() ,]");
                    String[] tt4 = br.readLine().split("[() ,]");
                    envelope = new Envelope(Double.parseDouble(tt1[1].trim()), Double.parseDouble(tt2[1].trim()), Double.parseDouble(tt4[2].trim()), Double.parseDouble(tt1[2].trim()));
                }
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
        return envelope;
    }

    @Override
    public Envelope getEnvelope() throws ReferencedImageException {
        return this.imageEnvInModelCoordinate;
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws ReferencedImageException {
        OpenJp2ImageReader reader = null;
        double viewportScale = viewport.getScale();
        Envelope viewportEnvInModelCoordinates = viewport.getEnvelopeInModelCoordinates();
        if (!this.imageEnvInModelCoordinate.intersects(viewportEnvInModelCoordinates)) {
            this.cachedImage = null;
            this.previousViewportEnvInModelCoordinates = viewportEnvInModelCoordinates;
            return;
        }
        if (this.cachedImage == null || !viewportEnvInModelCoordinates.equals((Object)this.previousViewportEnvInModelCoordinates)) {
            try {
                int level = 0;
                int i = 0;
                while (i < this.pyramid_x_resolutions.length && !(this.pyramid_x_resolutions[i] * viewportScale > 1.0)) {
                    level = i++;
                }
                Envelope subImageInModelCoordinate = this.imageEnvInModelCoordinate.intersection(viewportEnvInModelCoordinates);
                AffineTransformation image2modelAffineTransformation = new AffineTransformation(this.pyramid_x_resolutions[level], 0.0, this.imageEnvInModelCoordinate.getMinX(), 0.0, -this.pyramid_y_resolutions[level], this.imageEnvInModelCoordinate.getMaxY());
                Envelope subImageInImageCoordinates = this.transform(subImageInModelCoordinate, image2modelAffineTransformation.getInverse());
                AffineTransform at = viewport.getModelToViewTransform();
                Point2D subImageULInViewportCoordinate = at.transform(new Point2D.Double(subImageInModelCoordinate.getMinX(), subImageInModelCoordinate.getMaxY()), new Point2D.Double());
                Point2D subImageLRInViewportCoordinate = at.transform(new Point2D.Double(subImageInModelCoordinate.getMaxX(), subImageInModelCoordinate.getMinY()), new Point2D.Double());
                this.subImageInViewportCoordinates = new Envelope(new Coordinate(subImageULInViewportCoordinate.getX(), subImageULInViewportCoordinate.getY()), new Coordinate(subImageLRInViewportCoordinate.getX(), subImageLRInViewportCoordinate.getY()));
                reader = (OpenJp2ImageReader)new OpenJp2ImageReaderSpi().createReaderInstance();
                ImageInputStream iis = ImageIO.createImageInputStream(this.location);
                reader.setInput((Object)iis);
                ImageReadParam param = new ImageReadParam();
                param.setSourceRegion(new Rectangle((int)subImageInImageCoordinates.getMinX(), (int)subImageInImageCoordinates.getMinY(), (int)subImageInImageCoordinates.getWidth(), (int)subImageInImageCoordinates.getHeight()));
                long t0 = System.currentTimeMillis();
                BufferedImage br = reader.read(level, param);
                Logger.debug("Read image " + br.getWidth() + "x" + br.getHeight() + " (level=" + level + "): " + (System.currentTimeMillis() - t0) + " s");
                Composite composite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / 255.0f));
                g.drawImage(br, (int)this.subImageInViewportCoordinates.getMinX(), (int)this.subImageInViewportCoordinates.getMinY(), (int)this.subImageInViewportCoordinates.getMaxX(), (int)this.subImageInViewportCoordinates.getMaxY(), 0, 0, br.getWidth(), br.getHeight(), Color.BLACK, null);
                g.setComposite(composite);
                this.cachedImage = br;
            }
            catch (Exception e) {
                throw new ReferencedImageException(e);
            }
            finally {
                this.previousViewportEnvInModelCoordinates = viewportEnvInModelCoordinates;
                if (reader != null) {
                    reader.dispose();
                }
            }
        } else {
            Composite composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / 255.0f));
            g.drawImage(this.cachedImage, (int)this.subImageInViewportCoordinates.getMinX(), (int)this.subImageInViewportCoordinates.getMinY(), (int)this.subImageInViewportCoordinates.getMaxX(), (int)this.subImageInViewportCoordinates.getMaxY(), 0, 0, this.cachedImage.getWidth(), this.cachedImage.getHeight(), Color.BLACK, null);
            g.setComposite(composite);
        }
        this.previousViewportEnvInModelCoordinates = viewportEnvInModelCoordinates;
    }

    private Envelope transform(Envelope env, AffineTransformation at) {
        Coordinate dstUL = new Coordinate();
        Coordinate dstLR = new Coordinate();
        at.transform(new Coordinate(env.getMinX(), env.getMaxY()), dstUL);
        at.transform(new Coordinate(env.getMaxX(), env.getMinY()), dstLR);
        return new Envelope(dstUL, dstLR);
    }

    public void close() {
        this.cachedImage = null;
    }

    @Override
    public String getType() {
        return "JP2000";
    }

    @Override
    public String getLoader() {
        try {
            return new OpenJp2ImageReaderSpi().createReaderInstance().getFormatName();
        }
        catch (IOException exception) {
            Logger.error(exception);
            return "";
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Override
    public void dispose() {
        this.close();
    }
}

