/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.Logger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.openjump.util.UriUtil;

public class WorldFile {
    public static final WorldFile DEFAULT = new WorldFile();
    private String filename;
    private double xSize = 1.0;
    private double ySize = -1.0;
    private double rowRotation = 0.0;
    private double colRotation = 0.0;
    private double xUpperLeft = 0.5;
    private double yUpperLeft = -0.5;

    private static WorldFile read(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return WorldFile.read(br);
    }

    private static WorldFile read(BufferedReader in) throws IOException {
        String lineIn = in.readLine();
        WorldFile wf = new WorldFile();
        for (int line = 0; (in.ready() || lineIn != null) && line < 6; ++line) {
            if (lineIn != null && !lineIn.isEmpty()) {
                switch (line) {
                    case 0: {
                        wf.xSize = Double.parseDouble(lineIn.trim());
                        break;
                    }
                    case 1: {
                        wf.rowRotation = Double.parseDouble(lineIn.trim());
                        break;
                    }
                    case 2: {
                        wf.colRotation = Double.parseDouble(lineIn.trim());
                        break;
                    }
                    case 3: {
                        wf.ySize = Double.parseDouble(lineIn.trim());
                        break;
                    }
                    case 4: {
                        wf.xUpperLeft = Double.parseDouble(lineIn.trim());
                        break;
                    }
                    case 5: {
                        wf.yUpperLeft = Double.parseDouble(lineIn.trim());
                    }
                }
            }
            lineIn = null;
            if (!in.ready()) continue;
            lineIn = in.readLine();
        }
        in.close();
        return wf;
    }

    public double getColRotation() {
        return this.colRotation;
    }

    public String getFilename() {
        return this.filename;
    }

    public double getRowRotation() {
        return this.rowRotation;
    }

    public double getXSize() {
        return this.xSize;
    }

    public double getXUpperLeft() {
        return this.xUpperLeft;
    }

    public double getYSize() {
        return this.ySize;
    }

    public double getYUpperLeft() {
        return this.yUpperLeft;
    }

    public static List<String> generateWorldFileExtensions(String filename) {
        ArrayList<String> exts = new ArrayList<String>();
        String img_ext = CompressedFile.hasCompressedFileExtension(filename) ? FileUtil.getExtension(UriUtil.removeExtension(filename)) : FileUtil.getExtension(filename);
        if (img_ext.length() >= 3) {
            exts.add(img_ext.substring(0, 1) + img_ext.substring(2) + "w");
        }
        exts.add(img_ext + "w");
        exts.add("wld");
        return exts;
    }

    public static WorldFile create(String location) {
        WorldFile worldFile;
        block8: {
            InputStream is = WorldFile.find(location);
            try {
                worldFile = WorldFile.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.warn(e);
                    return new WorldFile();
                }
            }
            is.close();
        }
        return worldFile;
    }

    public static InputStream find(String location) throws FileNotFoundException {
        try {
            URI origuri = new URI(location);
            String fileName = CompressedFile.getTargetFileWithPath(origuri);
            fileName = UriUtil.getFileName(fileName);
            for (String ext : WorldFile.generateWorldFileExtensions(fileName)) {
                String wf_base = UriUtil.removeExtension(fileName);
                if (CompressedFile.isCompressed(fileName)) {
                    wf_base = UriUtil.removeExtension(wf_base);
                }
                String wf_name = wf_base + "." + ext;
                URI wf_uri = CompressedFile.replaceTargetFileName(origuri, wf_name);
                try {
                    Logger.debug("Try open World File: " + wf_uri);
                    return CompressedFile.openFile(wf_uri);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            Logger.warn(e);
        }
        throw new FileNotFoundException("WF failed to find world file for: " + location);
    }
}

