/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.graphic.AbstractGraphicImage;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.openjump.util.UriUtil;

public class CommonsImage
extends AbstractGraphicImage {
    InputStream is = null;

    public CommonsImage(String location, WorldFile wf) {
        super(location, wf);
    }

    @Override
    protected void initImage() throws ReferencedImageException {
        BufferedImage image = this.getImage();
        if (image != null) {
            return;
        }
        String uri = this.getUri();
        try {
            this.is = CompressedFile.openFile(uri);
            ImageInfo info = Imaging.getImageInfo((InputStream)this.is, (String)UriUtil.getFileName(CompressedFile.getTargetFileWithPath(new URI(uri))));
            this.type = info.getFormatName();
            CommonsImage.close(this.is);
            this.is = CompressedFile.openFile(uri);
            image = Imaging.getBufferedImage((InputStream)this.is);
            CommonsImage.close(this.is);
            this.setImage(image);
        }
        catch (Exception e) {
            throw new ReferencedImageException(e);
        }
        finally {
            CommonsImage.close(this.is);
        }
    }
}

