/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util.io;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.io.FMEGMLReader;
import com.vividsolutions.jump.io.GMLInputTemplate;
import com.vividsolutions.jump.io.GMLReader;
import com.vividsolutions.jump.io.ParseException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class SimpleGMLReader {
    public List toGeometries(InputStream gml, String collectionElement, String featureElement, String geometryElement) throws Exception {
        GMLInputTemplate template = this.template(collectionElement, featureElement, geometryElement);
        GMLReader gmlReader = new GMLReader();
        gmlReader.setInputTemplate(template);
        return FeatureUtil.toGeometries(gmlReader.read(gml).getFeatures());
    }

    private GMLInputTemplate template(String collectionElement, String featureElement, String geometryElement) throws IOException, ParseException {
        String s = "";
        s = s + "<?xml version='1.0' encoding='UTF-8'?>";
        s = s + "<JCSGMLInputTemplate>";
        s = s + "<CollectionElement>" + collectionElement + "</CollectionElement>";
        s = s + "<FeatureElement>" + featureElement + "</FeatureElement>";
        s = s + "<GeometryElement>" + geometryElement + "</GeometryElement>";
        s = s + "<ColumnDefinitions></ColumnDefinitions>";
        s = s + "</JCSGMLInputTemplate>";
        GMLInputTemplate template = new GMLInputTemplate();
        try (ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));){
            template.load(is);
        }
        return template;
    }

    public List toGeometries(String gml, String collectionElement, String featureElement, String geometryElement) throws Exception {
        try (ByteArrayInputStream is = new ByteArrayInputStream(gml.getBytes(StandardCharsets.UTF_8));){
            List list = this.toGeometries(is, collectionElement, featureElement, geometryElement);
            return list;
        }
    }

    public FeatureCollection readFMEFile(File file) throws Exception {
        FeatureCollection fc;
        GMLInputTemplate inputTemplate;
        FMEGMLReader fmeGMLReader = new FMEGMLReader();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            inputTemplate = fmeGMLReader.getGMLInputTemplate(inputStream, file.getPath());
        }
        GMLReader gmlReader = new GMLReader();
        gmlReader.setInputTemplate(inputTemplate);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            fc = gmlReader.read(inputStream);
        }
        return fc;
    }
}

