/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jump.I18N;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StatisticIndices {
    private double m_dSum = 0.0;
    private double m_dRMS = 0.0;
    private double m_dMean = 0.0;
    private double m_dVariance = 0.0;
    private double m_dMax;
    private double m_dMin;
    private double m_dMedian = 0.0;
    private double m_dStdDev;
    private double m_d25Percent = 0.0;
    private double m_d75Percent = 0.0;
    private double m_dSkewn = 0.0;
    private double m_dKurt = 0.0;
    private int m_iCount = 0;
    private double m_dM2 = 0.0;
    private int m_iClasses = 0;
    private final Map<Double, Integer> counts = new TreeMap<Double, Integer>();
    public static String MAX = "Maximum";
    public static String MIN = "Minimum";
    public static String MEAN = "Mean";
    public static String STANDARD_DEV = "Standard deviation";
    public static String MEDIAN = "Median";
    public static String COUNT = "Count";
    public static String SUM = "Sum";
    public static String COEF_VARIATION = "Coeficient of variation";
    public static String RMS = "Root mean squared";
    public static String PERCENTILE_25 = "25 percentile";
    public static String PERCENTILE_75 = "75 percentile";
    public static String SKEWNESS = "Skewness";
    public static String KURTOSIS = "Kurtosis";
    public static String VARIANCE = "Variance";
    public static String NUM_CLASSES = "Number of classes";

    public StatisticIndices() {
        this.m_dMax = Double.NEGATIVE_INFINITY;
        this.m_dMin = Double.MAX_VALUE;
    }

    public static List<String> getIndices() {
        MAX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.maximum");
        MIN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.minimum");
        MEAN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.mean");
        STANDARD_DEV = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.standard-dev");
        MEDIAN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.median");
        COUNT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.count");
        SUM = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.sum");
        COEF_VARIATION = I18N.getInstance().get("com.vividsolutions.jump.util.StatisticIndices.Coefficient-of-variation");
        RMS = I18N.getInstance().get("com.vividsolutions.jump.util.StatisticIndices.Root-mean-squared");
        PERCENTILE_25 = I18N.getInstance().get("com.vividsolutions.jump.util.StatisticIndices.25-percentile");
        PERCENTILE_75 = I18N.getInstance().get("com.vividsolutions.jump.util.StatisticIndices.75-percentile");
        SKEWNESS = I18N.getInstance().get("com.vividsolutions.jump.util.StatisticIndices.Skewness");
        KURTOSIS = I18N.getInstance().get("com.vividsolutions.jump.util.StatisticIndices.Kurtosis");
        VARIANCE = I18N.getInstance().get("com.vividsolutions.jump.util.StatisticIndices.variance");
        NUM_CLASSES = I18N.getInstance().get("corg.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Number-of-classes");
        ArrayList<String> classifierList = new ArrayList<String>();
        classifierList.add(COUNT);
        classifierList.add(SUM);
        classifierList.add(MAX);
        classifierList.add(MIN);
        classifierList.add(MEAN);
        classifierList.add(STANDARD_DEV);
        classifierList.add(PERCENTILE_25);
        classifierList.add(MEDIAN);
        classifierList.add(PERCENTILE_75);
        classifierList.add(VARIANCE);
        classifierList.add(COEF_VARIATION);
        classifierList.add(RMS);
        classifierList.add(SKEWNESS);
        classifierList.add(KURTOSIS);
        classifierList.add(NUM_CLASSES);
        return classifierList;
    }

    public void calculateDescriptiveStatistics(double[] values) {
        for (double dValue : values) {
            ++this.m_iCount;
            double dDelta = dValue - this.m_dMean;
            this.m_dMean += dDelta / (double)this.m_iCount;
            this.m_dM2 += dDelta * (dValue - this.m_dMean);
            this.m_dVariance = this.m_dM2 / (double)(this.m_iCount - 1);
            this.m_dSum += dValue;
            this.m_dRMS += dValue * dValue;
            this.m_dMax = Math.max(this.m_dMax, dValue);
            this.m_dMin = Math.min(this.m_dMin, dValue);
            this.m_dStdDev = Math.sqrt(this.m_dVariance);
            this.m_dRMS = Math.sqrt(this.m_dRMS / (double)this.m_iCount);
            if (this.counts.containsKey(dValue)) {
                this.counts.put(dValue, this.counts.get(dValue) + 1);
                continue;
            }
            this.counts.put(dValue, 1);
            ++this.m_iClasses;
        }
        for (double value : values) {
            this.m_dSkewn += Math.pow(value - this.m_dMean, 3.0) / ((double)this.m_iCount * Math.pow(this.m_dStdDev, 3.0));
            this.m_dKurt += Math.pow(value - this.m_dMean, 4.0) / ((double)this.m_iCount * Math.pow(this.m_dStdDev, 4.0));
        }
        Arrays.sort(values);
        double pos1 = Math.floor(((double)values.length - 1.0) / 2.0);
        double pos2 = Math.ceil(((double)values.length - 1.0) / 2.0);
        this.m_dMedian = pos1 == pos2 ? values[(int)pos1] : (values[(int)pos1] + values[(int)pos2]) / 2.0;
        int index25 = (int)Math.ceil(0.25 * (double)values.length);
        this.m_d25Percent = values[index25];
        int index75 = (int)Math.ceil(0.75 * (double)values.length);
        this.m_d75Percent = values[index75];
    }

    public double getCoeffOfVar() {
        return this.m_dVariance / this.m_dMean;
    }

    public int getCount() {
        return this.m_iCount;
    }

    public double getMax() {
        return this.m_dMax;
    }

    public double getMean() {
        return this.m_dMean;
    }

    public double getMin() {
        return this.m_dMin;
    }

    public double getMedian() {
        return this.m_dMedian;
    }

    public double getRMS() {
        return this.m_dRMS;
    }

    public double getStdDev() {
        return this.m_dStdDev;
    }

    public double getSum() {
        return this.m_dSum;
    }

    public double getVariance() {
        return this.m_dVariance;
    }

    public double get25Percentile() {
        return this.m_d25Percent;
    }

    public double get75Percentile() {
        return this.m_d75Percent;
    }

    public double getSkewness() {
        return this.m_dSkewn;
    }

    public double getKurtosis() {
        return this.m_dKurt;
    }

    public int getClasses() {
        return this.m_iClasses;
    }

    public Map<Double, Integer> getCounts() {
        return this.counts;
    }
}

