/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.util.Assert;

public class CollectionMap<K, V>
implements Map<K, Collection<V>> {
    private Map<K, Collection<V>> map;
    private Class<? extends Collection> collectionClass = ArrayList.class;

    public CollectionMap(Class<? extends Map> mapClass) {
        try {
            this.map = mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Assert.shouldNeverReachHere();
        }
    }

    public CollectionMap(Class<? extends Map> mapClass, Class<Collection> collectionClass) {
        this.collectionClass = collectionClass;
        try {
            this.map = mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Assert.shouldNeverReachHere();
        }
    }

    public CollectionMap() {
        this(HashMap.class);
    }

    private Collection<V> getItemsInternal(K key) {
        Collection collection = this.map.get(key);
        if (collection == null) {
            try {
                collection = this.collectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                Assert.shouldNeverReachHere();
            }
            this.map.put(key, collection);
        }
        return collection;
    }

    public void addItem(K key, V item) {
        this.getItemsInternal(key).add(item);
    }

    public void removeItem(K key, V item) {
        this.getItemsInternal(key).remove(item);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void addItems(K key, Collection<V> items) {
        for (V item : items) {
            this.addItem(key, item);
        }
    }

    public void addItems(CollectionMap<K, V> other) {
        for (K key : other.keySet()) {
            this.addItems(key, other.getItems(key));
        }
    }

    @Override
    public Collection<Collection<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> get(Object key) {
        try {
            return this.getItems(key);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Collection<V> getItems(K key) {
        return Collections.unmodifiableCollection(this.getItemsInternal(key));
    }

    @Override
    public Collection<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Collection<V> put(K key, Collection<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> map) {
        for (K key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    public void removeItems(K key, Collection<V> items) {
        this.getItemsInternal(key).removeAll(items);
    }

    public Map<K, ? extends Collection<V>> getMap() {
        return this.map;
    }
}

