/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.qa.diff.DiffGeometryMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;

public class DiffGeometryIndex {
    private SpatialIndex index;
    private DiffGeometryMatcher diffMatcher;
    private boolean splitIntoComponents;
    private Collection<FeatureGeometry> featureList;

    public static Collection<Geometry> splitGeometry(Geometry geom, boolean splitIntoComponents) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        if (splitIntoComponents && geom instanceof GeometryCollection) {
            GeometryCollection geomColl = (GeometryCollection)geom;
            GeometryCollectionIterator gci = new GeometryCollectionIterator((Geometry)geomColl);
            while (gci.hasNext()) {
                Geometry component = (Geometry)gci.next();
                if (component instanceof GeometryCollection) continue;
                list.add(component);
            }
        } else {
            list.add(geom);
        }
        return list;
    }

    public DiffGeometryIndex(FeatureCollection fc, DiffGeometryMatcher diffMatcher, boolean splitIntoComponents) {
        this.diffMatcher = diffMatcher;
        this.splitIntoComponents = splitIntoComponents;
        this.buildIndex(fc);
    }

    public boolean hasMatch(Geometry testGeom) {
        this.diffMatcher.setQueryGeometry(testGeom);
        List closeFeatList = this.index.query(this.diffMatcher.getQueryGeometry().getEnvelopeInternal());
        for (FeatureGeometry closeFeat : closeFeatList) {
            if (!this.diffMatcher.isMatch(closeFeat.getGeometry())) continue;
            closeFeat.setMatched(true);
            return true;
        }
        return false;
    }

    private void buildIndex(FeatureCollection fc) {
        this.featureList = new ArrayList<FeatureGeometry>();
        this.index = new STRtree();
        for (Feature feature : fc.getFeatures()) {
            Geometry geom = feature.getGeometry();
            Collection<Geometry> list = DiffGeometryIndex.splitGeometry(geom, this.splitIntoComponents);
            for (Geometry geometry : list) {
                FeatureGeometry featGeom = new FeatureGeometry(feature, geometry);
                this.index.insert(featGeom.getGeometry().getEnvelopeInternal(), (Object)featGeom);
                this.featureList.add(featGeom);
            }
        }
    }

    public Collection<Feature> getUnmatchedFeatures() {
        TreeSet<Feature> unmatchedFeatureSet = new TreeSet<Feature>(new FeatureUtil.IDComparator());
        for (FeatureGeometry featureGeom : this.featureList) {
            if (featureGeom.isMatched()) continue;
            unmatchedFeatureSet.add(featureGeom.getFeature());
        }
        return unmatchedFeatureSet;
    }

    private class FeatureGeometry {
        private Feature feat;
        private Geometry geom;
        private boolean isMatched = false;

        FeatureGeometry(Feature feat, Geometry geom) {
            this.feat = feat;
            this.geom = geom;
        }

        public Feature getFeature() {
            return this.feat;
        }

        public Geometry getGeometry() {
            return this.geom;
        }

        public void setMatched(boolean isMatched) {
            this.isMatched = isMatched;
        }

        public boolean isMatched() {
            return this.isMatched;
        }
    }
}

