/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.qa.diff.DiffGeometryMatcher;
import com.vividsolutions.jump.qa.diff.ExactGeometryMatcher;
import com.vividsolutions.jump.qa.diff.MatchCollection;
import com.vividsolutions.jump.qa.diff.MatchGeometry;
import com.vividsolutions.jump.qa.diff.MatchIndex;
import com.vividsolutions.jump.qa.diff.NormalizedExactGeometryMatcher;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.Iterator;

public class DiffGeometryComponents {
    private FeatureCollection[] inputFC = new FeatureCollection[2];
    private TaskMonitor monitor;
    private DiffGeometryMatcher diffMatcher = new ExactGeometryMatcher();
    private boolean splitIntoComponents = true;
    private static final String sMatchingfeatures = I18N.getInstance().get("com.vividsolutions.jump.qa.diff.DiffGeometry.Matching-features");
    private static final String sGeometries = I18N.getInstance().get("com.vividsolutions.jump.qa.diff.DiffGeometryComponents.geometries");

    public DiffGeometryComponents(FeatureCollection fc0, FeatureCollection fc1, TaskMonitor monitor) {
        this.inputFC[0] = fc0;
        this.inputFC[1] = fc1;
        this.monitor = monitor;
    }

    public void setNormalize(boolean normalizeGeometry) {
        this.diffMatcher = normalizeGeometry ? new NormalizedExactGeometryMatcher() : new ExactGeometryMatcher();
    }

    public void setSplitIntoComponents(boolean splitIntoComponents) {
        this.splitIntoComponents = splitIntoComponents;
    }

    public void setMatcher(DiffGeometryMatcher diffMatcher) {
        this.diffMatcher = diffMatcher;
    }

    public FeatureCollection[] diff() {
        MatchCollection[] mc = new MatchCollection[]{new MatchCollection(this.inputFC[0], this.splitIntoComponents), new MatchCollection(this.inputFC[1], this.splitIntoComponents)};
        this.compute(mc[0], mc[1]);
        return new FeatureCollection[]{mc[0].getUnmatchedFeatures(), mc[1].getUnmatchedFeatures()};
    }

    private void compute(MatchCollection mc0, MatchCollection mc1) {
        MatchIndex index = new MatchIndex(mc1);
        this.monitor.report(sMatchingfeatures);
        this.matchFeatures(mc0, index);
        mc0.computeFeatureMatches();
        mc1.computeFeatureMatches();
        mc0.propagateUnmatchedFeatures();
        mc1.propagateUnmatchedFeatures();
    }

    private void matchFeatures(MatchCollection matchColl, MatchIndex index) {
        int count = 1;
        int totalItems = matchColl.geometrySize();
        Iterator i = matchColl.geometryIterator();
        while (i.hasNext()) {
            this.monitor.report(count++, totalItems, sGeometries);
            MatchGeometry matchGeom = (MatchGeometry)i.next();
            index.testMatch(matchGeom, this.diffMatcher);
        }
    }
}

