/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io.geojson;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.openjump.core.ui.util.GeometryUtils;

class MapGeoJsonGeometryReader
extends GeoJsonReader {
    GeometryFactory geometryFactory = null;
    Method m = GeoJsonReader.class.getDeclaredMethod("create", Map.class, GeometryFactory.class);
    Method m2;

    public MapGeoJsonGeometryReader() throws NoSuchMethodException, SecurityException {
        this.m.setAccessible(true);
        this.m2 = GeoJsonReader.class.getDeclaredMethod("getGeometryFactory", Map.class);
        this.m2.setAccessible(true);
    }

    public Geometry read(Map geometryMap) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ParseException, ClassNotFoundException {
        if (this.geometryFactory == null) {
            this.geometryFactory = (GeometryFactory)this.m2.invoke((Object)this, geometryMap);
        }
        if (!"GeometryCollection".equals(geometryMap.get("type"))) {
            Object coords = geometryMap.get("coordinates");
            if (!(coords instanceof List)) {
                throw new ParseException("coordinates is not a list: " + JSONObject.toJSONString((Map)geometryMap));
            }
            if (((List)coords).isEmpty()) {
                String type = (String)geometryMap.get("type");
                return GeometryUtils.createEmptyGeometry(type, this.geometryFactory);
            }
        }
        return (Geometry)this.m.invoke((Object)this, geometryMap, this.geometryFactory);
    }
}

