/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io.geojson;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.AbstractJUMPWriter;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.geojson.GeoJSONFeatureCollectionWrapper;
import com.vividsolutions.jump.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;

public class GeoJSONWriter
extends AbstractJUMPWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws Exception {
        FileOutputStream fileStream = null;
        OutputStreamWriter w = null;
        try {
            GeoJSONFeatureCollectionWrapper fcw = new GeoJSONFeatureCollectionWrapper(featureCollection);
            String uriString = dp.getProperty("Uri");
            if (uriString == null) {
                throw new IllegalParametersException("call to GeoJSONReader.write() has DataProperties w/o an Uri specified");
            }
            URI uri = new URI(uriString);
            fileStream = new FileOutputStream(new File(uri));
            w = new OutputStreamWriter((OutputStream)fileStream, "UTF-8");
            fcw.writeJSONString(w, this.getTaskMonitor());
        }
        catch (Throwable throwable) {
            FileUtil.close(w);
            FileUtil.close(fileStream);
            throw throwable;
        }
        FileUtil.close(w);
        FileUtil.close(fileStream);
    }
}

