/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io.geojson;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.geojson.FlexibleFeatureSchema;
import com.vividsolutions.jump.io.geojson.MapGeoJsonGeometryReader;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskMonitorUtil;
import com.vividsolutions.jump.util.Timer;
import java.io.IOException;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.geojson.GeoJsonWriter;

public class GeoJSONFeatureCollectionWrapper
implements JSONStreamAware {
    MapGeoJsonGeometryReader geomReader = null;
    FlexibleFeatureSchema featureSchema;
    FeatureCollection featureCollection;
    List<String> columnsWithMixedValues = new LinkedList<String>();
    int epsgCode = 0;
    public static final AttributeType ATTRIBUTETYPE_NULL = new NullAttributeType();

    public GeoJSONFeatureCollectionWrapper() {
        this.featureSchema = new FlexibleFeatureSchema();
        this.featureCollection = new FeatureDataset(this.featureSchema);
    }

    public GeoJSONFeatureCollectionWrapper(FeatureCollection fc) {
        this.featureSchema = new FlexibleFeatureSchema(fc.getFeatureSchema());
        this.featureCollection = fc;
        try {
            CoordinateSystem cs = this.getFeatureCollection().getFeatureSchema().getCoordinateSystem();
            if (cs != null) {
                this.epsgCode = cs.getEPSGCode();
            }
        }
        catch (UnsupportedOperationException e) {
            this.epsgCode = 0;
        }
    }

    public void add(Map featureMap) throws Exception {
        BasicFeature feature = new BasicFeature(this.featureSchema){

            @Override
            public Object getAttribute(int i) {
                if (i < 0) {
                    throw new InvalidParameterException("index must be greater or equal zero");
                }
                Object attrib = null;
                Object[] attributes = this.getAttributes();
                if (i < attributes.length) {
                    attrib = attributes[i];
                }
                if (i == GeoJSONFeatureCollectionWrapper.this.featureSchema.getGeometryIndex()) {
                    if (attrib == null) {
                        attrib = GeoJSONFeatureCollectionWrapper.this.featureSchema.createEmptyGeometry();
                        this.setGeometry((Geometry)attrib);
                    }
                } else if (GeoJSONFeatureCollectionWrapper.this.featureSchema.getAttributeCount() <= i) {
                    attrib = "ERROR";
                } else if (GeoJSONFeatureCollectionWrapper.this.featureSchema.getAttributeType(i).equals(AttributeType.STRING) && attrib != null && !(attrib instanceof String)) {
                    attrib = String.valueOf(attrib);
                }
                return attrib;
            }

            @Override
            public void setAttribute(int attributeIndex, Object newAttribute) {
                FeatureSchema schema = this.getSchema();
                Object[] oldAttribs = this.getAttributes();
                int diffCount = schema.getAttributeCount() - oldAttribs.length;
                if (diffCount > 0) {
                    ArrayList<Object> attributes = new ArrayList<Object>(Arrays.asList(oldAttribs));
                    attributes.addAll(Arrays.asList(new Object[diffCount]));
                    super.setAttributes(attributes.toArray());
                }
                super.setAttribute(attributeIndex, newAttribute);
            }

            @Override
            public void setGeometry(Geometry geometry) {
                this.setAttribute(this.getSchema().getGeometryIndex(), (Object)geometry);
            }

            @Override
            public Geometry getGeometry() {
                return (Geometry)this.getAttribute(this.getSchema().getGeometryIndex());
            }
        };
        if (featureMap.containsKey("geometry") && featureMap.get("geometry") instanceof Map) {
            if (this.featureSchema.getGeometryIndex() < 0) {
                this.featureSchema.addAttribute("Geometry", AttributeType.GEOMETRY);
            }
            Map geometryMap = (Map)featureMap.get("geometry");
            if (this.geomReader == null) {
                this.geomReader = new MapGeoJsonGeometryReader();
            }
            Geometry geom = this.geomReader.read(geometryMap);
            if (this.featureSchema.getGeometryType() == null) {
                this.featureSchema.setGeometryType(geom.getClass());
            }
            feature.setGeometry(geom);
        }
        if (featureMap.containsKey("properties") && featureMap.get("properties") instanceof Map) {
            Map attribsMap = (Map)featureMap.get("properties");
            for (String key : attribsMap.keySet()) {
                Object value = attribsMap.get(key);
                AttributeType type = GeoJSONFeatureCollectionWrapper.toAttributeType(value);
                if (!this.featureSchema.hasAttribute(key)) {
                    this.featureSchema.addAttribute(key, type);
                } else if (!this.columnsWithMixedValues.contains(key) && this.featureSchema.getAttributeType(key) != type) {
                    if (this.featureSchema.getAttributeType(key) == ATTRIBUTETYPE_NULL) {
                        this.featureSchema.setAttributeType(key, type);
                    } else if (type != ATTRIBUTETYPE_NULL) {
                        this.columnsWithMixedValues.add(key);
                    }
                }
                feature.setAttribute(key, value);
            }
        }
        this.featureCollection.add(feature);
    }

    public static AttributeType toAttributeType(Object value) {
        if (value == null) {
            return ATTRIBUTETYPE_NULL;
        }
        AttributeType type = AttributeType.toAttributeType(value.getClass());
        if (type == null) {
            type = AttributeType.OBJECT;
        }
        return type;
    }

    public int size() {
        return this.featureCollection.size();
    }

    public FeatureCollection getFeatureCollection() {
        for (String key : new LinkedList<String>(this.columnsWithMixedValues)) {
            this.featureSchema.setAttributeType(this.featureSchema.getAttributeIndex(key), AttributeType.STRING);
            this.columnsWithMixedValues.remove(key);
        }
        for (int i = 0; i < this.featureSchema.getAttributeCount(); ++i) {
            AttributeType type = this.featureSchema.getAttributeType(i);
            if (type != ATTRIBUTETYPE_NULL) continue;
            this.featureSchema.setAttributeType(i, AttributeType.STRING);
        }
        return this.featureCollection;
    }

    public void writeJSONString(Writer out) throws IOException {
        this.writeJSONString(out, null);
    }

    public void writeJSONString(Writer out, TaskMonitor monitor) throws IOException {
        out.write("{\n");
        out.write("\"type\": \"FeatureCollection\",\n");
        if (this.epsgCode != 0 && this.epsgCode != 4326) {
            out.write("\"crs\": {\"type\": \"name\", \"properties\": { \"name\": \"EPSG:" + this.epsgCode + "\" }},\n");
        }
        out.write("\"features\": [\n");
        long milliSeconds = 0L;
        int count = 0;
        boolean first = true;
        String[] featureFields = new String[]{"type", "properties", "geometry"};
        TaskMonitorUtil.report(monitor, I18N.getInstance().get("Writer.writing-features"));
        for (Feature feature : this.featureCollection.getFeatures()) {
            if (TaskMonitorUtil.isCancelRequested(monitor)) break;
            if (!first) {
                out.write(",\n");
            }
            String featureJson = this.toJSONString(feature, first);
            out.write(featureJson);
            long now = Timer.milliSecondsSince(0L);
            ++count;
            if (now - 500L >= milliSeconds) {
                milliSeconds = now;
                TaskMonitorUtil.report(monitor, count, this.size(), "");
            }
            if (!first) continue;
            first = false;
        }
        out.write("\n]");
        out.write("\n\n}");
    }

    private String toJSONString(Feature feature) {
        return this.toJSONString(feature, false);
    }

    private String toJSONString(Feature feature, boolean saveNullValues) {
        String propertiesJson = null;
        String geometryJson = null;
        FeatureSchema schema = feature.getSchema();
        GeoJsonWriter geomWriter = new GeoJsonWriter();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            String name = schema.getAttributeName(i);
            AttributeType type = schema.getAttributeType(i);
            Object value = feature.getAttribute(i);
            if (i == schema.getGeometryIndex()) {
                Geometry geometry = (Geometry)value;
                if (geometry == null) continue;
                geomWriter.setEncodeCRS(geometry.getFactory().getSRID() != 0 && geometry.getFactory().getSRID() != this.epsgCode);
                geometryJson = geomWriter.write(geometry);
                continue;
            }
            if (!saveNullValues && value == null) continue;
            if (type.equals(AttributeType.DATE)) {
                value = String.valueOf(value);
            }
            String json = JSONObject.toString((String)name, (Object)value);
            propertiesJson = propertiesJson != null ? propertiesJson + ", " + json : json;
        }
        geometryJson = "\"geometry\": " + geometryJson;
        if (propertiesJson != null) {
            propertiesJson = "{ " + propertiesJson + " }";
        }
        propertiesJson = "\"properties\": " + propertiesJson;
        return "{ \"type\": \"Feature\", " + propertiesJson + ", " + geometryJson + " }";
    }

    static class NullAttributeType
    extends AttributeType {
        public NullAttributeType() {
            super("NULL", Null.class);
        }
    }

    static class Null {
        Null() {
        }
    }
}

