/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPVersion;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.postgis.PostgisDSConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.AbstractSpatialDatabasesDSDriver;
import com.vividsolutions.jump.parameter.ParameterList;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.sql.Connection;
import java.util.Properties;
import javax.swing.Icon;

public class PostgisDataStoreDriver
extends AbstractSpatialDatabasesDSDriver {
    public static final String JDBC_CLASS = "org.postgresql.Driver";

    public PostgisDataStoreDriver() {
        this.driverName = "PostGIS";
        this.jdbcClass = JDBC_CLASS;
        this.urlPrefix = "jdbc:postgresql://";
    }

    @Override
    public DataStoreConnection createConnection(ParameterList params) throws Exception {
        Properties connectionProps = new Properties();
        connectionProps.put("ApplicationName", I18N.getInstance().get("JUMPWorkbench.jump") + " " + JUMPVersion.CURRENT_VERSION);
        Connection conn = super.createJdbcConnection(params, connectionProps);
        return new PostgisDSConnection(conn);
    }

    @Override
    public Icon getConnectedIcon() {
        return IconLoader.icon("ok_pg.png");
    }

    @Override
    public Icon getDisconnectedIcon() {
        return IconLoader.icon("ko_pg.png");
    }
}

