/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.mariadb;

import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.datastore.jdbc.ValueConverterFactory;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesValueConverterFactory;
import com.vividsolutions.jump.feature.AttributeType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class MariadbValueConverterFactory
extends SpatialDatabasesValueConverterFactory {
    protected final ValueConverter MYSQLWKB_GEOMETRY_MAPPER = new MySQLWKBGeometryValueConverter();

    public MariadbValueConverterFactory(Connection conn) {
        super(conn);
    }

    @Override
    public ValueConverter getConverter(ResultSetMetaData rsm, int columnIndex) throws SQLException {
        String dbTypeName = rsm.getColumnTypeName(columnIndex);
        if ("LONGBLOB".equalsIgnoreCase(dbTypeName)) {
            return this.WKB_GEOMETRY_MAPPER;
        }
        if ("GEOMETRY".equalsIgnoreCase(dbTypeName)) {
            return this.MYSQLWKB_GEOMETRY_MAPPER;
        }
        ValueConverter stdConverter = ValueConverterFactory.getConverter(rsm, columnIndex);
        if (stdConverter != null) {
            return stdConverter;
        }
        return ValueConverterFactory.STRING_MAPPER;
    }

    private boolean appearsToBeNativeFormat(byte[] geometryAsBytes) {
        int firstFive = geometryAsBytes[0] | geometryAsBytes[1] | geometryAsBytes[2] | geometryAsBytes[3] | geometryAsBytes[4];
        byte[] firstFour = new byte[4];
        System.arraycopy(geometryAsBytes, 0, firstFour, 0, firstFour.length);
        boolean nativeFormat = false;
        if ((firstFive & 0xFF) == 1) {
            if (geometryAsBytes[5] >= 1 && geometryAsBytes[5] <= 7) {
                nativeFormat = true;
            }
        } else {
            nativeFormat = true;
        }
        return nativeFormat;
    }

    class MySQLWKBGeometryValueConverter
    implements ValueConverter {
        MySQLWKBGeometryValueConverter() {
        }

        @Override
        public AttributeType getType() {
            return AttributeType.GEOMETRY;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws IOException, SQLException, ParseException {
            byte[] bytes = rs.getBytes(columnIndex);
            Geometry geometry = null;
            if (bytes == null || bytes.length < 5) {
                geometry = MariadbValueConverterFactory.this.wktReader.read("GEOMETRYCOLLECTION EMPTY");
            } else {
                boolean nativeFormat = MariadbValueConverterFactory.this.appearsToBeNativeFormat(bytes);
                WKBReader wr = new WKBReader();
                if (nativeFormat) {
                    byte[] wkb = new byte[bytes.length - 4];
                    System.arraycopy(bytes, 4, wkb, 0, wkb.length);
                    geometry = wr.read(wkb);
                } else {
                    geometry = wr.read(bytes);
                }
            }
            return geometry;
        }
    }
}

