/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore;

public class GeometryColumn {
    private String name;
    private int srid = 0;
    private String type = "Geometry";
    private Boolean indexed = null;
    private int coordDimension = 2;

    public GeometryColumn(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GeometryColumn(String name, int srid) {
        this(name);
        this.srid = srid;
    }

    public int getSRID() {
        return this.srid;
    }

    public GeometryColumn(String name, int srid, String type) {
        this(name, srid);
        this.type = type;
    }

    public GeometryColumn(String name, int coordDimension, int srid, String type) {
        this(name, srid);
        this.coordDimension = coordDimension;
        this.type = type;
    }

    public GeometryColumn(String name, int coordDimension, int srid, String type, boolean indexed) {
        this(name, coordDimension, srid, type);
        this.indexed = indexed;
    }

    public GeometryColumn(String name, int srid, String type, boolean indexed) {
        this(name, srid, type);
        this.indexed = indexed;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getCoordDimension() {
        return this.coordDimension;
    }

    public void setCoordDimension(int coordDimension) {
        this.coordDimension = coordDimension;
    }

    public String toString() {
        return this.name + " (" + this.type + (this.getCoordDimension() == 3 ? "Z" : "") + ", srid=" + this.srid + ")";
    }

    public Boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }
}

