/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.algorithm;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class Densifier {
    private final Geometry geom;
    private final GeometryFactory factory;
    private double maxLength = 1.0;

    public Densifier(Geometry geom, double maxLength) {
        this.geom = geom;
        this.factory = geom.getFactory();
        this.maxLength = maxLength;
    }

    public static Geometry densify(Geometry geom, double maxLength) {
        Densifier densifier = new Densifier(geom, maxLength);
        return densifier.densify();
    }

    private Geometry densify() {
        if (this.geom.isEmpty() || this.geom.getDimension() == 0) {
            return this.geom;
        }
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        for (int i = 0; i < this.geom.getNumGeometries(); ++i) {
            list.add(this.densify(this.geom.getGeometryN(i)));
        }
        return this.factory.buildGeometry(list);
    }

    private Geometry densify(Geometry geometry) {
        if (geometry.getDimension() == 1) {
            return this.densify((LineString)geometry);
        }
        if (geometry.getDimension() == 2) {
            return this.densify((Polygon)geometry);
        }
        return geometry;
    }

    private Polygon densify(Polygon polygon) {
        LinearRing exteriorRing = this.densify(polygon.getExteriorRing());
        LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = this.densify(polygon.getInteriorRingN(i));
        }
        return this.factory.createPolygon(exteriorRing, holes);
    }

    private LineString densify(LineString line) {
        CoordinateSequence sequence = line.getCoordinateSequence();
        CoordinateList list = new CoordinateList();
        for (int i = 0; i < sequence.size(); ++i) {
            this.densify(sequence, i, list);
        }
        list.add((Object)sequence.getCoordinate(sequence.size() - 1));
        return this.factory.createLineString(list.toCoordinateArray());
    }

    private LinearRing densify(LinearRing line) {
        CoordinateSequence sequence = line.getCoordinateSequence();
        CoordinateList list = new CoordinateList();
        for (int i = 0; i < sequence.size(); ++i) {
            this.densify(sequence, i, list);
        }
        list.add((Object)sequence.getCoordinate(sequence.size() - 1));
        return this.factory.createLinearRing(list.toCoordinateArray());
    }

    private void densify(CoordinateSequence seq, int index, CoordinateList coordinateList) {
        if (index == 0) {
            return;
        }
        Coordinate p0 = seq.getCoordinate(index - 1);
        Coordinate p1 = seq.getCoordinate(index);
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        double dz = p1.z - p0.z;
        double frac = Math.sqrt(dx * dx + dy * dy) / this.maxLength;
        dx /= frac;
        dy /= frac;
        dz /= frac;
        int nbSegments = (int)(frac + 0.9999);
        for (int i = 0; i < nbSegments; ++i) {
            double x = p0.x + (double)i * dx;
            double y = p0.y + (double)i * dy;
            double z = p0.z + (double)i * dz;
            Coordinate pt = new Coordinate(x, y, z);
            coordinateList.add((Object)pt);
        }
    }
}

