/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump;

import com.vividsolutions.jump.workbench.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;

public final class I18N {
    private static Map<Object, I18N> instances = new HashMap<Object, I18N>();
    private static ClassLoader classLoader;
    private String resourcePath = "language/jump";
    private static Locale locale;
    private static boolean initialized;
    private ResourceBundle resourceBundle;
    private ResourceBundle resourceBundle2;
    private ResourceBundle resourceBundle3 = null;
    private HashSet<String> missing = new HashSet();
    public static final I18N JUMP;

    private I18N() {
    }

    private I18N(String categoryPrefix) {
        this.resourcePath = categoryPrefix.replace('.', '/') + "/" + this.resourcePath;
    }

    private I18N(File path) {
        this.resourcePath = path.toString();
        if (File.separatorChar != '/') {
            this.resourcePath = this.resourcePath.replace(File.separatorChar, '/');
        }
    }

    private static void initAll() {
        if (initialized) {
            return;
        }
        for (I18N i18n : instances.values()) {
            i18n.init();
        }
        JUMP.init();
        initialized = true;
    }

    private void init() {
        this.resourceBundle = locale.getCountry().isEmpty() ? null : this.getResourceBundle(locale);
        this.resourceBundle2 = locale.getLanguage().isEmpty() ? null : this.getResourceBundle(new Locale(locale.getLanguage()));
        this.resourceBundle3 = this.getResourceBundle(Locale.ROOT);
        if (this.resourceBundle == null && this.resourceBundle2 == null && this.resourceBundle3 == null) {
            Logger.error("All resourcebundles for '" + this.resourcePath + "' returned NULL. This is most likely wrong! Check the classpath.");
        }
    }

    private ResourceBundle getResourceBundle(final Locale loco) {
        ResourceBundle rb;
        ResourceBundle.Control rbc = new ResourceBundle.Control(){

            @Override
            public List<Locale> getCandidateLocales(String name, Locale locale) {
                return Collections.singletonList(loco);
            }

            @Override
            public Locale getFallbackLocale(String baseName, Locale locale) {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                if (!format.equals("java.properties")) {
                    return super.newBundle(baseName, locale, format, loader, reload);
                }
                String bundleName = this.toBundleName(baseName, locale);
                PropertyResourceBundle bundle = null;
                String resourceName = this.toResourceName0(bundleName, "properties");
                if (resourceName == null) {
                    return bundle;
                }
                boolean reloadFlag = reload;
                InputStream stream = null;
                URL url = loader.getResource(resourceName);
                if (url == null) {
                    return null;
                }
                URLConnection connection = url.openConnection();
                if (reloadFlag) {
                    connection.setUseCaches(false);
                }
                stream = connection.getInputStream();
                String encoding = System.getProperty("com.vividsolutions.jump.I18N.encoding", "UTF-8");
                if (stream != null) {
                    try {
                        bundle = new PropertyResourceBundle(new InputStreamReader(stream, encoding));
                    }
                    catch (Exception e) {
                        Logger.error(resourceName, e);
                    }
                    finally {
                        stream.close();
                    }
                }
                return bundle;
            }

            private String toResourceName0(String bundleName, String suffix) {
                if (bundleName.contains("://")) {
                    return null;
                }
                return this.toResourceName(bundleName, suffix);
            }
        };
        ClassLoader cl = classLoader instanceof ClassLoader ? classLoader : this.getClass().getClassLoader();
        try {
            rb = ResourceBundle.getBundle(this.resourcePath, loco, cl, rbc);
        }
        catch (MissingResourceException e) {
            rb = null;
        }
        return rb;
    }

    public static void reset() {
        ResourceBundle.clearCache();
        initialized = false;
    }

    public static void setClassLoader(ClassLoader cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Classloader must not be null.");
        }
        classLoader = cl;
        I18N.reset();
    }

    public static void setLocale(Locale localeNew) {
        if (localeNew == null) {
            throw new InvalidParameterException("Parameter localeNew must not be Null.");
        }
        locale = localeNew;
        I18N.reset();
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setEncoding(String csname) {
        System.setProperty("com.vividsolutions.jump.I18N.encoding", csname);
        I18N.reset();
    }

    private static I18N getInstance(Object categoryPrefixOrPathOrI18N) {
        I18N instance = instances.get(categoryPrefixOrPathOrI18N);
        if (instance == null) {
            instance = categoryPrefixOrPathOrI18N instanceof File ? new I18N((File)categoryPrefixOrPathOrI18N) : new I18N(categoryPrefixOrPathOrI18N.toString());
            instance.init();
            instances.put(categoryPrefixOrPathOrI18N, instance);
        }
        return instance;
    }

    public static I18N getInstance(String categoryPrefix) {
        return I18N.getInstance((Object)categoryPrefix);
    }

    public static I18N getInstance(File path) {
        return I18N.getInstance((Object)path);
    }

    public static I18N getInstance() {
        return JUMP;
    }

    public static Locale fromCode(String localeCode) {
        String[] lc = localeCode.split("_");
        Locale locale = Locale.getDefault();
        if (lc.length > 1) {
            Logger.debug("lang:" + lc[0] + " country:" + lc[1]);
            locale = new Locale(lc[0], lc[1]);
        } else if (lc.length > 0) {
            Logger.debug("lang:" + lc[0]);
            locale = new Locale(lc[0]);
        } else {
            Logger.error(localeCode + " is an illegal argument to define lang [and country]");
        }
        return locale;
    }

    public static void applyToRuntime(Locale loc) {
        Locale.setDefault(loc);
        System.setProperty("user.language", loc.getLanguage());
        System.setProperty("user.country", loc.getCountry());
    }

    public static String getLocaleString() {
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    public static String getLanguage() {
        return locale.getLanguage();
    }

    public static String getCountry() {
        return locale.getCountry();
    }

    public String get(String label) {
        return this.get(label, new Object[0]);
    }

    public String get(String label, Object ... objects) {
        I18N.initAll();
        if (StringUtils.isBlank((CharSequence)label)) {
            throw new IllegalArgumentException("label must not be empty!");
        }
        String text = this.getValue(label).trim();
        if (text.startsWith("$J:")) {
            text = I18N.getInstance().getValue(text.substring(3).trim());
        }
        if (objects == null || objects.length < 1) {
            return text;
        }
        MessageFormat mformat = new MessageFormat(text);
        String res = mformat.format(objects);
        return res;
    }

    private String getValue(String key) {
        String text;
        if (this.resourceBundle != null && this.isValid(text = this.findKeyInResourceBundle(this.resourceBundle, key))) {
            return text;
        }
        if (this.resourceBundle2 != null && this.isValid(text = this.findKeyInResourceBundle(this.resourceBundle2, key))) {
            return text;
        }
        if (this.resourceBundle3 != null && this.isValid(text = this.findKeyInResourceBundle(this.resourceBundle3, key))) {
            return text;
        }
        String[] labelpath = key.split("\\.");
        text = labelpath[labelpath.length - 1];
        if (!this.missing.contains(key)) {
            String msg = "No translation for key ''{0}'' in bundle ''{1}''.\nUsing last segment of key instead: ''{2}''";
            msg = MessageFormat.format(msg, key, this.resourcePath, text);
            Logger.warn(msg);
            this.missing.add(key);
        }
        return text;
    }

    private String findKeyInResourceBundle(ResourceBundle rb, String key) {
        String value = null;
        try {
            value = rb.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return value;
    }

    private boolean isValid(String text) {
        return text != null && !text.trim().equals("") && !text.trim().startsWith("#T:");
    }

    static {
        locale = Locale.getDefault();
        initialized = false;
        JUMP = new I18N();
    }
}

