/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class VertexStylePanel
extends JPanel
implements ListCellRenderer {
    public static final Color DEFAULT_VERTEX_COLOR = Color.red;
    public static final String DEFAULT_VERTEX_FORM = "SQUARE";
    public static final Integer DEFAULT_VERTEX_SIZE = 5;
    private JPanel mainPanel;
    private ColorChooserPanel vertexColorChooserPanel;
    private JLabel vertexColorLabel;
    private JComboBox vertexStyleComboBox;
    private JLabel vertexStyleLabel;
    private JLabel vertexSizeLabel;
    private JSlider vertexSizeSlider;
    private JPanel fillPanel;
    private JButton restoreDefaultsButton;
    private boolean displayRestoreDefaultsButton = true;

    public VertexStylePanel() {
        this.initComponents();
    }

    public VertexStylePanel(boolean displayRestoreDefaultsButton) {
        this.displayRestoreDefaultsButton = displayRestoreDefaultsButton;
        this.initComponents();
        this.setVertexColor(DEFAULT_VERTEX_COLOR);
        this.setVertexForm(DEFAULT_VERTEX_FORM);
        this.setVertexSize(DEFAULT_VERTEX_SIZE);
    }

    public Color getVertexColor() {
        return this.vertexColorChooserPanel.getColor();
    }

    public String getVertexForm() {
        return ((String[])this.vertexStyleComboBox.getSelectedItem())[1];
    }

    public int getVertexSize() {
        return this.vertexSizeSlider.getValue();
    }

    public void setVertexColor(Color color) {
        this.vertexColorChooserPanel.setColor(color);
    }

    public void setVertexForm(String form) {
        int count = this.vertexStyleComboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            String[] item = (String[])this.vertexStyleComboBox.getItemAt(i);
            if (!item[1].equals(form)) continue;
            this.vertexStyleComboBox.setSelectedIndex(i);
            break;
        }
    }

    public void setVertexSize(int size) {
        this.vertexSizeSlider.setValue(size);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.vertexColorLabel = new JLabel();
        this.vertexStyleLabel = new JLabel();
        this.vertexColorChooserPanel = new ColorChooserPanel();
        this.restoreDefaultsButton = new JButton();
        this.restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VertexStylePanel.this.vertexColorChooserPanel.setColor(DEFAULT_VERTEX_COLOR);
                VertexStylePanel.this.vertexSizeSlider.setValue(DEFAULT_VERTEX_SIZE);
                int count = VertexStylePanel.this.vertexStyleComboBox.getItemCount();
                for (int i = 0; i < count; ++i) {
                    String[] item = (String[])VertexStylePanel.this.vertexStyleComboBox.getItemAt(i);
                    if (!item[1].equals(VertexStylePanel.DEFAULT_VERTEX_FORM)) continue;
                    VertexStylePanel.this.vertexStyleComboBox.setSelectedIndex(i);
                    break;
                }
            }
        });
        this.vertexColorChooserPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserPanel ccp = (ColorChooserPanel)e.getSource();
                ccp.setAlpha(255);
            }
        });
        this.vertexColorChooserPanel.setAlpha(255);
        this.vertexStyleComboBox = new JComboBox();
        this.vertexStyleComboBox.setRenderer(this);
        this.vertexStyleComboBox.setEditable(false);
        this.vertexStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.square"), DEFAULT_VERTEX_FORM});
        this.vertexStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.circle"), "CIRCLE"});
        this.vertexStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.triangle"), "TRIANGLE"});
        this.vertexStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.cross"), "CROSS"});
        this.vertexStyleComboBox.addItem(new String[]{I18N.getInstance().get("deejump.ui.style.RenderingStylePanel.star"), "STAR"});
        this.vertexSizeLabel = new JLabel();
        this.vertexSizeSlider = new JSlider();
        this.fillPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.mainPanel.setLayout(new GridBagLayout());
        this.add((Component)this.mainPanel, "Center");
        this.vertexColorLabel.setText(I18N.getInstance().get("org.openjump.core.ui.swing.VertexStylePanel.vertex-color"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.vertexColorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.vertexColorChooserPanel, gridBagConstraints);
        this.vertexStyleLabel.setText(I18N.getInstance().get("org.openjump.core.ui.swing.VertexStylePanel.vertex-style"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.vertexStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.vertexStyleComboBox, gridBagConstraints);
        this.vertexSizeLabel.setText(I18N.getInstance().get("org.openjump.core.ui.swing.VertexStylePanel.vertexsize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.vertexSizeLabel, gridBagConstraints);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel("1"));
        labelTable.put(new Integer(5), new JLabel("5"));
        labelTable.put(new Integer(10), new JLabel("10"));
        labelTable.put(new Integer(15), new JLabel("15"));
        labelTable.put(new Integer(20), new JLabel("20"));
        this.vertexSizeSlider.setLabelTable(labelTable);
        this.vertexSizeSlider.setMinorTickSpacing(1);
        this.vertexSizeSlider.setMajorTickSpacing(0);
        this.vertexSizeSlider.setPaintLabels(true);
        this.vertexSizeSlider.setMinimum(1);
        this.vertexSizeSlider.setValue(2);
        this.vertexSizeSlider.setMaximum(20);
        this.vertexSizeSlider.setSnapToTicks(true);
        this.vertexSizeSlider.setPreferredSize(new Dimension(130, 49));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.vertexSizeSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)GUIUtil.createSyncdTextField(this.vertexSizeSlider, 3), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.fillPanel, gridBagConstraints);
        if (this.displayRestoreDefaultsButton) {
            this.restoreDefaultsButton.setText(I18N.getInstance().get("org.openjump.core.ui.swing.VertexStylePanel.RestoreDefaultsSettings"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            this.mainPanel.add((Component)this.restoreDefaultsButton, gridBagConstraints);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = new JLabel(((String[])value)[0]);
        label.setOpaque(true);
        if (isSelected) {
            label.setBackground(new Color(163, 184, 204));
        }
        return label;
    }
}

