/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class ZoomToWMSLayerPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("zoom.gif");
    private Object[][] values = null;
    private String[] columnNames = null;
    private JTable infoTable = null;
    private TableColumnModel tcm = null;
    private JScrollPane infoTableSc = null;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        EnableCheckFactory enableCheckFactory = context.getCheckFactory();
        MultiEnableCheck enableCheck = new MultiEnableCheck().add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck());
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.VIEW}, I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.zoom-to-wms-layer") + "{pos:9}", false, null, enableCheck);
        context.getFeatureInstaller().addPopupMenuPlugin(context.getWorkbenchFrame().getWMSLayerNamePopupMenu(), this, I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.zoom-to-wms-layer"), false, null, enableCheck);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Envelope envelope = new Envelope();
        List<MapLayer> mapLayerOfChoosenLayers = this.getMapLayerOfChoosenLayers(context);
        if (mapLayerOfChoosenLayers.size() == 0) {
            return false;
        }
        String selectedSRS = this.getSelectedSRS(context);
        Map<String, BoundingBox> boundingBoxesForSRS = this.getBoundingBoxesForSRS(mapLayerOfChoosenLayers, selectedSRS);
        this.zoomToBoundingBox(context, boundingBoxesForSRS, selectedSRS);
        return true;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.zoom-to-wms-layer");
    }

    private List<MapLayer> getMapLayerOfChoosenLayers(PlugInContext context) throws Exception {
        ArrayList<MapLayer> mapLayerOfChoosenLayers = new ArrayList<MapLayer>();
        WMSLayer[] selectedWmsLayers = this.getSelectedWMSLayer(context);
        if (selectedWmsLayers.length == 0) {
            JOptionPane.showMessageDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.no-wms-layer-selected"));
            return mapLayerOfChoosenLayers;
        }
        Set<MapLayer> allLayers = this.getAllMapLayer(context);
        for (WMSLayer selectedLayer : selectedWmsLayers) {
            String name = selectedLayer.getName().replaceAll(" \\(\\d+\\)$", "");
            for (MapLayer mapLayer : allLayers) {
                String mapLayerTitle = mapLayer.getTitle();
                String mapLayerName = mapLayer.getName();
                if (mapLayerTitle != null && mapLayerName != null) {
                    if (!mapLayerTitle.contains(name) && !mapLayerName.contains(name)) continue;
                    mapLayerOfChoosenLayers.add(mapLayer);
                    continue;
                }
                if (mapLayerTitle != null && mapLayerTitle.contains(name)) {
                    mapLayerOfChoosenLayers.add(mapLayer);
                    continue;
                }
                if (mapLayerName == null || !mapLayerName.contains(name)) continue;
                mapLayerOfChoosenLayers.add(mapLayer);
            }
        }
        return mapLayerOfChoosenLayers;
    }

    private WMSLayer[] getSelectedWMSLayer(PlugInContext context) {
        Collection<WMSLayer> nodes = context.getLayerNamePanel().selectedNodes(WMSLayer.class);
        ArrayList<WMSLayer> wmsLayerList = new ArrayList<WMSLayer>();
        for (WMSLayer o : nodes) {
            wmsLayerList.add(o);
        }
        return wmsLayerList.toArray(new WMSLayer[0]);
    }

    private Set<MapLayer> getAllMapLayer(PlugInContext context) throws Exception {
        WMSLayer[] wmsLayers = this.getSelectedWMSLayer(context);
        HashSet<MapLayer> set = new HashSet<MapLayer>();
        for (WMSLayer layer : wmsLayers) {
            WMService wmService = layer.getService();
            Capabilities capabilities = wmService.getCapabilities();
            MapLayer topLayer = capabilities.getTopLayer();
            set.addAll(topLayer.getLayerList());
        }
        return set;
    }

    private String getSelectedSRS(PlugInContext context) {
        WMSLayer[] wmsLayers;
        String selectedSRS = "0";
        for (WMSLayer wmsLayer : wmsLayers = this.getSelectedWMSLayer(context)) {
            selectedSRS = wmsLayer.getSRS().toLowerCase();
        }
        return selectedSRS;
    }

    private Map<String, BoundingBox> getBoundingBoxesForSRS(List<MapLayer> mapLayerList, String srs) {
        HashMap<String, BoundingBox> boundingBoxesForSRS = new HashMap<String, BoundingBox>();
        for (MapLayer mapLayer : mapLayerList) {
            List<BoundingBox> boundingBoxList = mapLayer.getAllBoundingBoxList();
            BoundingBox latLonBoundingBox = mapLayer.getLatLonBoundingBox();
            if (latLonBoundingBox == null || boundingBoxList.size() <= 0) continue;
            boundingBoxList.add(latLonBoundingBox);
            HashSet<String> doppelt = new HashSet<String>();
            for (BoundingBox bb : boundingBoxList) {
                String bbSrs = bb.getSRS().toLowerCase();
                if (bbSrs.contains("latlon")) {
                    bbSrs = "epsg:4326";
                }
                if (!bbSrs.equalsIgnoreCase(srs)) continue;
                String key = mapLayer.getTitle();
                if (!doppelt.add(key)) {
                    key = key + " (" + bbSrs + ")";
                }
                boundingBoxesForSRS.put(key, bb);
            }
        }
        return boundingBoxesForSRS;
    }

    private void zoomToBoundingBox(PlugInContext context, Map<String, BoundingBox> boundingBoxesForSRS, String selectedSRS) throws Exception {
        JComboBox<String> comboBox = this.makeComboBox(boundingBoxesForSRS);
        JPanel jp = new JPanel();
        JButton jb = new JButton("?");
        jb.setActionCommand("showInfoTable");
        jb.addActionListener(new ShowInfoActionListener(context));
        String tmpLatLon = "";
        if (selectedSRS.contains("4326")) {
            tmpLatLon = " (LatLon)";
        }
        jp.add(comboBox);
        jp.add(jb);
        int back = JOptionPane.showConfirmDialog(context.getWorkbenchFrame(), jp, I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.bounding-box-for") + " " + selectedSRS + tmpLatLon, 2, 1);
        if (back == 2 || back < 0) {
            return;
        }
        BoundingBox selectedBB = boundingBoxesForSRS.get(comboBox.getSelectedItem());
        if (selectedBB == null) {
            return;
        }
        String message = selectedBB.toString();
        context.getWorkbenchFrame().setStatusMessage(message);
        Coordinate min = new Coordinate(selectedBB.getWestBound(), selectedBB.getSouthBound());
        Coordinate max = new Coordinate(selectedBB.getEastBound(), selectedBB.getNorthBound());
        Envelope env = new Envelope(min, max);
        context.getLayerViewPanel().getViewport().zoom(env);
        context.getLayerViewPanel().fireSelectionChanged();
        context.getActiveInternalFrame().updateUI();
    }

    private JComboBox<String> makeComboBox(Map<String, BoundingBox> boundingBoxesForSRS) {
        JComboBox<Object> comboBox = new JComboBox<String>();
        if (boundingBoxesForSRS.size() > 0) {
            Object[] keys = boundingBoxesForSRS.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            comboBox = new JComboBox<Object>(keys);
        } else {
            comboBox.addItem(I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.no-bounding-boxes-available"));
        }
        return comboBox;
    }

    void showInformationTable(PlugInContext context) throws Exception {
        this.values = this.getMapLayerInformationForTable(context);
        this.columnNames = MapLayerAttributes.getColumnNames();
        InfoTableModel itm = new InfoTableModel();
        this.infoTable = new JTable(itm);
        JTableHeader th = this.infoTable.getTableHeader();
        th.setReorderingAllowed(false);
        th.addMouseListener(new MASort());
        this.tcm = this.infoTable.getColumnModel();
        TableColumn tc0 = this.tcm.getColumn(0);
        TableColumn tc1 = this.tcm.getColumn(1);
        TableColumn tc2 = this.tcm.getColumn(2);
        TableColumn tc3 = this.tcm.getColumn(3);
        TableColumn tc4 = this.tcm.getColumn(4);
        TableColumn tc5 = this.tcm.getColumn(5);
        TableColumn tc6 = this.tcm.getColumn(6);
        tc0.setMinWidth(160);
        tc1.setMinWidth(120);
        tc2.setMinWidth(70);
        tc3.setMinWidth(90);
        tc4.setMinWidth(90);
        tc5.setMinWidth(90);
        tc6.setMinWidth(90);
        th.setResizingAllowed(true);
        this.infoTable.setAutoResizeMode(0);
        this.infoTableSc = new JScrollPane(this.infoTable);
        this.infoTableSc.setPreferredSize(new Dimension(735, 300));
        JOptionPane.showMessageDialog(context.getWorkbenchFrame(), this.infoTableSc, "InfoTable", 1);
    }

    Object[][] getMapLayerInformationForTable(PlugInContext context) throws Exception {
        MapLayerAttributes mapLayerAttr = new MapLayerAttributes();
        ArrayList<MapLayerAttributes> mapLayerRows = new ArrayList<MapLayerAttributes>();
        Set<MapLayer> mapLayerSet = this.getAllMapLayer(context);
        if (mapLayerSet == null) {
            return null;
        }
        int anzLayer = mapLayerSet.size();
        if (anzLayer == 0) {
            return null;
        }
        for (MapLayer mapLayer : mapLayerSet) {
            mapLayerRows.addAll(mapLayerAttr.getMapLayerRows(mapLayer));
        }
        int anzRows = mapLayerRows.size();
        int anzColumns = MapLayerAttributes.getColumnNames().length;
        Object[][] mapLayerInformationForTable = new Object[anzRows][anzColumns];
        for (int k = 0; k < anzRows; ++k) {
            MapLayerAttributes mLA = (MapLayerAttributes)mapLayerRows.get(k);
            Object[] attrib = mLA.toObjectArray();
            for (int m = 0; m < attrib.length; ++m) {
                mapLayerInformationForTable[k][m] = attrib[m];
            }
        }
        return mapLayerInformationForTable;
    }

    String[][] getMapLayerInformationForTable(MapLayerAttributes[] mapLayerAttributesArray) {
        int numRows = mapLayerAttributesArray.length;
        int numCols = MapLayerAttributes.getColumnNames().length;
        String[][] mapLayerInformationForTable = new String[numRows][numCols];
        for (int k = 0; k < numRows; ++k) {
            MapLayerAttributes mLA = mapLayerAttributesArray[k];
            Object[] attrib = mLA.toObjectArray();
            for (int m = 0; m < attrib.length; ++m) {
                this.values[k][m] = attrib[m];
            }
        }
        return mapLayerInformationForTable;
    }

    private void sortTable(int sortAfter) {
        Object[] mapLayerAttributes = this.toMapLayerAttributesArray(this.values);
        MapLayerAttributes.setSortAfter(sortAfter);
        Arrays.sort(mapLayerAttributes);
        this.getMapLayerInformationForTable((MapLayerAttributes[])mapLayerAttributes);
        this.infoTable.updateUI();
    }

    MapLayerAttributes[] toMapLayerAttributesArray(Object[][] m) {
        if (m == null) {
            return null;
        }
        int numRows = m.length;
        MapLayerAttributes[] mapLayerAttributesArray = new MapLayerAttributes[numRows];
        for (int i = 0; i < numRows; ++i) {
            String title = (String)m[i][0];
            String name = (String)m[i][1];
            String srs = (String)m[i][2];
            double minx = (Double)m[i][3];
            double miny = (Double)m[i][4];
            double maxx = (Double)m[i][5];
            double maxy = (Double)m[i][6];
            mapLayerAttributesArray[i] = new MapLayerAttributes(title, name, srs, minx, miny, maxx, maxy);
        }
        return mapLayerAttributesArray;
    }

    private static class MapLayerAttributes
    implements Comparable {
        static final int SORT_UP = 1;
        static final int SORT_DOWN = -1;
        static final int SORT_AFTER_TITLE = 1;
        static final int SORT_AFTER_NAME = 2;
        static final int SORT_AFTER_SRS = 3;
        static final int SORT_AFTER_MINX = 4;
        static final int SORT_AFTER_MINY = 5;
        static final int SORT_AFTER_MAXX = 6;
        static final int SORT_AFTER_MAXY = 7;
        static int[] sortUpDown = new int[]{-1, -1, -1, -1, -1, -1, -1};
        static int sortAfter;
        String srs;
        String name;
        String title;
        double minx;
        double miny;
        double maxx;
        double maxy;

        MapLayerAttributes() {
            this.srs = " ";
            this.name = "Unknown";
            this.title = "Unknown";
            this.minx = 0.0;
            this.miny = 0.0;
            this.maxx = 0.0;
            this.maxy = 0.0;
        }

        MapLayerAttributes(String title, String name, String srs, double minx, double miny, double maxx, double maxy) {
            this.title = title;
            this.name = name;
            this.srs = srs;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        public int compareTo(Object object) {
            int ret = 1;
            MapLayerAttributes mla = (MapLayerAttributes)object;
            if (sortAfter == 1) {
                ret = this.title.compareTo(mla.title) * sortUpDown[0];
            } else if (sortAfter == 2) {
                ret = this.name.compareTo(mla.name) * sortUpDown[1];
            } else if (sortAfter == 3) {
                ret = this.srs.compareTo(mla.srs) * sortUpDown[2];
            } else if (sortAfter == 4) {
                ret = this.minx > mla.minx ? 1 * sortUpDown[3] : -1 * sortUpDown[3];
            } else if (sortAfter == 5) {
                ret = this.miny > mla.miny ? 1 * sortUpDown[4] : -1 * sortUpDown[4];
            } else if (sortAfter == 6) {
                ret = this.maxx > mla.maxx ? 1 * sortUpDown[5] : -1 * sortUpDown[5];
            } else if (sortAfter == 7) {
                ret = this.maxy > mla.maxy ? 1 * sortUpDown[6] : -1 * sortUpDown[6];
            }
            return ret;
        }

        double cutDouble(double value, int afterComma) {
            double mulQuot = Math.pow(10.0, afterComma);
            long tmp = (long)(value * mulQuot);
            return (double)tmp / mulQuot;
        }

        public static String[] getColumnNames() {
            return new String[]{"Title", "Name", "SRS", "MinX", "MinY", "MaxX", "MaxY"};
        }

        List<MapLayerAttributes> getMapLayerRows(MapLayer mapLayer) {
            String title;
            String unknown = "Unknown";
            ArrayList<MapLayerAttributes> mapLayerRows = new ArrayList<MapLayerAttributes>();
            String name = mapLayer.getName();
            if (name == null) {
                name = unknown;
            }
            if ((title = mapLayer.getTitle()) == null) {
                title = unknown;
            }
            List<BoundingBox> boundingBoxList = mapLayer.getAllBoundingBoxList();
            for (BoundingBox bb : boundingBoxList) {
                double maxY;
                double maxX;
                double minY;
                double minX;
                String srs;
                if (bb == null) {
                    srs = unknown;
                    minX = 0.0;
                    minY = 0.0;
                    maxX = 400.0;
                    maxY = 400.0;
                } else {
                    srs = bb.getSRS().toLowerCase();
                    minX = bb.getWestBound();
                    minY = bb.getSouthBound();
                    maxX = bb.getEastBound();
                    maxY = bb.getNorthBound();
                }
                mapLayerRows.add(new MapLayerAttributes(title, name, srs, minX, minY, maxX, maxY));
            }
            return mapLayerRows;
        }

        String getName() {
            return this.name;
        }

        String getTitle() {
            return this.title;
        }

        String getSRS() {
            return this.srs;
        }

        double getMinx() {
            return this.minx;
        }

        double getMiny() {
            return this.miny;
        }

        double getMaxx() {
            return this.maxx;
        }

        double getMaxy() {
            return this.maxy;
        }

        Object[] toObjectArray() {
            int anzColumns = MapLayerAttributes.getColumnNames().length;
            Object[] objectArray = new Object[anzColumns];
            objectArray[0] = this.getTitle();
            objectArray[1] = this.getName();
            objectArray[2] = this.getSRS();
            objectArray[3] = Double.valueOf(String.valueOf(this.getMinx()));
            objectArray[4] = Double.valueOf(String.valueOf(this.getMiny()));
            objectArray[5] = Double.valueOf(String.valueOf(this.getMaxx()));
            objectArray[6] = Double.valueOf(String.valueOf(this.getMaxy()));
            return objectArray;
        }

        static void setSortAfter(int sortAfter) {
            if (sortAfter == 1) {
                MapLayerAttributes.sortUpDown[0] = -1 * sortUpDown[0];
            }
            if (sortAfter == 2) {
                MapLayerAttributes.sortUpDown[1] = -1 * sortUpDown[1];
            }
            if (sortAfter == 3) {
                MapLayerAttributes.sortUpDown[2] = -1 * sortUpDown[2];
            }
            if (sortAfter == 4) {
                MapLayerAttributes.sortUpDown[3] = -1 * sortUpDown[3];
            }
            if (sortAfter == 5) {
                MapLayerAttributes.sortUpDown[4] = -1 * sortUpDown[4];
            }
            if (sortAfter == 6) {
                MapLayerAttributes.sortUpDown[5] = -1 * sortUpDown[5];
            }
            if (sortAfter == 7) {
                MapLayerAttributes.sortUpDown[6] = -1 * sortUpDown[6];
            }
            MapLayerAttributes.sortAfter = sortAfter;
        }
    }

    private class MASort
    extends MouseAdapter {
        private MASort() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.getButton() == 3) {
                int viewColumn = ZoomToWMSLayerPlugIn.this.tcm.getColumnIndexAtX(me.getX());
                int column = ZoomToWMSLayerPlugIn.this.infoTable.convertColumnIndexToModel(viewColumn);
                if (column == 0) {
                    ZoomToWMSLayerPlugIn.this.sortTable(1);
                } else if (column == 1) {
                    ZoomToWMSLayerPlugIn.this.sortTable(2);
                } else if (column == 2) {
                    ZoomToWMSLayerPlugIn.this.sortTable(3);
                } else if (column == 3) {
                    ZoomToWMSLayerPlugIn.this.sortTable(4);
                } else if (column == 4) {
                    ZoomToWMSLayerPlugIn.this.sortTable(5);
                } else if (column == 5) {
                    ZoomToWMSLayerPlugIn.this.sortTable(6);
                } else if (column == 6) {
                    ZoomToWMSLayerPlugIn.this.sortTable(7);
                }
            }
        }
    }

    private class InfoTableModel
    extends AbstractTableModel {
        private InfoTableModel() {
        }

        @Override
        public int getColumnCount() {
            return ZoomToWMSLayerPlugIn.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ZoomToWMSLayerPlugIn.this.values.length;
        }

        @Override
        public String getColumnName(int col) {
            return ZoomToWMSLayerPlugIn.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return ZoomToWMSLayerPlugIn.this.values[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class ShowInfoActionListener
    implements ActionListener {
        PlugInContext context;

        ShowInfoActionListener(PlugInContext context) {
            this.context = context;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("showInfoTable")) {
                try {
                    ZoomToWMSLayerPlugIn.this.showInformationTable(this.context);
                }
                catch (Exception e) {
                    Logger.error("Error in ShowInfoActionListener", e);
                }
            }
        }
    }
}

