/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view.showcenter;

import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openjump.core.ui.plugin.view.showcenter.ShowViewCenterPlugIn;

public class ShowViewCenterRenderer
extends SimpleRenderer {
    public static final String CONTENT_ID = "SHOW_CROSSHAIR";
    ImageIcon icon_3 = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon3.gif")), 30);
    ImageIcon icon_2 = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon2.gif")), 30);
    ImageIcon icon = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon.gif")), 30);
    private static final String ENABLED_KEY = ShowViewCenterRenderer.class + " - ENABLED";
    private Stroke stroke = new BasicStroke();

    public ShowViewCenterRenderer(LayerViewPanel panel) {
        super(CONTENT_ID, panel);
    }

    @Override
    protected void paint(Graphics2D g) throws Exception {
        if (!ShowViewCenterRenderer.isEnabled(this.panel)) {
            return;
        }
        Viewport view = this.panel.getViewport();
        g.setStroke(this.stroke);
        this.paintScaleLabel(g, view);
    }

    private void paintScaleLabel(Graphics2D graphics, Viewport viewport) throws Exception {
        Integer dimension = (Integer)ShowViewCenterPlugIn.dimensionSpinner.getValue();
        Image image = null;
        ImageIcon imageIcon = null;
        if (ShowViewCenterPlugIn.radio_button.isSelected()) {
            imageIcon = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon.gif")), dimension);
        } else if (ShowViewCenterPlugIn.radio_button_2.isSelected()) {
            imageIcon = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon2.gif")), dimension);
        } else if (ShowViewCenterPlugIn.radio_button_3.isSelected()) {
            imageIcon = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon3.gif")), dimension);
        }
        image = imageIcon.getImage();
        graphics.setColor(Color.RED);
        Point2D viewCentre = viewport.toViewPoint(EnvelopeUtil.centre(viewport.getEnvelopeInModelCoordinates()));
        graphics.drawImage(image, (int)viewCentre.getX() - imageIcon.getIconWidth() / 2, (int)viewCentre.getY() - imageIcon.getIconHeight() / 2, null);
    }

    public static boolean isEnabled(LayerViewPanel panel) {
        return panel.getBlackboard().get(ENABLED_KEY, false);
    }

    public static void setEnabled(boolean enabled, LayerViewPanel panel) {
        panel.getBlackboard().put(ENABLED_KEY, enabled);
    }

    public void setMyPlugInContext(PlugInContext myPlugInContext) {
    }

    public Image makeImage(Shape s) {
        Rectangle r = s.getBounds();
        BufferedImage image = new BufferedImage(r.width, r.height, 2);
        Graphics2D gr = image.createGraphics();
        gr.translate(-r.x, -r.y);
        gr.draw(s);
        gr.dispose();
        return image;
    }
}

