/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.analysis.onelayer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;

public class MergePolygonsWithNeighbourPlugIn
extends ThreadedBasePlugIn {
    private String sMergeTwoPolys = "Merge Selected Polygons with Neighbours (v2)";
    private String sFeaturesFromDifferentLayer = "Error: Features from different layers!";
    private String sTitle;
    private String sSidebar = "Merges selected polygons with neighboring polygons, either with the one that is largest of all neighbors, or the one with which it has the longest common boundary. Note, the function may return multi-polygons if the polygons to merge have only one point in common.";
    boolean useArea = true;
    boolean useBorder = false;
    String sUseArea = "merge with neighbor that has the largest area";
    String sUseBorder = "merge with neighbor with the longest common edge";
    String sChoseMergeMethod = "Please chose the merge method:";
    String sMerged = "merged";
    String sSearchingForMergeCandidates = "Searching for merge candidates...";
    String sMergingPolygons = "Merging polygons...";
    boolean useAttribute = false;
    String sUseAttribute = "Use an attribute";
    String sUseAttributeTooltip = "Merge features with same attribute value only";
    String sAttributeToUse = "Attribute to use";
    String sSkipNullValues = "Skip features with null attribute value";
    String attribute = null;
    boolean skipNullValues = true;
    String layerName;
    String sMinimumArea;
    double minimumArea = 10.0;
    boolean featuresSelected = false;
    static final String sMERGEMETHOD = "MERGE METHOD";
    String sCreateNewLayer = "Create new layer for result";
    boolean createNewLayer = false;
    private MultiInputDialog dialog;
    Comparator<Feature> areaComparator = (o1, o2) -> {
        double diff = o1.getGeometry().getArea() - o2.getGeometry().getArea();
        return diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
    };

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.sMergeTwoPolys = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Merge-Selected-Polygons-with-Neighbours");
        this.sFeaturesFromDifferentLayer = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.features-from-different-layers");
        this.sSidebar = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.description");
        this.sUseArea = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.merge-with-neighbor-that-has-the-largest-area");
        this.sUseBorder = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.merge-with-neighbor-with-the-longest-common-edge");
        this.sChoseMergeMethod = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Please-chose-the-merge-method");
        this.sMerged = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.merged");
        this.sSearchingForMergeCandidates = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Searching-for-merge-candidates");
        this.sMergingPolygons = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Merging-polygons");
        this.sUseAttribute = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Use-attribute");
        this.sUseAttributeTooltip = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Use-attribute-tooltip");
        this.sAttributeToUse = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Attribute");
        this.sSkipNullValues = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Skip-null-values");
        this.sMinimumArea = I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.minimum-area");
        this.sCreateNewLayer = I18N.JUMP.get("ui.plugin.analysis.GeometryFunctionPlugIn.Create-new-layer-for-result");
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, MergePolygonsWithNeighbourPlugIn.createEnableCheck(context.getWorkbenchContext()).add(context.getCheckFactory().createExactlyNLayersMustBeSelectedCheck(1)));
    }

    @Override
    public String getName() {
        return this.sMergeTwoPolys;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer[] selectedLayers = context.getLayerNamePanel().getSelectedLayers();
        Collection<Layer> layersWithSelectedItems = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        if (selectedLayers.length != 1) {
            throw new Exception(I18N.JUMP.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-be-selected"));
        }
        Layer layer = selectedLayers[0];
        if (layersWithSelectedItems.size() > 1 || layersWithSelectedItems.size() == 1 && !layersWithSelectedItems.contains(layer)) {
            context.getWorkbenchFrame().warnUser(this.sFeaturesFromDifferentLayer);
            return false;
        }
        this.featuresSelected = !context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(layer).isEmpty();
        this.layerName = layer.getName();
        this.sTitle = layersWithSelectedItems.isEmpty() ? I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.merge-small-polygons", this.layerName) : I18N.JUMP.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.merge-selected-polygons", this.layerName);
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.dialog.addSubTitle(this.sTitle);
        this.dialog.addSeparator();
        this.dialog.setSideBarDescription(this.sSidebar);
        String METHODGROUP = sMERGEMETHOD;
        this.dialog.addLabel(this.sChoseMergeMethod);
        this.dialog.addRadioButton(this.sUseArea, sMERGEMETHOD, this.useArea, this.sUseArea);
        this.dialog.addRadioButton(this.sUseBorder, sMERGEMETHOD, this.useBorder, this.sUseBorder);
        if (!this.featuresSelected) {
            JTextField minimumAreaTF = this.dialog.addDoubleField(this.sMinimumArea, this.minimumArea, 12);
            minimumAreaTF.setEnabled(!this.featuresSelected);
        }
        JCheckBox jcbCreateLayer = this.dialog.addCheckBox(this.sCreateNewLayer, this.createNewLayer);
        if (context.getLayerManager().getLayer(this.layerName).isEditable()) {
            jcbCreateLayer.setVisible(true);
        } else {
            jcbCreateLayer.setVisible(false);
            jcbCreateLayer.setSelected(true);
            this.dialog.addLabel("<html><b>" + this.sCreateNewLayer + "</b></html>").setEnabled(false);
        }
        List<String> attributes = AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(context.getLayerManager().getLayer(this.layerName));
        this.dialog.addSeparator();
        JCheckBox jcbUseAttribute = this.dialog.addCheckBox(this.sUseAttribute, this.useAttribute);
        JComboBox<String> jcbAttribute = this.dialog.addComboBox(this.sAttributeToUse, this.attribute, attributes, null);
        jcbAttribute.setEnabled(this.useAttribute);
        JCheckBox jcbSkipNullValues = this.dialog.addCheckBox(this.sSkipNullValues, this.skipNullValues, null);
        jcbSkipNullValues.setEnabled(this.useAttribute);
        jcbUseAttribute.addActionListener(e -> {
            jcbAttribute.setEnabled(jcbUseAttribute.isSelected());
            jcbSkipNullValues.setEnabled(jcbUseAttribute.isSelected());
            jcbSkipNullValues.setEnabled(jcbUseAttribute.isSelected());
        });
        if (attributes.isEmpty()) {
            jcbUseAttribute.setSelected(false);
            jcbUseAttribute.setEnabled(false);
        }
        GUIUtil.centreOnWindow(this.dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.useArea = dialog.getBoolean(this.sUseArea);
        this.useBorder = dialog.getBoolean(this.sUseBorder);
        this.useAttribute = dialog.getBoolean(this.sUseAttribute);
        if (this.useAttribute) {
            this.attribute = (String)dialog.getComboBox(this.sAttributeToUse).getSelectedItem();
            this.skipNullValues = dialog.getBoolean(this.sSkipNullValues);
        } else {
            this.attribute = null;
        }
        if (!this.featuresSelected) {
            this.minimumArea = dialog.getDouble(this.sMinimumArea);
        }
        this.createNewLayer = dialog.getBoolean(this.sCreateNewLayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Feature feature;
        monitor.allowCancellationRequests();
        monitor.report("Prepare data");
        Layer activeLayer = context.getLayerManager().getLayer(this.layerName);
        Collection<Feature> selectedFeatures = context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Feature> selection = new ArrayList<Feature>();
        for (Feature feature2 : activeLayer.getFeatureCollectionWrapper().getFeatures()) {
            Feature f2 = this.createNewLayer ? feature2.clone(true) : feature2;
            features.add(f2);
            if (!selectedFeatures.contains(feature2)) continue;
            selection.add(f2);
        }
        Quadtree index = new Quadtree();
        monitor.report("Index data");
        for (Feature feature3 : features) {
            index.insert(feature3.getGeometry().getEnvelopeInternal(), (Object)feature3);
        }
        HashMap<Feature, LinkedHashSet<Feature>> hashMap = new HashMap<Feature, LinkedHashSet<Feature>>();
        ArrayList<Feature> sortedList = new ArrayList<Feature>();
        monitor.report("Merge data");
        if (this.featuresSelected) {
            sortedList.addAll(selection);
            int total = selection.size();
            sortedList.sort(this.areaComparator);
            int count = 0;
            while (!sortedList.isEmpty()) {
                monitor.report(count++, total, "merged");
                feature = (Feature)sortedList.get(0);
                this.merge(feature, (SpatialIndex)index, sortedList, hashMap);
            }
        } else {
            sortedList.addAll(features);
            sortedList.sort(this.areaComparator);
            int count = 0;
            int total = (int)sortedList.stream().filter(f -> f.getGeometry().getArea() <= this.minimumArea).count();
            while (sortedList.size() > 0 && ((Feature)sortedList.get(0)).getGeometry().getArea() <= this.minimumArea) {
                feature = sortedList.get(0);
                Feature merged = this.merge(feature, (SpatialIndex)index, sortedList, hashMap);
                if (count % 10 == 0) {
                    long pm = (long)count * 1000L / (long)total;
                    monitor.report("" + (double)pm / 10.0 + "% merged");
                }
                ++count;
                if (merged == null || !(merged.getGeometry().getArea() <= this.minimumArea)) continue;
                ++total;
            }
        }
        if (this.createNewLayer) {
            monitor.report("Compute result (create new layer)");
            for (Map.Entry entry : hashMap.entrySet()) {
                Iterator it = ((LinkedHashSet)entry.getValue()).iterator();
                while (it.hasNext()) {
                    features.remove(it.next());
                }
                features.add((Feature)entry.getKey());
            }
            FeatureDataset dataset = new FeatureDataset(activeLayer.getFeatureCollectionWrapper().getFeatureSchema());
            dataset.addAll(features);
            context.getLayerManager().addCategory(StandardCategoryNames.RESULT);
            context.addLayer(StandardCategoryNames.RESULT, this.layerName + "-merged", dataset);
        } else {
            context.getWorkbenchContext().getLayerManager().setFiringEvents(false);
            monitor.report("Prepare transaction");
            this.reportNothingToUndoYet(context);
            activeLayer.getLayerManager().getUndoableEditReceiver().startReceiving();
            try {
                EditTransaction transaction = new EditTransaction(new ArrayList<Feature>(), "MergePolygonWithNeighbour", activeLayer, true, true, context.getLayerViewPanel());
                for (Map.Entry entry : hashMap.entrySet()) {
                    while (((LinkedHashSet)entry.getValue()).size() > 1) {
                        Feature f3 = (Feature)((LinkedHashSet)entry.getValue()).iterator().next();
                        transaction.deleteFeature(f3);
                        ((LinkedHashSet)entry.getValue()).remove(f3);
                    }
                    transaction.modifyFeatureGeometry((Feature)((LinkedHashSet)entry.getValue()).iterator().next(), ((Feature)entry.getKey()).getGeometry());
                }
                transaction.commit();
                context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().clear();
                context.getWorkbenchContext().getLayerViewPanel().repaint();
            }
            finally {
                context.getWorkbenchContext().getLayerManager().setFiringEvents(true);
                activeLayer.getLayerManager().getUndoableEditReceiver().stopReceiving();
            }
        }
    }

    private Feature merge(Feature feature, SpatialIndex index, ArrayList<Feature> sortedList, Map<Feature, LinkedHashSet<Feature>> genealogy) throws Exception {
        sortedList.remove(feature);
        index.remove(feature.getGeometry().getEnvelopeInternal(), (Object)feature);
        List candidates = index.query(feature.getGeometry().getEnvelopeInternal());
        Feature bestCandidate = this.getBestCandidate(feature, candidates);
        if (bestCandidate != null) {
            Geometry newGeom = feature.getGeometry().union(bestCandidate.getGeometry());
            Feature newFeature = bestCandidate.clone();
            newFeature.setGeometry(newGeom);
            LinkedHashSet<Feature> children = new LinkedHashSet<Feature>();
            genealogy.put(newFeature, children);
            if (genealogy.containsKey(feature)) {
                children.addAll((Collection)genealogy.get(feature));
            } else {
                children.add(feature);
            }
            genealogy.remove(feature);
            if (genealogy.containsKey(bestCandidate)) {
                children.addAll((Collection)genealogy.get(bestCandidate));
            } else {
                children.add(bestCandidate);
            }
            genealogy.remove(bestCandidate);
            sortedList.remove(bestCandidate);
            index.remove(bestCandidate.getGeometry().getEnvelopeInternal(), (Object)bestCandidate);
            index.insert(newGeom.getEnvelopeInternal(), (Object)newFeature);
            if (!this.featuresSelected && this.minimumArea > 0.0) {
                int idx = Collections.binarySearch(sortedList, newFeature, this.areaComparator);
                if (idx >= 0) {
                    sortedList.add(idx, newFeature);
                } else {
                    sortedList.add(-idx - 1, newFeature);
                }
            }
            return newFeature;
        }
        return null;
    }

    private Feature getBestCandidate(Feature feature, List<Feature> candidates) throws Exception {
        if (this.useArea) {
            return this.getBestCandidateUsingArea(feature, candidates);
        }
        if (this.useBorder) {
            return this.getBestCandidateUsingBorder(feature, candidates);
        }
        throw new Exception("No method has been selected to choose the feature to merge to : use 'max area' ore use 'common border length'");
    }

    private Feature getBestCandidateUsingArea(Feature feature, List<Feature> candidates) {
        Feature bestCandidate = null;
        double maxArea = 0.0;
        for (Feature candidate : this.filterCandidates(feature, candidates)) {
            double area = candidate.getGeometry().getArea();
            IntersectionMatrix im = feature.getGeometry().relate(candidate.getGeometry());
            if (!im.matches("2********") && !im.matches("****1****") || !(area > maxArea)) continue;
            bestCandidate = candidate;
            maxArea = area;
        }
        return bestCandidate;
    }

    private Feature getBestCandidateUsingBorder(Feature feature, List<Feature> candidates) {
        Feature bestCandidate = null;
        double maxLength = 0.0;
        for (Feature candidate : this.filterCandidates(feature, candidates)) {
            double length;
            IntersectionMatrix im = feature.getGeometry().relate(candidate.getGeometry());
            if (!im.matches("****1****") || !((length = feature.getGeometry().getBoundary().intersection(candidate.getGeometry().getBoundary()).getLength()) > maxLength)) continue;
            maxLength = length;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }

    private Collection<Feature> filterCandidates(Feature feature, Collection<Feature> candidates) {
        if (this.attribute != null) {
            ArrayList<Feature> list = new ArrayList<Feature>();
            Object ref = feature.getAttribute(this.attribute);
            if ((ref == null || ref.toString().isEmpty()) && this.skipNullValues) {
                return list;
            }
            for (Feature c : candidates) {
                if ((ref == null || ref.toString().isEmpty()) && !this.skipNullValues) {
                    if (c.getAttribute(this.attribute) != null) continue;
                    list.add(c);
                    continue;
                }
                if (ref == null || ref.toString().isEmpty() || c.getAttribute(this.attribute) == null || !ref.equals(c.getAttribute(this.attribute))) continue;
                list.add(c);
            }
            return list;
        }
        return candidates;
    }
}

